<?php 

// Begin Shortcodes
class Jobzilla_WPJM_Shortcodes {
    
	
	/**
	 * The single instance of the class.
	 *
	 * @var self
	 * @since  1.26.0
	 */
	private static $instance = null;
    
	/**
	 * Allows for accessing single instance of class. Class should only be constructed once per call.
	 *
	 * @since  1.26.0
	 * @static
	 * @return self Main instance.
	 */
	public static function instance() {
		
		if ( is_null( self::$instance ) ) {
			self::$instance = new self();
		}
		return self::$instance;
	}
	
	function __construct() {
		//Initialize shortcodes
		add_shortcode(  'jobs', array( $this, 'jobzilla_wpjm_jobs' ));
        add_shortcode(  'resumes', array( $this, 'jobzilla_wpjm_resumes' ));
		add_shortcode('jobzilla_user_profile',  array( $this,'user_profile'));	
        add_shortcode('jobzilla_change_password',  array( $this,'jobzilla_user_change_password'));
		
	}
	
	
	/**
	 * Gets string as a bool.
	 *
	 * @param  string $value
	 * @return bool
	 */
	public function string_to_bool( $value ) {
		return ( is_bool( $value ) && $value ) || in_array( $value, [ 1, '1', 'true', 'yes' ], true );
	}
	
	public function jobzilla_wpjm_jobs( $atts ) {
		ob_start();
		echo "<script>
				jQuery(document).ready(function(){
					if(jQuery('.elementor-element-edit-mode').length > 0){
						jQuery('select').selectpicker();
					}					
				});
			 </script>
			";
		wp_enqueue_script( 'jobzilla-wp-job-manager-ajax-filters' );
		$atts = shortcode_atts(
			apply_filters(
				'job_manager_output_jobs_defaults',
				[
					'per_page'                  => get_option( 'job_manager_per_page' ),
					'orderby'                   => 'featured',
					'order'                     => 'DESC',

					// Filters + cats.
					'show_filters'              => true,
					'show_categories'           => true,
					'show_category_multiselect' => get_option( 'job_manager_enable_default_category_multiselect', false ),
					'show_pagination'           => 'pagination' === get_option( 'job_manager_job_listing_pagination_type' ) ? true : false,
					'show_more'                 => 'load_more' === get_option( 'job_manager_job_listing_pagination_type' ) ? true : false,

					// Limit what jobs are shown based on category, post status, and type.
					'categories'                => '',
					'job_types'                 => '',
					'post_status'               => '',
					'featured'                  => null, // True to show only featured, false to hide featured, leave null to show both.
					'filled'                    => null, // True to show only filled, false to hide filled, leave null to show both/use the settings.

					// Default values for filters.
					'location'                  => '',
					'keywords'                  => '',
					'selected_category'         => '',
					'selected_job_types'        => implode( ',', array_values( get_job_listing_types( 'id=>slug' ) ) ),
					'list_layout'				=> 'list',
					'job_filter_view'			=> 'sidebar',
					
				] 
			),
			$atts
		);

		if ( ! get_option( 'job_manager_enable_categories' ) ) {
			$atts['show_categories'] = false;
		}
		
		// String and bool handling.
		$atts['show_filters']              = $this->string_to_bool( $atts['show_filters'] );
		$atts['show_categories']           = $this->string_to_bool( $atts['show_categories'] );
		$atts['show_category_multiselect'] = $this->string_to_bool( $atts['show_category_multiselect'] );
		$atts['show_more']                 = $this->string_to_bool( $atts['show_more'] );
		$atts['show_pagination']           = $this->string_to_bool( $atts['show_pagination'] );
		
		if ( ! is_null( $atts['featured'] ) ) {
			$atts['featured'] = ( is_bool( $atts['featured'] ) && $atts['featured'] ) || in_array( $atts['featured'], [ 1, '1', 'true', 'yes' ], true );
		}

		if ( ! is_null( $atts['filled'] ) ) {
			$atts['filled'] = ( is_bool( $atts['filled'] ) && $atts['filled'] ) || in_array( $atts['filled'], [ 1, '1', 'true', 'yes' ], true );
		}
		
		// By default, use client-side state to populate form fields.
		$disable_client_state = false;
		
		// Get keywords, location, category and type from querystring if set.
		// phpcs:disable WordPress.Security.NonceVerification.Recommended -- Input is used safely.
		if ( ! empty( $_GET['search_keywords'] ) ) {
			$atts['keywords']     = sanitize_text_field( wp_unslash( $_GET['search_keywords'] ) );
			$disable_client_state = true;
		}
		if ( ! empty( $_GET['search_location'] ) ) {
			$atts['location']     = sanitize_text_field( wp_unslash( $_GET['search_location'] ) );
			$disable_client_state = true;
		}
		if ( ! empty( $_GET['search_category'] ) ) {
			$atts['selected_category'] = sanitize_text_field( wp_unslash( $_GET['search_category'] ) );
			$disable_client_state      = true;
		}
		if ( ! empty( $_GET['search_job_type'] ) ) {
			$atts['selected_job_types'] = sanitize_text_field( wp_unslash( $_GET['search_job_type'] ) );
			$disable_client_state       = true;
		}
		// phpcs:enable WordPress.Security.NonceVerification.Recommended

		// Array handling.
		$atts['categories']         = is_array( $atts['categories'] ) ? $atts['categories'] : array_filter( array_map( 'trim', explode( ',', $atts['categories'] ) ) );
		$atts['selected_category']  = is_array( $atts['selected_category'] ) ? $atts['selected_category'] : array_filter( array_map( 'trim', explode( ',', $atts['selected_category'] ) ) );
		$atts['job_types']          = is_array( $atts['job_types'] ) ? $atts['job_types'] : array_filter( array_map( 'trim', explode( ',', $atts['job_types'] ) ) );
		$atts['post_status']        = is_array( $atts['post_status'] ) ? $atts['post_status'] : array_filter( array_map( 'trim', explode( ',', $atts['post_status'] ) ) );
		$atts['selected_job_types'] = is_array( $atts['selected_job_types'] ) ? $atts['selected_job_types'] : array_filter( array_map( 'trim', explode( ',', $atts['selected_job_types'] ) ) );

		// Normalize field for categories.
		if ( ! empty( $atts['selected_category'] ) ) {
			foreach ( $atts['selected_category'] as $cat_index => $category ) {
				if ( ! is_numeric( $category ) ) {
					$term = get_term_by( 'slug', $category, 'job_listing_category' );

					if ( $term ) {
						$atts['selected_category'][ $cat_index ] = $term->term_id;
					}
				}
			}
		}
		if(!empty($atts['list_layout'])){
			$list_layout = $atts['list_layout'];
		}else{
			$list_layout = 'list';
		}
		if(!empty($atts['job_filter_view'])){
			//$job_filter_view = $atts['job_filter_view'];
			if($atts['job_filter_view'] == 'full_width'){
				$job_filter_view = $atts['job_filter_view'];
			}else if($atts['job_filter_view'] == 'sidebar'){
				$job_filter_view = $atts['job_filter_view'];
			}
		}else{
			$job_filter_view = 'sidebar';
		} ?>
		<div class="row" id="DZJobListingContainer">
		<?php
		
		if ( $atts['show_filters'] ) {
			if($job_filter_view == 'full_width'){ 
				get_job_manager_template(
					'job-filters-map.php',
					[
						'per_page'                  => $atts['per_page'],
						'orderby'                   => $atts['orderby'],
						'order'                     => $atts['order'],
						'show_categories'           => $atts['show_categories'],
						'categories'                => $atts['categories'],
						'selected_category'         => $atts['selected_category'],
						'job_types'                 => $atts['job_types'],
						'atts'                      => $atts,
						'location'                  => $atts['location'],
						'keywords'                  => $atts['keywords'],
						'selected_job_types'        => $atts['selected_job_types'],
						'show_category_multiselect' => $atts['show_category_multiselect'],
						'list_layout'				=> $list_layout,
						'job_filter_view'			=> $job_filter_view,
					]
				);
			}else{
				get_job_manager_template(
					'job-filters.php',
					[
						'per_page'                  => $atts['per_page'],
						'orderby'                   => $atts['orderby'],
						'order'                     => $atts['order'],
						'show_categories'           => $atts['show_categories'],
						'categories'                => $atts['categories'],
						'selected_category'         => $atts['selected_category'],
						'job_types'                 => $atts['job_types'],
						'atts'                      => $atts,
						'location'                  => $atts['location'],
						'keywords'                  => $atts['keywords'],
						'selected_job_types'        => $atts['selected_job_types'],
						'show_category_multiselect' => $atts['show_category_multiselect'],
						'list_layout'				=> $list_layout,
						'job_filter_view'			=> $job_filter_view,
					]
				);
			}
			
			get_job_manager_template( 
				'job-listings-start.php', 
				[
					'per_page'                  => $atts['per_page'],
					'orderby'                   => $atts['orderby'],
					'order'                     => $atts['order'],
					'show_categories'           => $atts['show_categories'],
					'categories'                => $atts['categories'],
					'selected_category'         => $atts['selected_category'],
					'job_types'                 => $atts['job_types'],
					'atts'                      => $atts,
					'location'                  => $atts['location'],
					'keywords'                  => $atts['keywords'],
					'selected_job_types'        => $atts['selected_job_types'],
					'job_filter_view' 			=> $job_filter_view,
					'list_layout'				=> $list_layout,
					'show_category_multiselect' => $atts['show_category_multiselect'],
				]
					
			);
			
			get_job_manager_template( 'job-listings-end.php' );
			if ( ! $atts['show_pagination'] && $atts['show_more'] ) {
				echo '<div class="col-md-12 text-center"><a class="load_more_jobs site-button" href="#" style="display:none;"><strong>' . esc_html__( 'Load more listings', 'wp-job-manager' ) . '</strong></a></div>';
			}
		} else {
			
			
			$jobs = get_job_listings(
				apply_filters(
					'job_manager_output_jobs_args',
					[
						'search_location'   => $atts['location'],
						'search_keywords'   => $atts['keywords'],
						'post_status'       => $atts['post_status'],
						'search_categories' => $atts['categories'],
						'job_types'         => $atts['job_types'],
						'orderby'           => $atts['orderby'],
						'order'             => $atts['order'],
						'posts_per_page'    => $atts['per_page'],
						'featured'          => $atts['featured'],
						'filled'            => $atts['filled'], 
						'list_layout'		=> $list_layout,
					]
				)
			);
			
			if ( ! empty( $atts['job_types'] ) ) {
				$data_attributes['job_types'] = implode( ',', $atts['job_types'] );
			}
			
			if ( $jobs->have_posts() ) {
				get_job_manager_template( 'job-listings-start.php', array('list_layout'	=> $list_layout));
				
				
				while ( $jobs->have_posts() ) {
					$jobs->the_post();
					
					get_job_manager_template( 'content-job_listing.php', array('list_layout'	=> $list_layout));
				}
				
				get_job_manager_template( 'job-listings-end.php' );
				
				if ( $jobs->found_posts > $atts['per_page'] && $atts['show_more'] ) {
					wp_enqueue_script( 'wp-job-manager-ajax-filters' );
					if ( $atts['show_pagination'] ) {
						// phpcs:ignore WordPress.Security.EscapeOutput.OutputNotEscaped -- Template output.
						echo get_job_listing_pagination( $jobs->max_num_pages);
					} else {
						echo '<div class="col-md-12 text-center"><a class="load_more_jobs site-button" href="#"><strong>' . esc_html__( 'Load more listings', 'wp-job-manager' ) . '</strong></a></div>';
					}
				}
			
			} else {
				do_action( 'job_manager_output_jobs_no_results' );
			}
			wp_reset_postdata();
		} ?>
		</div>
		<?php 
		$data_attributes_string = '';
		$data_attributes = [
			'location'                   => $atts['location'],
			'keywords'                   => $atts['keywords'],
			'show_filters'               => $atts['show_filters'] ? 'true' : 'false',
			'show_pagination'            => $atts['show_pagination'] ? 'true' : 'false',
			'per_page'                   => $atts['per_page'],
			'orderby'                    => $atts['orderby'],
			'order'                      => $atts['order'],
			'list_layout'				 => $list_layout,
			'categories'                 => implode( ',', $atts['categories'] ),
			'disable-form-state-storage' => $disable_client_state,
			
		];
		
		if ( ! is_null( $atts['featured'] ) ) {
			$data_attributes['featured'] = $atts['featured'] ? 'true' : 'false';
		}
		if ( ! is_null( $atts['filled'] ) ) {
			$data_attributes['filled'] = $atts['filled'] ? 'true' : 'false';
		}
		if ( ! empty( $atts['post_status'] ) ) {
			$data_attributes['post_status'] = implode( ',', $atts['post_status'] );
		}
		
		$data_attributes['post_id'] = isset( $GLOBALS['post'] ) ? $GLOBALS['post']->ID : 0;

		/**
		 * Pass additional data to the job listings <div> wrapper.
		 *
		 * @since 1.34.0
		 *
		 * @param array $data_attributes {
		 *     Key => Value array of data attributes to pass.
		 *
		 *     @type string $$key Value to pass as a data attribute.
		 * }
		 * @param array $atts            Attributes for the shortcode.
		 */
		$data_attributes = apply_filters( 'job_manager_jobs_shortcode_data_attributes', $data_attributes, $atts );
		
		foreach ( $data_attributes as $key => $value ) {
			$data_attributes_string .= 'data-' . esc_attr( $key ) . '="' . esc_attr( $value ) . '" ';
		}
		$job_listings_output = apply_filters( 'job_manager_job_listings_output', ob_get_clean() );
		$content_calss = ($job_filter_view == 'sidebar') ? 'content-inner': '';	
		return '<div class="section-full pagination-outer-wrap '.$content_calss.' site-bg-white"><div class="container"><div class="job_listings" ' . $data_attributes_string . '>' . $job_listings_output . '</div></div></div>';
	}
	
	
	public function jobzilla_wpjm_resumes( $atts ) {
		
		global $resume_manager;
		ob_start();
		echo "<script>
				jQuery(document).ready(function(){
					if(jQuery('.elementor-element-edit-mode').length > 0){
						jQuery('select').selectpicker();
					}					
				});
			 </script>
			";
		wp_enqueue_script( 'jobzilla-wp-resume-manager-ajax-filters' );
		if ( ! resume_manager_user_can_browse_resumes() ) {
			get_job_manager_template_part( 'access-denied', 'browse-resumes', 'wp-job-manager-resumes', RESUME_MANAGER_PLUGIN_DIR . '/templates/' );
			return ob_get_clean();
		}
	
		extract(
			$atts = shortcode_atts(
				apply_filters(
					'resume_manager_output_resumes_defaults',
					[
						'per_page'                  => get_option( 'resume_manager_per_page' ),
						'order'                     => 'DESC',
						'orderby'                   => 'featured',
						'show_filters'              => true,
						'show_categories'           => get_option( 'resume_manager_enable_categories' ),
						'categories'                => '',
						'featured'                  => null, // True to show only featured, false to hide featured, leave null to show both.
						'show_category_multiselect' => get_option( 'resume_manager_enable_default_category_multiselect', false ),
						'selected_category'         => '',
						'show_pagination'           => false,
						'show_more'                 => true,
						'list_layout'				=> 'list',
						'resume_filter_view'        => 'sidebar',
					]
				),
				$atts
			)
		);

		$categories = array_filter( array_map( 'trim', explode( ',', $categories ) ) );
		$keywords   = '';
		$location   = '';

		// String and bool handling
		$show_filters              = $this->string_to_bool( $show_filters );
		$show_categories           = $this->string_to_bool( $show_categories );
		$show_category_multiselect = $this->string_to_bool( $show_category_multiselect );
		$show_more                 = $this->string_to_bool( $show_more );
		$show_pagination           = $this->string_to_bool( $show_pagination );

		if ( ! is_null( $featured ) ) {
			$featured = ( is_bool( $featured ) && $featured ) || in_array( $featured, [ '1', 'true', 'yes' ] ) ? true : false;
		}

		if ( ! empty( $_GET['search_keywords'] ) ) {
			$keywords = sanitize_text_field( $_GET['search_keywords'] );
		}

		if ( ! empty( $_GET['search_location'] ) ) {
			$location = sanitize_text_field( $_GET['search_location'] );
		}

		if ( ! empty( $_GET['search_category'] ) ) {
			$selected_category = sanitize_text_field( $_GET['search_category'] );
		}
		
		if(!empty($atts['list_layout'])){
			$list_layout = $atts['list_layout'];
		}else{
			$list_layout = 'list';
		}
		if(!empty($atts['resume_filter_view'])){
			$resume_filter_view = $atts['resume_filter_view'];
		}else{
			$resume_filter_view = 'sidebar';
		}
		
		?>
				<div class="row">
					<?php 
					if ( $show_filters ) {
						
						get_job_manager_template(
							'resume-filters.php',
							[
								'per_page'                  => $per_page,
								'orderby'                   => $orderby,
								'order'                     => $order,
								'show_categories'           => $show_categories,
								'categories'                => $categories,
								'selected_category'         => $selected_category,
								'atts'                      => $atts,
								'location'                  => $location,
								'keywords'                  => $keywords,
								'list_layout'               => $list_layout,
								'resume_filter_view'        => $resume_filter_view,
								'show_category_multiselect' => $show_category_multiselect,
							],
							'wp-job-manager-resumes',
							RESUME_MANAGER_PLUGIN_DIR . '/templates/'
						);

						get_job_manager_template( 'resumes-start.php', ['resume_filter_view' => $resume_filter_view, 'list_layout'=> $list_layout], 'wp-job-manager-resumes', RESUME_MANAGER_PLUGIN_DIR . '/templates/' );
						get_job_manager_template( 'resumes-end.php', [], 'wp-job-manager-resumes', RESUME_MANAGER_PLUGIN_DIR . '/templates/' );

						if ( ! $show_pagination && $show_more ) {
							echo '<div class="col-md-12 text-center"><a class="load_more_resumes site-button" href="#" style="display:none;"><strong>' . __( 'Load more resumes', 'wp-job-manager-resumes' ) . '</strong></a></div>';
						}
					} else {

						$resumes = get_resumes(
							apply_filters(
								'resume_manager_output_resumes_args',
								[
									'search_categories' => $categories,
									'orderby'           => $orderby,
									'order'             => $order,
									'posts_per_page'    => $per_page,
									'featured'          => $featured,
								]
							)
						);

						if ( $resumes->have_posts() ){

							 get_job_manager_template( 'resumes-start.php', ['list_layout'=> $list_layout], 'wp-job-manager-resumes', RESUME_MANAGER_PLUGIN_DIR . '/templates/' ); 

							while ( $resumes->have_posts() ){
								$resumes->the_post();
								 //get_job_manager_template_part( 'content', 'resume', 'wp-job-manager-resumes', RESUME_MANAGER_PLUGIN_DIR . '/templates/' ); 
								 get_job_manager_template( 'content-resume.php', ['list_layout'=> $list_layout], 'wp-job-manager-resumes', RESUME_MANAGER_PLUGIN_DIR . '/templates/' ); 
							}
							get_job_manager_template( 'resumes-end.php', [], 'wp-job-manager-resumes', RESUME_MANAGER_PLUGIN_DIR . '/templates/' ); 

							 if ( $resumes->found_posts > $per_page && $show_more ) { 

								 wp_enqueue_script( 'wp-resume-manager-ajax-filters' ); 

								if ( $show_pagination ) { 
									 echo get_job_listing_pagination( $resumes->max_num_pages ); 
								}else{ ?>
									<div class="col-md-12 text-center">
									<a class="load_more_resumes site-button" href="#">
										<strong>
											<?php echo esc_html__( 'Load more resumes', 'wp-job-manager-resumes' ); ?>
										</strong>
									</a>
									</div>
								<?php } 

							} 

						}else{
							do_action( 'resume_manager_output_resumes_no_results' );
						}

						wp_reset_postdata();
					} ?>
				</div>
		<?php 
		$data_attributes_string = '';
		$data_attributes        = [
			'location'        => $location,
			'keywords'        => $keywords,
			'show_filters'    => $show_filters ? 'true' : 'false',
			'show_pagination' => $show_pagination ? 'true' : 'false',
			'per_page'        => $per_page,
			'orderby'         => $orderby,
			'order'           => $order,
			'list_layout'     => $list_layout,
			'categories'      => implode( ',', $categories ),
		];
		if ( ! is_null( $featured ) ) {
			$data_attributes['featured'] = $featured ? 'true' : 'false';
		}
		foreach ( $data_attributes as $key => $value ) {
			$data_attributes_string .= 'data-' . esc_attr( $key ) . '="' . esc_attr( $value ) . '" ';
		}
			
		return '<div class="section-full  content-inner site-bg-white"><div class="container"><div class="resumes" ' . $data_attributes_string . '>' . ob_get_clean() . '</div></div></div>';
	
	}
	
	public function user_profile() {
		$user = wp_get_current_user();
		$current_user_id = get_current_user_id();
		$custom_avatar = get_avatar($user->ID,100);
		$user_desc = get_the_author_meta( 'description' , $user->ID);
		$user_desc_stripped = strip_tags($user_desc, '<p>'); 
		
		ob_start();
			$args = array(
				'user' => $user,
				'current_user_id' => $current_user_id,
				'custom_avatar' => $custom_avatar,
				'user_desc' => $user_desc,
				'user_desc_stripped' => $user_desc_stripped,
				
			);
		
			load_template(DZ_TH_ROOT.'includes/include/shortcodes/user_profile.php', true, $args);
			
		return ob_get_clean();
	}
	
	 public function jobzilla_user_change_password() {	
		$user = wp_get_current_user(); 
		$userdata = $user->data;
		$args = array(
				'userdata' => $userdata,
			);
		ob_start();
		
			load_template(DZ_TH_ROOT.'includes/include/shortcodes/change-password.php', true, $args);
			
		return ob_get_clean();
	} 
	
	
}


Jobzilla_WPJM_Shortcodes::instance();
