
jQuery(document).ready(function($){

	var dz_mega_menu_upload;
	var dz_mega_menu_selector;

	function dz_mega_menu_add_file(event, selector) {

		var upload = $(".uploaded-file"), frame;
		var $el = $(this);
		dz_mega_menu_selector = selector;

		event.preventDefault();

		// If the media frame already exists, reopen it.
		if ( dz_mega_menu_upload ) {
			dz_mega_menu_upload.open();
		} else {
			// Create the media frame.
			dz_mega_menu_upload = wp.media.frames.dz_mega_menu_upload =  wp.media({
				// Set the title of the modal.
				title: "Select Image",

				// Customize the submit button.
				button: {
					// Set the text of the button.
					text: "Selected",
					// Tell the button not to close the modal, since we're
					// going to refresh the page when the image is selected.
					close: false
				}
			});

			// When an image is selected, run a callback.
			dz_mega_menu_upload.on( 'select', function() {
				// Grab the selected attachment.
				var attachment = dz_mega_menu_upload.state().get('selection').first();
				dz_mega_menu_upload.close();
				dz_mega_menu_selector.find('.upload_image').val(attachment.attributes.url).change();
				if ( attachment.attributes.type == 'image' ) {
					dz_mega_menu_selector.find('.screenshot').empty().hide().prepend('<img src="' + attachment.attributes.url + '">').slideDown('fast');
				}
			});

		}
		// Finally, open the modal.
		dz_mega_menu_upload.open();
	}

	function dz_mega_menu_remove_file(selector) {
		selector.find('.screenshot').slideUp('fast').next().val('').trigger('change');
	}
	
	$('body').delegate('.upload_image_action .remove-image', 'click', function(event) {
		dz_mega_menu_remove_file( $(this).parent().parent() );
	});

	$('body').delegate('.upload_image_action .add-image', 'click', function(event) {
		dz_mega_menu_add_file(event, $(this).parent().parent());
	});
}); 

	