<?php
namespace DZMMElementor;

use DZMMElementor\Widgets\DZNavMenu;


if( !defined( 'DZMM_ELEMENTOR_ROOT' ) ) { define('DZMM_ELEMENTOR_ROOT', DZ_MEGA_MENU_DIR . '/includes/elementor'); }
if( !defined( 'DZMM_ELEMENTOR_URL' ) ) { define('DZMM_ELEMENTOR_URL', DZ_MEGA_MENU_DIR . '/includes/elementor'); }

#require_once DZMM_ELEMENTOR_ROOT.'/elementor_functions.php';
require_once DZMM_ELEMENTOR_ROOT.'/widgets/DZMMTemplate.php';
		
/**
 * Main DZMM_Elementor Class
 *
 * Register new elementor widget.
 *
 * @since 1.0.0
 */
class DZMMElementor
{

    /**
     * Constructor
     *
     * @since 1.0.0
     *
     * @access public
     */
    public function __construct()
    {
        $this->add_actions();
    }

    /**
     * Add Actions
     *
     * @since 1.0.0
     *
     * @access private
     */
    private function add_actions()
    {
        add_action( 'elementor/widgets/widgets_registered', [ $this, 'on_widgets_registered' ] );
    }


    /**
     * On Widgets Registered
     *
     * @since 1.0.0
     *
     * @access public
     */
    public function on_widgets_registered()
    {
        $this->includes();
        $this->register_widget();
    }

    /**
     * Includes
     *
     * @since 1.0.0
     *
     * @access private
     */
    private function includes()
    {	
		require DZMM_ELEMENTOR_ROOT . '/widgets/nav_menu.php';
	}

    /**
     * Register Widget
     *
     * @since 1.0.0
     *
     * @access private
     */
    private function register_widget()
    {
		
        \Elementor\Plugin::instance()->widgets_manager->register_widget_type( new DZNavMenu() );
    }
}

$obj = new DZMMElementor();





