<?php

namespace DZMMElementor\Widgets;

use Elementor\Widget_Base;

use Elementor\Controls_Manager;

class DZNavMenu extends Widget_Base 
{
	public function get_name() {
		return 'dz-nav-menu';
	}
	
	public function get_title() {
		return esc_html__('Nav Menu','dzmegamenu');
	}
	
	public function get_icon() {
		return 'eicon-menu-bar';
	}
	
	
	
	protected function register_controls() {
		$custom_menus = array('menu' => esc_html__('Choose Menu', 'dzmegamenu'));
        $menus = get_terms( 'nav_menu', array( 'hide_empty' => false ) );
        if ( is_array( $menus ) && ! empty( $menus ) ) {
			//$custom_menus['menu'] = esc_html__('Choose Menu') ;
            foreach ( $menus as $menu ){
                if ( is_object( $menu ) && isset( $menu->name, $menu->slug ) ) {
                    $custom_menus[ $menu->slug ] = $menu->name;
                }
            }
        }

		$this->start_controls_section(
			'general',
			[
				'label' => esc_html__( 'General', 'dzmegamenu' ),
			]
		);
        $this->add_control(
            'nav_menu_title',
            [
                'label' => esc_html__( 'Title', 'dzmegamenu' ),
                'type' => \Elementor\Controls_Manager::TEXT,
                'placeholder' => esc_html__( 'Enter your title here', 'dzmegamenu' ),
            ]
        );

        $this->add_control(
            'nav_menu',
            [
                'label' => esc_html__( 'Menu', 'dzmegamenu' ),
                'type' => \Elementor\Controls_Manager::SELECT,
                'options' => $custom_menus,
                'default' => 'menu',
            ]
        );
        
        $this->add_control(
            'nav_menu_style',
            [
                'label' => esc_html__( 'Style', 'dzmegamenu' ),
                'type' => \Elementor\Controls_Manager::SELECT,
                'options' => array(
                    '' => esc_html__('Default', 'dzmegamenu'),
                    'st_line' => esc_html__('Line', 'dzmegamenu'),
                ),
                'default' => ''
            ]
        );
        
        $this->add_responsive_control(
            'alignment',
            [
                'label' => esc_html__( 'Alignment', 'dzmegamenu' ),
                'type' => \Elementor\Controls_Manager::CHOOSE,
                'options' => [
                    'left' => [
                        'title' => esc_html__( 'Left', 'dzmegamenu' ),
                        'icon' => 'fa fa-align-left',
                    ],
                    'center' => [
                        'title' => esc_html__( 'Center', 'dzmegamenu' ),
                        'icon' => 'fa fa-align-center',
                    ],
                    'right' => [
                        'title' => esc_html__( 'Right', 'dzmegamenu' ),
                        'icon' => 'fa fa-align-right',
                    ],
                    'justify' => [
                        'title' => esc_html__( 'Justified', 'dzmegamenu' ),
                        'icon' => 'fa fa-align-justify',
                    ],
                ],
                'default' => '',
                'selectors' => [
                    '{{WRAPPER}} .menu' => 'text-align: {{VALUE}};',
                ],
            ]
        );

   		$this->add_control(
            'nav_menu_class',
            [
                'label'         => esc_html__( 'Extra class name', 'dzmegamenu' ),
                'type'          => \Elementor\Controls_Manager::TEXT,
                'placeholder'   => esc_html__( 'If you wish to style particular content element differently, please add a class name to this field and refer to it in your custom CSS file.', 'dzmegamenu' ),
            ]
        );
		
		$this->end_controls_section();	
		  
	}
	
	protected function render() 
	{
		$settings = $this->get_settings();

        extract( $settings );

        $menu_id = 0;
        if (!empty($nav_menu)) {
            $term = get_term_by( 'slug', $nav_menu, 'nav_menu' );
            if ( !empty($term) ) {
                $menu_id = $term->term_id;
            }
        }

		 $nav_menu_args = array(
                            'fallback_cb' => '',
                            'menu'        => $menu_id
                        );
		
?>

		<div class="widget-nav-menu <?php echo esc_attr($nav_menu_class.' '.$nav_menu_style); ?>">
				
			<?php if ( !empty($nav_menu_title) ) { ?>
				<h4 class="widget-title"><?php echo esc_html($nav_menu_title); ?></h4>
			<?php } ?>

			<?php if ( !empty($menu_id) ) { ?>
				<div class="widget-content">
					<?php
						$nav_menu_args = array(
							'fallback_cb' => '',
							'menu'        => $menu_id
						);

						wp_nav_menu( $nav_menu_args, $menu_id );
					?>
				</div>
			<?php } ?>

		</div>
		<?php
	}
	
	
	protected function content_template() 
	{

    }
}
