<?php

if ( !class_exists("Dz_Nav_Menu") ) {
    class Dz_Nav_Menu extends Walker_Nav_Menu {
        
      
        public function __construct() {
            add_filter('nav_menu_css_class' , array($this, 'add_nav_class'), 10 , 2);
        }
       
        public function add_nav_class($classes, $item){
            if(in_array('current-menu-item', $classes)){
                $classes[] = 'active ';
            }
            return $classes;
        } 
		
        public function start_lvl( &$output, $depth=0 ,$args = array() ) {
            $indent = str_repeat( "\t", $depth );
            $output    .= "\n$indent<ul class=\"sub-menu\">\n";

        }

        
        public function end_lvl( &$output, $depth = 0, $args = array() ) {
            $indent = str_repeat("\t", $depth);
            $output .= "$indent</ul>\n";
        }

        public function start_el( &$output, $item, $depth = 0, $args = array(), $id = 0 ) {

            $indent = ( $depth ) ? str_repeat( "\t", $depth ) : '';
			
            $li_attributes = '';
            $class_names = $value = '';

            $classes[] = ($args->has_children) ? 'dropdown' : '';
            $classes[] = ($item->current || $item->current_item_ancestor) ? 'active' : '';
            $classes[] = 'menu-item-' . $item->ID;

            $class_names = join( ' ', apply_filters( 'nav_menu_css_class', array_filter( $classes ), $item, $args ) );
            
            $mega_menu_profile = $this->getSubMegaMenuProfile($item, $depth);
            if ( $mega_menu_profile ) {
                $args->has_children = true;
                $class_names .= ' has-mega-menu';
            }
            if ( $item->alignment ) {
				$class_names .= ' aligned-' . $item->alignment;
            }
			
				
			
            $class_names = ' class="' . esc_attr( $class_names ) . '"';

            $id = apply_filters( 'nav_menu_item_id', 'menu-item-'. $item->ID, $item, $args );
            $id = strlen( $id ) ? ' id="' . esc_attr( $id ) . '"' : '';

            $output .= $indent . '<li' . $id . $value . $class_names . $li_attributes . '>';

            $attributes  = ! empty( $item->attr_title ) ? ' title="'  . esc_attr( $item->attr_title ) .'"' : '';
            $attributes .= ! empty( $item->target ) ? ' target="' . esc_attr( $item->target ) .'"' : '';
            $attributes .= ! empty( $item->xfn ) ? ' rel="'    . esc_attr( $item->xfn ) .'"' : '';
            $attributes .= ! empty( $item->url ) ? ' href="'   . esc_url( $item->url ) .'"' : '';
            //$attributes .= $args->has_children ? ' class="dropdown-toggle" ' : '';
            $attributes .= $args->has_children ? ' class="" ' : '';


            if ( $args->has_children ) {
                $attributes .= ' data-hover="dropdown" data-toggle="dropdown"';
            }
            
            $text_label = '';
            if ( isset($item->text_label) && !empty($item->text_label) ) {
				
                switch ( $item->text_label ) {
                    case 'label_new':
                        $text_label  = esc_html__('New', 'dzmegamenu');
                        break;

                    case 'label_hot':
                        $text_label  = esc_html__('Hot', 'dzmegamenu');
                        break;

                    case 'label_featured':
                        $text_label  = esc_html__('Featured', 'dzmegamenu');
                        break;

                    default:
                        $text_label  = '';
                        break;
                }
                $text_label  = ! empty( $item->text_label ) ? '<span class="text-label ' . str_replace( '_', '-', $item->text_label )  . '">'.$text_label.'</span>' : '';
            }

            $item_output = $args->before;
            $item_output .= '<a'. $attributes .'>';
            $item_output .= $args->link_before . $this->display_icon($item) . apply_filters( 'the_title', $item->title, $item->ID ) . $args->link_after;
            $item_output .= $text_label;
            $item_output .= $args->has_children || $mega_menu_profile ? ' <b class="caret"></b>' : '';
            
            if ( $item->description ) {
                $item_output = '<div class="menu-item-description">' . $item->description . '</div>';
            }
            $item_output .= '</a>';

            $item_output .= $args->after;
            
			$item_output .= $this->generateSubMegaMenu( $item , $mega_menu_profile );
            
            $output .= apply_filters( 'walker_nav_menu_start_el', $item_output, $item, $depth, $args );
			
        }
        public function display_element( $element, &$children_elements, $max_depth, $depth = 0, $args= array(), &$output = "" ) {
            if ( !$element )
                return;

            $id_field = $this->db_fields['id'];


            if( $this->getSubMegaMenuProfile($element, $depth) ) {
                $children_elements[$element->$id_field] = array();
            }

            if ( is_array( $args[0] ) ) 
                $args[0]['has_children'] = ! empty( $children_elements[$element->$id_field] );
            else if ( is_object( $args[0] ) ) 
                $args[0]->has_children = ! empty( $children_elements[$element->$id_field] ); 
            $cb_args = array_merge( array(&$output, $element, $depth), $args);
            call_user_func_array(array(&$this, 'start_el'), $cb_args);

            $id = $element->$id_field;
	
            if ( ($max_depth == 0 || $max_depth > $depth+1 ) && isset( $children_elements[$id]) ) {

                foreach( $children_elements[ $id ] as $child ){

                    if ( !isset($newlevel) ) {
                        $newlevel = true;
                        $cb_args = array_merge( array(&$output, $depth), $args);
                        call_user_func_array(array(&$this, 'start_lvl'), $cb_args);
                    }
                    $this->display_element( $child, $children_elements, $max_depth, $depth + 1, $args, $output );
                }
                unset( $children_elements[ $id ] );
            }

            if ( isset($newlevel) && $newlevel ){
                $cb_args = array_merge( array(&$output, $depth), $args);
                call_user_func_array(array(&$this, 'end_lvl'), $cb_args);
            }

            $cb_args = array_merge( array(&$output, $element, $depth), $args);
            call_user_func_array(array(&$this, 'end_el'), $cb_args);
        }

        /**
         *
         */
        public function getSubMegaMenuProfile($item, $depth ) {
			
            return isset($item->mega_menu_profile) && $item->mega_menu_profile ? $item->mega_menu_profile : false;
        }

        /**
         *
         */
        public function generateSubMegaMenu( $item, $mega_menu_profile ) {
			
            if ( $mega_menu_profile ) {
                $args = array(
                    'name'        => $mega_menu_profile,
                    'post_type'   => DZ_MEGA_MENU_POST_TYPE,
                    'post_status' => 'publish',
                    'numberposts' => 1,
                    'fields' => 'ids'
                );
                $post_ids = get_posts($args);
                if ( $post_ids && isset($post_ids[0]) ) {
                    $post_id = $post_ids[0];
                    $post_id = dz_mega_menu_get_lang_post_id($post_id, DZ_MEGA_MENU_POST_TYPE);
                    $post = get_post($post_id);
                    $content = apply_filters( 'dz_mega_menu_generate_post_builder', do_shortcode( $post->post_content ), $post, $post->ID);
                    $width  = !empty($item->menu_width) ? 'style="width:'.$item->menu_width.'px"':"";
					
                    return '<div class="sub-menu '.esc_attr($post->post_name).'" '.$width.'>'.$content.'<div class="dropdown-menu-inner"></div></div>';
					
                }
            }
            return '';
        }

        public function display_icon($item) {
            if ( $item->menu_icon_image ) {
                return '<img src="'.esc_url($item->menu_icon_image).'" alt="'.esc_attr($item->title).'"/>';
            } elseif ( $item->menu_icon_font ) {
                return '<i class="'.esc_attr($item->menu_icon_font).'"></i>';
            }
        }
    }
}
