<?php

	class Dz_Mega_Menu{
	
	public function __construct(){
		
		add_filter( 'dz_megamenu_item_config_toplevel', array( $this,'dz_megamenu_item' ), 10, 5 );
    	add_action( 'dz_megamenu_item_config' , array( $this, 'add_extra_fields_menu_config' ), 10, 5 );
		add_action( 'wp_update_nav_menu_item', array($this, 'save_dz_megamenu_item'), 10, 2 );
		add_filter( 'wp_edit_nav_menu_walker', array($this, 'nav_edit_walker'), 100);
		add_action( 'admin_enqueue_scripts', array($this, 'script')  );
	}
		
	
	public function script(){
		wp_enqueue_media();
			wp_enqueue_script( 
				'upload-image',
				DZ_MEGA_MENU_URL . '/assets/js/upload.js', 
				array( 'jquery', 'wp-pointer'), 
				'', 
				true 
			);
	}
	public static function nav_edit_walker() {
		$walker = 'Dz_Mega_Menu_Edit';
		if ( ! class_exists( $walker ) ) {
			require_once 'class-megamenu.php';
		}

		return $walker;
    }

	public function dz_megamenu_item($item_id, $item, $depth, $args, $id) {
			
			$posts_array = $this->get_sub_megamenus();
			$icon_font = get_post_meta( $item_id, 'menu_icon_font', true );
			$icon_image = get_post_meta( $item_id, 'menu_icon_image', true );
			$mega_profile = get_post_meta( $item_id, 'mega_menu_profile', true );
			$menu_width = get_post_meta( $item_id, 'menu_width', true );
			$alignment = get_post_meta( $item_id, 'alignment', true );
		?>
			<p class="field-icon-font description description-wide">   
				<label for="edit-menu-icon-font-<?php echo esc_attr($item_id); ?>"><?php echo esc_html__( 'Icon Font (Awesome):', 'dzmegamenu' ); ?> <br>
					<input type="text"  name="menu_icon_font[<?php echo esc_attr($item_id); ?>]" value="<?php echo esc_attr($icon_font); ?>">
				</label>
				<br>
				<span></span>
			</p>
			<p class="field-icon-image description description-wide">   
				<label for="edit-menu-icon-image-<?php echo esc_attr($item_id); ?>"><?php echo  esc_html__( 'Icon Image:', 'dzmegamenu' ); ?></label>
				<div class="screenshot">
					<?php if ( $icon_image ) { ?>
						<img src="<?php echo esc_url($icon_image); ?>" alt="<?php echo esc_attr($item->title); ?>"/>
					<?php } ?>
				</div>
				<input type="hidden" class="upload_image" name="menu_icon_image[<?php echo esc_attr($item_id); ?>]" value="<?php echo esc_attr($icon_image); ?>">
				<div class="upload_image_action">
					<input type="button" class="button add-image" value="Add">
					<input type="button" class="button remove-image" value="Remove">
				</div>
				<span><?php echo esc_html__('You can use Icon Font or Icon Image', 'dzmegamenu');?></span>
			</p>

			<p class="field-addclass description description-wide">
				<label for="edit-mega_menu_profile-<?php echo esc_attr($item_id); ?>"> 
				  <?php echo esc_html__( 'Mega Menus' ); ?> <br>
					<select name="mega_menu_profile[<?php echo esc_attr($item_id); ?>]">
						<option value=""><?php echo esc_html__( 'Disable', 'dzmegamenu' ); ?></option>
						<?php foreach( $posts_array as $_post ){  ?>
						  <option  value="<?php echo esc_attr($_post->post_name);?>" <?php selected( esc_attr($mega_profile), $_post->post_name ); ?> ><?php echo esc_html($_post->post_title); ?></option>
						  <?php } ?>
					</select>
				</label>

				<a href="<?php echo  esc_url( admin_url( 'edit.php?post_type=w3_mega_menu') ); ?>" target="_blank" title="<?php echo esc_html__( 'Sub Megamenu Management', 'dzmegamenu' ); ?>"><?php echo esc_html__( 'Sub Megamenu Management', 'dzmegamenu' ); ?></a>
				<span><?php echo esc_html__( 'If enabled megamenu, its submenu will be disabled', 'apus-framework' ); ?></span>
			</p>

			<p class="field-apus_width description description-wide">   
				<label for="edit-menu-width-<?php echo esc_attr($item_id); ?>"><?php echo esc_html__( 'Width:', 'dzmegamenu' ); ?> <br>
					<input type="text"  name="menu_width[<?php echo esc_attr($item_id); ?>]" value="<?php echo esc_attr($menu_width); ?>">
				</label>
			</p>

			<?php 
				$aligns = array(
					'left' => esc_html__('Left', 'dzmegamenu'),
					'right' => esc_html__('Right', 'dzmegamenu'),
					'fullwidth' => esc_html__('Fullwidth', 'dzmegamenu'),
					'center' => esc_html__('center', 'dzmegamenu')
				); 
			?> 
			<p class="field-apus_alignment description description-wide">   
				<label for="edit-alignment-<?php echo esc_attr($item_id); ?>"><?php echo esc_html__( 'Alignment:', '' ); ?> <br>
					<select name="alignment[<?php echo esc_attr($item_id); ?>]">
						<?php foreach( $aligns as $key => $align ) { ?>
						<option <?php selected( esc_attr($alignment), $key ); ?> value="<?php echo esc_attr($key); ?>"><?php echo esc_html($align); ?></option>
						<?php } ?>
					</select>
				</label>
			</p>
			
		<?php 
		}
		
		public static function add_extra_fields_menu_config($item_id, $item, $depth, $args, $id) {
        $val = get_post_meta( $item_id, 'text_label', true );
		?>
       <p class="field-addclass description description-wide">
			<label for="edit-menu-text-label-<?php echo esc_attr($item_id); ?>">
				<?php  echo esc_html__( 'Label', '' ); ?><br />
				<select name="text_label[<?php echo esc_attr($item_id); ?>]">
				  <option value="" <?php selected( esc_attr($val), '' ); ?>><?php echo esc_html__('None', 'dzmegamenu'); ?></option>
				  <option value="label_new" <?php selected( esc_attr($val), 'label_new' ); ?>><?php echo esc_html__('New', 'dzmegamenu'); ?></option>
				  <option value="label_hot" <?php selected( esc_attr($val), 'label_hot' ); ?>><?php echo esc_html__('Hot', 'dzmegamenu'); ?></option>
				  <option value="label_featured" <?php selected( esc_attr($val), 'label_featured' ); ?>><?php echo esc_html__('Featured', 'dzmegamenu'); ?></option>
				</select>
			</label>
		</p>
    <?php
    }

	public function save_dz_megamenu_item( $menu_id, $menu_item_db_id ) {
			$fields = array( 'mega_menu_profile', 'text_label', 'alignment', 'menu_width', 'menu_icon_font', 'menu_icon_image' );
			foreach ( $fields as $field ) {
				if ( isset( $_POST[$field][$menu_item_db_id] ) ) {
					$custom_value = $_POST[$field][$menu_item_db_id];
					update_post_meta( $menu_item_db_id, $field, $custom_value );
				}
			}
		}

	public function get_sub_megamenus() {
	   $args = array(
	      'posts_per_page'   => -1,
	      'offset'           => 0,
	      'category'         => '',
	      'category_name'    => '',
	      'orderby'          => 'post_date',
	      'order'            => 'DESC',
	      'include'          => '',
	      'exclude'          => '',
	      'meta_key'         => '',
	      'meta_value'       => '',
	      'post_type'        => DZ_MEGA_MENU_POST_TYPE,
	      'post_mime_type'   => '',
	      'post_parent'      => '',
	      'suppress_filters' => true 
	    );
	    return get_posts( $args );  
	}
}

$mega_menu = new Dz_Mega_Menu();