<?php

//return false;
class DZ_MegaMenu_Post_type
{
	
	public $post_type = DZ_MEGA_MENU_POST_TYPE;
	
	function __construct()
	{
		// Hook into the 'init' action
		
		add_action('init', array($this, 'registerPostType'));
		
		//unregister_post_type( 'dz_mega_menu' );
		
		//$this->registerPostType();
		
	}
	
	public function labels()
	{
		$labels =  array(
			'name'                  => esc_html__( 'Mega Menu ', 'dzmegamenu' ),
			'singular_name'         => esc_html__( 'Mega Menu', 'dzmegamenu' ),
			'add_new'               => esc_html__( 'Add Mega Menu', 'dzmegamenu' ),
			'add_new_item'          => esc_html__( 'Add Mega Menu', 'dzmegamenu' ),
			'edit_item'             => esc_html__( 'Edit Mega Menu', 'dzmegamenu' ),
			'new_item'              => esc_html__( 'New Mega Menu', 'dzmegamenu' ),
			'update_item'         	=> esc_html__( 'Update Mega Menu', 'dzmegamenu' ),
			'all_items'             => esc_html__( 'All Mega Menu', 'dzmegamenu' ),
			'view_item'             => esc_html__( 'View Mega Menu', 'dzmegamenu' ),
			'search_items'          => esc_html__( 'Search Mega Menuu', 'dzmegamenu' ),
			'not_found'             => esc_html__( 'No Mega Menu found', 'dzmegamenu' ),
			'not_found_in_trash'    => esc_html__( 'No Mega Menu found in Trash', 'dzmegamenu' ),
			'parent_item_colon'     => esc_html__( 'Parent Mega Menu', 'dzmegamenu' ),
			'menu_name'             => esc_html__( 'Mega Menu', 'dzmegamenu' ),
			
		);
		
		return $labels;
	}
	
	
	public function rewrite()
	{
		$rewrite = array(
						'slug'                => $this->post_type,
						'with_front'          => true,
						'pages'               => true,
						'feeds'               => false,
					);
		
		return 	$rewrite;	
	}
	
	public function args()
	{
		$args = array(
			'label'               => esc_html__( 'Mega Menu', 'dzmegamenu' ),
			'labels'              =>  $this->labels() ,
			'supports'          => array( 'title', 'editor' ),
			'hierarchical'        => false,
			'public'              => true,
			'show_ui'             => true,
			'show_in_menu'        => true,
			'show_in_nav_menus'   => true,
			'show_in_admin_bar'   => true,
			'menu_position'       => 5,
			'menu_icon'           => 'dashicons-align-left',
			'can_export'          => true,
			'has_archive'         => false,
			'exclude_from_search' => false,
			'publicly_queryable'  => true,
			'rewrite'             => array(),
			'capability_type'     => 'post',
			
			'rewrite'			=> $this->rewrite()
		);
		
		return $args;
	}
	
	
	// Register Custom Post Type
	function registerPostType() {
		
		register_post_type( $this->post_type, $this->args() );
	}
}


new DZ_MegaMenu_Post_type();