<?php
	
	
	function dz_mega_menu_wp_enqueue_styles(){
		wp_enqueue_style( 'dz-custom',  DZ_MEGA_MENU_URL . '/assets/css/custom.css', array(), '' );
	}
	add_action( 'wp_enqueue_scripts', 'dz_mega_menu_wp_enqueue_styles', 100 );
	
	if(function_exists('register_nav_menu')) {
		register_nav_menus(
			array(
				/** Register Main Menu location header */
				'mobile_menu' => esc_html__(' Mobile Menu', 'dzmegamenu'),
			)
		);
	}
	
	function dz_mega_menu_templates( $template ) {
		$post_type = get_post_type();
		if ( $post_type ) {
			$custom_post_types = array( DZ_MEGA_MENU_POST_TYPE, 'elementor_library' );
			if ( in_array( $post_type, $custom_post_types ) ) {
				if ( is_single() ) {
					$post_type = str_replace('_', '-', $post_type);
					return DZ_MEGA_MENU_DIR . 'templates/single-elementor.php';
				}
			}
		}

		return $template;
	}
 
 
	function dz_mega_menu_get_lang_post_id($post_id, $post_type = 'page') {
		return apply_filters( 'dz-mega-menu-post-id', $post_id, $post_type);
	}
	
	if(!function_exists('dzmm_is_plugin_active'))
	{
		function dzmm_is_plugin_active($plugin_file_path){
			if ( 
			  in_array( 
				$plugin_file_path, 
				apply_filters( 'active_plugins', get_option( 'active_plugins' ) ) 
			  ) 
			) {
				return true;
			}else{
				return false;
			}
		}
	} 
