jQuery(document).ready(function($){

	var dz_upload;
	var dz_selector;

	function dz_add_file(event, selector) {

		var upload = $(".uploaded-file"), frame;
		var $el = $(this);
		dz_selector = selector;

		event.preventDefault();

		// If the media frame already exists, reopen it.
		if ( dz_upload ) {
			dz_upload.open();
		} else {
			// Create the media frame.
			dz_upload = wp.media.frames.dz_upload =  wp.media({
				// Set the title of the modal.
				title: "Select Image",

				// Customize the submit button.
				button: {
					// Set the text of the button.
					text: "Selected",
					// Tell the button not to close the modal, since we're
					// going to refresh the page when the image is selected.
					close: false
				}
			});

			// When an image is selected, run a callback.
			dz_upload.on( 'select', function() {
				// Grab the selected attachment.
				var attachment = dz_upload.state().get('selection').first();
				dz_upload.close();
				dz_selector.find('#agent-avatar').val(attachment.attributes.id).change();
				if ( attachment.attributes.type == 'image' ) {
					dz_selector.find('.screenshot').empty().hide().prepend('<img style="width:100px;height: 100px;" src="' + attachment.attributes.url + '">').slideDown('fast');
				}
			});

		}
		// Finally, open the modal.
		dz_upload.open();
	}

	function dz_remove_file(selector) {
		selector.find('.screenshot').slideUp('fast').next().val('').trigger('change');
	}
	
	$('body').delegate('#removeimage', 'click', function(event) {
		dz_remove_file( $(this).parent().parent() );
	});

	$('body').delegate('#uploadimage', 'click', function(event) {
		dz_add_file(event, $(this).parent().parent());
	});
	$('.wpjm-updater-dismiss').parent().css("display","none");
}); 