<?php
/**
 * Helper functions for the theme
 *
 * @package Jobzilla
 */
/**
 * Get theme option based on its id.
 *
 * @param  string $opt_id Required. the option id.
 * @param  mixed $default Optional. Default if the option is not found or not yet saved.
 *                         If not set, false will be used
 *
 * @return mixed
 *
 * It have some redux options function who we cannot write in theme because of themeforest rules
 *
 */


/**
 * Body classes to body_class filter.
 */
function dz_custom_body_class($classes) {
	//get the custom classes from theme options
	$custom_classes = dexignzone_get_opt('body_class');

	if(!empty($custom_classes)) {
		// add 'custom classes' to the $classes array
		$classes[] = $custom_classes;
	}

	// return the $classes array
	return $classes;
}

add_filter('body_class', 'dz_custom_body_class');


/**
 * Header Tracking Code to wp_head hook.
 */
function dz_header_code() {
	$site_header_code = dexignzone_get_opt( 'site_header_code' );
	if ( $site_header_code != '' ) {
		echo '<script>'.
				wp_kses( $site_header_code, wp_kses_allowed_html() ).
			'</script>';
	} 
}

add_action( 'wp_head', 'dz_header_code' );

/**
 * Footer Tracking Code to wp_footer hook.
 */
function dz_footer_code() {
	$site_footer_code = dexignzone_get_opt( 'site_footer_code' );
	if ( $site_footer_code != '' ) {
		echo '<script>'.
				wp_kses( $site_footer_code, wp_kses_allowed_html() ).
			'</script>';
	}
}

add_action( 'wp_footer', 'dz_footer_code' );

/**
 * Footer JS Code to wp_footer hook.
 */
function dz_css_code() {
	$custom_css = dexignzone_get_opt( 'css_editor' );
	if ( trim($custom_css) != '' ) {
		echo '<style>'
			. $custom_css .
		'</style>';
	}
}

add_action( 'wp_footer', 'dz_css_code' );

/**
 * Footer JS Code to wp_footer hook.
 */
function dz_js_code() {
	$custom_javascript = dexignzone_get_opt( 'js_editor' );

	if ( trim($custom_javascript) != '' ) {
		echo '<script type="text/javascript">'
			. $custom_javascript .
		'</script>';
	}
}

add_action( 'wp_footer', 'dz_js_code' );

/**
 * Footer JS Code to wp_footer hook.
 */
function dz_html_code() {
	$custom_html = dexignzone_get_opt( 'html_editor' );
	if ( trim($custom_html) != '' ) {
		echo '<div class="min-container">' . $custom_html . '</div>';
	}
}

add_action( 'wp_footer', 'dz_html_code' );




