<?php
class Dexignzone_DZ_Ajax
{
	
	function __construct()
	{
		add_action( 'wp_ajax__dz_ajax_callback', array( $this, 'ajax_handler' ) );
		add_action( 'wp_ajax_nopriv__dz_ajax_callback', array( $this, 'ajax_handler' ) );
	}
	
	function ajax_handler()
	{
		$method = dz_set( $_REQUEST, 'subaction' );
		if( method_exists( $this, $method ) ) $this->$method();
		
		exit;
	}
	
	function tweets()
	{
		if( !class_exists( 'Codebird' ) ) include_once( 'codebird.php' );
		$cb = new Codebird;
		$method = dz_set( $_POST, 'method' );
		
		$theme_options = dexignzone_dzbase()->option();		
		$api = dz_set($theme_options, 'twitter_api');
		$api_secret = dz_set($theme_options, 'twitter_api_secret');
		$token = dz_set($theme_options, 'twitter_token');
		$token_secret = dz_set($theme_options, 'twitter_token_Secret');
		if( !$api && $api_secret ) 
		{ 
			_e('Please provide tiwtter api information to fetch feed', DZ_TH_DOMAIN);exit;
		}
		$cb->setConsumerKey($api, $api_secret);
		$cb->setToken($token, $token_secret);
		
		$reply = (array) $cb->statuses_userTimeline(array('count'=>dz_set( $_POST, 'number' ), 'screen_name'=>dz_set($_POST, 'screen_name')));
		if( isset( $reply['httpstatus'] ) ) unset( $reply['httpstatus'] );
		foreach( $reply as $k => $v ){			
			$time = human_time_diff( strtotime( dz_set( $v, 'created_at') ), current_time('timestamp') ) . __(' ago', DZ_TH_DOMAIN);
			$text = preg_replace('@(https?://([-\w\.]+[-\w])+(:\d+)?(/([\w/_\.#-]*(\?\S+)?[^\.\s])?)?)@', '<a href="$1" target="_blank">$1</a>', dz_set( $v, 'text'));
			if($_POST['template'] === 'lead' )
			{
				echo '<i class="fa fa-twitter"></i>'.$text.' <a href="#"> '.$time.'</a>' ;
			}
			else {
				echo 
				'<li><span></span><p>'.$text.' <a href="#">'.__(' about ', DZ_TH_DOMAIN).$time.'</a></p></li>';
			}
		}
	}
	
	function contact_form_submit()
	{
		if( !count( $_POST ) ) return;
	
		_load_plugins_class( 'validation', 'helpers', true );
		$t = $GLOBALS['_dz_base'];
		$settings = $t->option();
	
		/** set validation rules for contact form */
		$t->validation->set_rules('contact_subject','<strong>'.__('Subject', DZ_TH_DOMAIN).'</strong>', 'min_length[5]');
		
		$t->validation->set_rules('contact_name','<strong>'.__('Name', DZ_TH_DOMAIN).'</strong>', 'required|min_length[4]|max_lenth[30]');
		
		$t->validation->set_rules('contact_email','<strong>'.__('Email', DZ_TH_DOMAIN).'</strong>', 'required|valid_email');
		
		$t->validation->set_rules('contact_message','<strong>'.__('Message', DZ_TH_DOMAIN).'</strong>', 'required|min_length[5]');
		if( dz_set($settings, 'contact_captcha_status'))
		{
			include_once( get_template_directory().'/includes/thirdparty/recaptchalib.php');
			$privatekey = dz_set($settings, 'recaptcha_private');
			
			$resp = recaptcha_check_answer ($privatekey,
                                 $_SERVER["REMOTE_ADDR"],
                                 $_POST["recaptcha_challenge_field"],
                                 $_POST["recaptcha_response_field"]);
			
			if( !$resp->is_valid )
			{
					$t->validation->_error_array['captcha'] = __('Invalid captcha entered, please try again.', DZ_TH_DOMAIN);
			}
	
		}
		$messages = '';
		if($t->validation->run() !== FALSE && empty($t->validation->_error_array))
		{
			$subject = $t->validation->post('contact_subject');
			$name = $t->validation->post('contact_name');
			$email = $t->validation->post('contact_email');
			
			$message = __("Subject:\t", DZ_TH_DOMAIN).$subject."\r\n";
			$message .= __("Contact Name:\t", DZ_TH_DOMAIN).$name."\r\n";
			
			$message .= "\r\n".$t->validation->post('contact_message'); 	
			$contact_to =  get_option('admin_email');	
			$headers = 'From: '.$name.' <'.$email.'>' . "\r\n";
			wp_mail($contact_to, sprintf(__('Contact Us Message from %s', DZ_TH_DOMAIN), get_bloginfo('name') ), $message, $headers);
	
			echo "<fieldset>";
			echo "<div id='success_page' class='alert alert-success'>";
			echo "<h1>".__('Email Sent Successfully.', DZ_TH_DOMAIN)."</h1>";
			echo "<p>".sprintf(__("Thank you <strong>%s</strong>, your message has been submitted to us.", DZ_TH_DOMAIN), $name)."</p>";
			echo "</div>";
			echo "</fieldset>";
			exit;
		
		}else
		{
	
			 if( is_array( $t->validation->_error_array ) )
			 {
				 foreach( $t->validation->_error_array as $msg )
				 {
					 $messages .= '<div class="alert alert-danger">'.__('Error! ', DZ_TH_DOMAIN).$msg.'</div>';
				 }
			}
	
		}
	
		echo $messages;exit;
	}		
	
	function footer_contact_form_submit()
	{
		if( !count( $_POST ) ) return;
	
		_load_plugins_class( 'validation', 'helpers', true );
		$t = $GLOBALS['_dz_base'];
		$settings = $t->option();
	
		/** set validation rules for contact form */		
		$t->validation->set_rules('footer_contact_name','<strong>'.__('Name', DZ_TH_DOMAIN).'</strong>', 'required|min_length[4]|max_lenth[30]');
		
		$t->validation->set_rules('footer_contact_email','<strong>'.__('Email', DZ_TH_DOMAIN).'</strong>', 'required|valid_email');
		
		$t->validation->set_rules('footer_contact_message','<strong>'.__('Message', DZ_TH_DOMAIN).'</strong>', 'required|min_length[5]');
		if( dz_set($settings, 'contact_captcha_status'))
		{
			include_once( get_template_directory().'/includes/thirdparty/recaptchalib.php');
			$privatekey = dz_set($settings, 'recaptcha_private');
			
			$resp = recaptcha_check_answer ($privatekey,
                                 $_SERVER["REMOTE_ADDR"],
                                 $_POST["recaptcha_challenge_field"],
                                 $_POST["recaptcha_response_field"]);
			
			if( !$resp->is_valid )
			{
					$t->validation->_error_array['captcha'] = __('Invalid captcha entered, please try again.', DZ_TH_DOMAIN);
			}
	
		}
		$messages = '';
		if($t->validation->run() !== FALSE && empty($t->validation->_error_array))
		{			
			$name = $t->validation->post('footer_contact_name');
			$email = $t->validation->post('footer_contact_email');					
			$message .= __("Contact Name:\t", DZ_TH_DOMAIN).$name."\r\n";			
			$message .= "\r\n".$t->validation->post('contact_message'); 	
			$contact_to =  get_option('admin_email');	
			$headers = 'From: '.$name.' <'.$email.'>' . "\r\n";
			wp_mail($contact_to, sprintf(__('Contact Us Message from %s', DZ_TH_DOMAIN), get_bloginfo('name') ), $message, $headers);
	
			echo "<fieldset>";
			echo "<div id='success_page' class='alert alert-success'>";
			echo "<h1>".__('Email Sent Successfully.', DZ_TH_DOMAIN)."</h1>";
			echo "<p>".sprintf(__("Thank you <strong>%s</strong>, your message has been submitted to us.", DZ_TH_DOMAIN), $name)."</p>";
			echo "</div>";
			echo "</fieldset>";
			exit;
		
		}else
		{
	
			 if( is_array( $t->validation->_error_array ) )
			 {
				 foreach( $t->validation->_error_array as $msg )
				 {
					 $messages .= '<div class="alert alert-danger">'.__('Error! ', DZ_TH_DOMAIN).$msg.'</div>';
				 }
			}
	
		}
	
		echo $messages;exit;
	}
	
		
	function wishlist()
	{
		global $current_user;
      	get_currentuserinfo();
			
		if( is_user_logged_in() ){
			
			$meta = (array)get_user_meta( $current_user->ID, '_ja_product_wishlist', true );
			$data_id = dz_set( $_POST, 'data_id' );
			if( $meta && is_array( $meta ) ){
				if( in_array( $data_id, $meta ) ){
					exit(json_encode(array('code'=>'exists', 'msg'=>__('You have already added this product to wish list', DZ_TH_DOMAIN ) ) ) );
				}
				$newmeta = array_merge( array( dz_set( $_POST, 'data_id' ) ), $meta );
				update_user_meta( $current_user->ID, '_ja_product_wishlist', array_unique($newmeta) );
				exit(json_encode(array('code'=>'success', 'msg'=>__('Product successfully added to wishlist', DZ_TH_DOMAIN ) ) ) );
			}else{
				exit(json_encode(array('code'=>'fail', 'msg'=>__('There is an error edding wishlist', DZ_TH_DOMAIN ) ) ) );
			}
		}
		else exit(json_encode(array('code'=>'fail', 'msg'=>__('Please login first to add the product to your wishlist', DZ_TH_DOMAIN ) ) ) );
	}
	
	function wishlist_del()
	{
		global $current_user;
      	get_currentuserinfo();
			
		if( is_user_logged_in() ){
			
			$meta = get_user_meta( $current_user->ID, '_ja_product_wishlist', true );
			$data_id = dz_set( $_POST, 'data_id' );
			if( $meta && is_array( $meta ) ){
				$searched = array_search( $data_id, $meta );
				if( isset($meta[$searched]) ){
					unset( $meta[$searched] );
					update_user_meta( $current_user->ID, '_ja_product_wishlist', array_unique($meta) );
					exit(json_encode(array('code'=>'del', 'msg'=>__('Product is successfully deleted from wishlist', DZ_TH_DOMAIN ) ) ) );
				}else exit(json_encode(array('code'=>'fail', 'msg'=>__('Unable to find this product into wishlist', DZ_TH_DOMAIN ) ) ) );
			}else{
				update_user_meta( $current_user->ID, '_ja_product_wishlist', array( dz_set( $_POST, 'data_id' ) ) );
				exit(json_encode(array('code'=>'fail', 'msg'=>__('Unable to retrieve your wishlist', DZ_TH_DOMAIN ) ) ) );
			}
		}
		else exit(json_encode(array('code'=>'fail', 'msg'=>__('Please login first to add/delete product in your wishlist', DZ_TH_DOMAIN ) ) ) );
	}
	
	function download_rating()
	{
		$ip = $_SERVER['REMOTE ADDR'];
		extract( $_POST );
		
		$meta = get_post_meta( $post_id, '_download_rating', true );
		
		if( !dz_set( $meta, $ip ) )
		{
			$meta[$ip] = $value;
			
			update_post_meta( $post_id, '_download_rating', $meta );
			
			echo 'success';exit;
		}
		
		exit( 'failed' );
	}
	
	
	
}