<?php

if ( ! class_exists( 'Dexignzone_DZ_Job_Category_image' ) ) {

class Dexignzone_DZ_Job_Category_image {

  public function __construct() {
    //
  }
 
	 /*
	  * Initialize the class and start calling our hooks and filters
	  * @since 1.0.0
	 */
	 public function init() {
		add_action( 'job_listing_category_add_form_fields', array ( $this, 'dz_add_job_category_icon' ), 10, 2 );
		add_action( 'created_job_listing_category', array ( $this, 'dz_save_job_category_icon' ), 10, 2 );
		add_action( 'job_listing_category_edit_form_fields', array ( $this, 'dz_update_job_category_icon' ), 10, 2 );
		add_action( 'edited_job_listing_category', array ( $this, 'dz_updated_job_category_icon' ), 10, 2 );
		add_action( 'admin_enqueue_scripts', array( $this, 'dz_load_media' ) );
	 }

	public function dz_load_media() {
		if( ! isset( $_GET['taxonomy'] ) || $_GET['taxonomy'] != 'job_listing_category' ) {
		   return;
		}
		//wp_enqueue_media();
	}
	 
	 /*
	  * Add a form field in the new category page
	  * @since 1.0.0
	 */
	 
	 public function dz_add_job_category_icon($taxonomy){ 
	 ?>
		<div class="form-field term-group">
			<label for="job-category-icon"><?php _e('Icon', DZ_TH_DOMAIN); ?></label>
			<input type="text" id="job-category-icon" name="job-category-icon" class="custom_media_url" value="">
		</div>
	<?php	 
	 }
	 /*
	  * Save the form field
	  * @since 1.0.0
	 */
	 public function dz_save_job_category_icon( $term_id, $tt_id ) {
	   if( isset( $_POST['job-category-icon'] ) && '' !== $_POST['job-category-icon'] ){
		 $icon = $_POST['job-category-icon'];
		 add_term_meta( $term_id, 'job-category-icon', $icon, true );
	   }
	 }
	 
	 /*
	  * Edit the form field
	  * @since 1.0.0
	 */
	 public function dz_update_job_category_icon( $term, $taxonomy ) { ?>
	   <tr class="form-field term-group-wrap">
		 <th scope="row">
		   <label for="job-category-icon"><?php _e( 'Icon', DZ_TH_DOMAIN ); ?></label>
		 </th>
		 <td>
		   <?php $icon = get_term_meta ( $term->term_id, 'job-category-icon', true );  ?>
		   <input type="text" id="job-category-icon" name="job-category-icon" value="<?php echo esc_attr($icon); ?>">
		 </td>
	   </tr>
	 <?php
	 }

	/*
	 * Update the form field value
	 * @since 1.0.0
	 */
	 public function dz_updated_job_category_icon($term_id, $tt_id ) {
	   if( isset( $_POST['job-category-icon'] ) && '' !== $_POST['job-category-icon'] ){
		 $icon = $_POST['job-category-icon'];
		 
		 update_term_meta ( $term_id, 'job-category-icon', $icon );
	   } else {
		 update_term_meta ( $term_id, 'job-category-icon', '' );
	   }
	 }
	
	}
	 
	$Dexignzone_DZ_Job_Category_image = new Dexignzone_DZ_Job_Category_image();
	$Dexignzone_DZ_Job_Category_image -> init(); 
}