<?php 
class Dexignzone_DZ_Meta_boxes
{
	
	var $_fields = '';
	
	
	function __construct()
	{
		include(get_template_directory().'/includes/resource/awesom_icons.php');
		$GLOBALS['_font_awesome'] = $awesome_icons;
		
		add_action( 'admin_init', array( $this, 'add_metabox' ) );
		
		add_action( 'save_post', array( $this, 'publish_post' ) );
		
		
	}
	
	
	function add_metabox()
	{
		
		include(get_template_directory().'/includes/resource/settings.php');
		$this->_fields = $settings;
		$keys = array_keys( $this->_fields );
		
		foreach( $keys as $k ){
			add_meta_box($k.'_settings', sprintf(__( '%s Settings', DZ_TH_DOMAIN ), ucwords(str_replace( 'bistro_', '', $k ))), array( $this, 'inner_custom_box'), $k );			
		}
	}
	
	function inner_custom_box($post)
	{
		wp_enqueue_style(array('jquery-ui-datepicker-custom', 'admin-custom-styles'));
		wp_enqueue_script(array('jquery-ui-datepicker', 'jquery-select2'));
		$t = &$GLOBALS['_dz_base'];
		$post_type = dz_set( $post, 'post_type');
		$settings = get_post_meta( dz_set($post, 'ID' ), '_bistro_'.$post_type.'_settings', true);
		
		
		
		$fields = dz_set( $this->_fields, $post_type );
		//printr($fields);
		$nph = new NHP_Options;
		$nph->args['opt_name'] = $post_type;
		
		if( $fields && is_array( $fields ) ): ?>
        	<script type="text/javascript">
			jQuery(document).ready(function($) {
				$('.fields_set select').select2();
				if( $('#start_date') ){
					$('#start_date, #end_date').datepicker();
				}
			});
			</script>
			<?php foreach( $fields as $f):
				?>
				
                <div class="fields_set" >
                	<label><strong><?php echo dz_set( $f, 'title'); ?></strong></label>
                    <div class="field">
                    	<?php echo $nph->_field_input($f, dz_set($settings, dz_set( $f, 'id' )) ); 	?>
                    </div>
                </div>
            <?php endforeach;
		endif;
	}
	
	
	function _html()
	{
	}
	
	function publish_post($post_id)
	{
		global $post;
		$post_type = dz_set( $_POST, 'post_type' );
		$setting = dz_set($this->_fields, $post_type);
		
		$types = array_merge(array('post', 'page'), array_keys( $this->_fields )); 
		if( !in_array($post_type , $types) ) return;
		
		$data = dz_set( $_POST, $post_type);//array_intersect_key( $_POST, $setting);
		if( !$data ) return;
		
		if( $post_type == 'bistro_deal') update_post_meta( $post_id, '_bistro_bistro_deal_date', strtotime(dz_set( $data, 'end_date')));
		update_post_meta( $post_id, '_bistro_'.$post_type.'_settings', $data );
	}
}