<?php

if ( ! class_exists( 'Dexignzone_DZ_Region_Category_image' ) ) {

class Dexignzone_DZ_Region_Category_image {

  public function __construct() {
    //
  }
 
	 /*
	  * Initialize the class and start calling our hooks and filters
	  * @since 1.0.0
	 */
	 public function init() {
		add_action( 'job_listing_region_add_form_fields', array ( $this, 'dz_add_job_category_image' ), 10, 2 );
		add_action( 'created_job_listing_region', array ( $this, 'dz_save_job_category_image' ), 10, 2 );
		add_action( 'job_listing_region_edit_form_fields', array ( $this, 'dz_update_job_category_image' ), 10, 2 );
		add_action( 'edited_job_listing_region', array ( $this, 'dz_updated_job_category_image' ), 10, 2 );
		add_action( 'admin_enqueue_scripts', array( $this, 'dz_load_media' ) );
		add_filter('manage_edit-job_listing_region_columns', [$this, 'dz_job_listing_columns']);
    add_filter('manage_job_listing_region_custom_column', [$this, 'dz_job_listing_column'], 10, 3 );
		
		
		// save our taxonomy image while edit or create term
		add_action( 'admin_footer', array ( $this, 'dz_add_script' ) );
	 }

	public function dz_load_media() {
		if( ! isset( $_GET['taxonomy'] ) || $_GET['taxonomy'] != 'job_listing_region' ) {
		   return;
		}
		wp_enqueue_media();
	}
	 
	 /*
	  * Add a form field in the new category page
	  * @since 1.0.0
	 */
	 public function dz_add_job_category_image ( $taxonomy ) { ?>
	   <div class="form-field term-group">
		 <label for="job-category-image-id"><?php _e('Image', DZ_TH_DOMAIN); ?></label>
		 <input type="hidden" id="job-category-image-id" name="job-category-image-id" class="custom_media_url" value="">
		 <div id="category-image-wrapper"></div>
		 <p>
		   <input type="button" class="button button-secondary dz_tax_media_button" id="dz_tax_media_button" name="dz_tax_media_button" value="<?php _e( 'Add Image', DZ_TH_DOMAIN ); ?>" />
		   <input type="button" class="button button-secondary dz_tax_media_remove" id="dz_tax_media_remove" name="dz_tax_media_remove" value="<?php _e( 'Remove Image', DZ_TH_DOMAIN ); ?>" />
		</p>
	   </div>
	 <?php
	 }
	 
	 /*
	  * Save the form field
	  * @since 1.0.0
	 */
	 public function dz_save_job_category_image ( $term_id, $tt_id ) {
	   if( isset( $_POST['job-category-image-id'] ) && '' !== $_POST['job-category-image-id'] ){
		 $image = $_POST['job-category-image-id'];
		 add_term_meta( $term_id, 'job-category-image-id', $image, true );
	   }
	 }
	 
	 /*
	  * Edit the form field
	  * @since 1.0.0
	 */
	 public function dz_update_job_category_image ( $term, $taxonomy ) { ?>
	   <tr class="form-field term-group-wrap">
		 <th scope="row">
		   <label for="job-category-image-id"><?php _e( 'Image', DZ_TH_DOMAIN ); ?></label>
		 </th>
		 <td>
		   <?php $image_id = get_term_meta ( $term -> term_id, 'job-category-image-id', true ); ?>
		   <input type="hidden" id="job-category-image-id" name="job-category-image-id" value="<?php echo $image_id; ?>">
		   <div id="category-image-wrapper">
			 <?php if ( $image_id ) { ?>
			   <?php echo wp_get_attachment_image ( $image_id, 'thumbnail' ); ?>
			 <?php } ?>
		   </div>
		   <p>
			 <input type="button" class="button button-secondary dz_tax_media_button" id="dz_tax_media_button" name="dz_tax_media_button" value="<?php _e( 'Add Image', DZ_TH_DOMAIN ); ?>" />
			 <input type="button" class="button button-secondary dz_tax_media_remove" id="dz_tax_media_remove" name="dz_tax_media_remove" value="<?php _e( 'Remove Image', DZ_TH_DOMAIN ); ?>" />
		   </p>
		 </td>
	   </tr>
	 <?php
	 }

	/*
	 * Update the form field value
	 * @since 1.0.0
	 */
	 public function dz_updated_job_category_image ( $term_id, $tt_id ) {
	   if( isset( $_POST['job-category-image-id'] ) && '' !== $_POST['job-category-image-id'] ){
		 $image = $_POST['job-category-image-id'];
		 
		 update_term_meta ( $term_id, 'job-category-image-id', $image );
	   } else {
		 update_term_meta ( $term_id, 'job-category-image-id', '' );
	   }
	 }
	
	 
	 
		// get attachment ID by image url
		function dz_category_attachment_id_by_url($image_src) {
			global $wpdb;
			$query = $wpdb->prepare("SELECT ID FROM $wpdb->posts WHERE guid = %s", $image_src);
			$id = $wpdb->get_var($query);
			return (!empty($id)) ? $id : NULL;
		}
		 
		// get taxonomy image url for the given term_id (Place holder image by default)
		function dz_job_category_image_url($term_id = NULL, $size = 'full', $return_placeholder = FALSE) {
			if (!$term_id) {
				if (is_category())
					$term_id = get_query_var('cat');
				elseif (is_tag())
					$term_id = get_query_var('tag_id');
				elseif (is_tax()) {
					$current_term = get_term_by('slug', get_query_var('term'), get_query_var('taxonomy'));
					$term_id = $current_term->term_id;
				}
			}
			
			$image_url = '';
			if(!empty($term_id)){
			
				$meta_arr = get_term_meta($term_id);
				$cat_attachment_id = !empty($meta_arr['job-category-image-id'][0])?$meta_arr['job-category-image-id'][0]:0;	
			
				$image_data = wp_get_attachment_image_src($cat_attachment_id, $size);
				$image_url = !empty($image_data[0])?$image_data[0]:'';
			}
			
			
			if(empty($image_url)){
				$image_url = plugin_dir_url(__FILE__).'placeholder.png';
			}
			return $image_url;
		}
	 
		/**
		 * Thumbnail column added to category admin.
		 *
		 * @access public
		 * @param mixed $columns
		 * @return void
		 */
		function dz_job_listing_columns( $columns ) {
			$new_columns = array();
			$new_columns['cb'] = $columns['cb'];
			$new_columns['thumb'] = __('Image', DZ_TH_DOMAIN);
			print_r($columns);
			//die;
			unset( $columns['cb'] );

			return array_merge( $new_columns, $columns );
		}
	 
	 
		/**
		 * Thumbnail column value added to category admin.
		 *
		 * @access public
		 * @param mixed $columns
		 * @param mixed $column
		 * @param mixed $id
		 * @return void
		 */
		function dz_job_listing_column( $columns, $column, $id ) {		
			
			if ( $column == 'thumb' )
				
				$columns = '<span><img src="' . $this->dz_job_category_image_url($id, 'thumbnail', TRUE) . '" alt="' . __('Thumbnail', DZ_TH_DOMAIN) . '" class="wp-post-image" width="80px" height="80px" /></span>';
			
			return $columns;
		}

		/*
		 * Add script
		 * @since 1.0.0
		 */
		public function dz_add_script() { ?>
		   <script>
				jQuery(document).ready( function($) {
					function dz_media_upload(button_class) {
						var _custom_media = true,
						_orig_send_attachment = wp.media.editor.send.attachment;
						$('body').on('click', button_class, function(e) {
							var button_id = '#'+$(this).attr('id');
							var send_attachment_bkp = wp.media.editor.send.attachment;
							var button = $(button_id);
							_custom_media = true;
							wp.media.editor.send.attachment = function(props, attachment){
								if ( _custom_media ) {
								   $('#job-category-image-id').val(attachment.id);
								   $('#category-image-wrapper').html('<img class="custom_media_image" src="" style="margin:0;padding:0;max-height:100px;float:none;" />');
								   $('#category-image-wrapper .custom_media_image').attr('src',attachment.url).css('display','block');
								} else {
								   return _orig_send_attachment.apply( button_id, [props, attachment] );
								}
							}
							wp.media.editor.open(button);
							return false;
						});
					}
					dz_media_upload('.dz_tax_media_button.button'); 
					$('body').on('click','.dz_tax_media_remove',function(){
					   $('#job-category-image-id').val('');
					   $('#category-image-wrapper').html('<img class="custom_media_image" src="" style="margin:0;padding:0;max-height:100px;float:none;" />');
					});
			 
					$(document).ajaxComplete(function(event, xhr, settings) {
						var queryStringArr = settings.data.split('&');
						if( $.inArray('action=add-tag', queryStringArr) !== -1 ){
							var xml = xhr.responseXML;
							$response = $(xml).find('term_id').text();
							if($response!=""){
								// Clear the thumb image
								$('#category-image-wrapper').html('');
							}
						}
					});
				});
		 </script>
		 <?php 
		}
	}
	 
	$Dexignzone_DZ_Region_Category_image = new Dexignzone_DZ_Region_Category_image();
	$Dexignzone_DZ_Region_Category_image -> init(); 
}