<?php 
function upload_file( $field_key ) {
			
			if ( isset( $_FILES) && ! empty( $_FILES)  ) {
				
				$allowed_mime_types = job_manager_get_allowed_mime_types();
			

				$file_urls       = [];
				$files_to_upload = job_manager_prepare_uploaded_files( $field_key ); 
				
				foreach ( $files_to_upload as $file_to_upload ) {
					$uploaded_file = jobzilla_upload_file(
						$file_to_upload,
						[
							'file_key'           => $field_key['name'],
							'allowed_mime_types' => $allowed_mime_types,
						]
					);	
					
					

					if ( is_wp_error( $uploaded_file ) ) {
						throw new Exception( $uploaded_file->get_error_message() );
					} else {
						$file_urls[] = $uploaded_file->url;
						
					}
				}

				return current( $file_urls );
				
			}
		}
function jobzilla_upload_file( $file, $args = array() ) {
    global $jobzilla_upload, $jobzilla_uploading_file;

    include_once( ABSPATH . 'wp-admin/includes/file.php' );
    include_once( ABSPATH . 'wp-admin/includes/media.php' );

    $args = wp_parse_args( $args, array(
        'file_key'           => '',
        'file_label'         => '',
        'allowed_mime_types' => '',
    ) );

    $jobzilla_upload         = true;
    $jobzilla_uploading_file = $args['file_key'];
    $uploaded_file              = new stdClass();
    
    $allowed_mime_types = $args['allowed_mime_types'];
    

    $file = apply_filters( 'jobzilla_upload_file_pre_upload', $file, $args, $allowed_mime_types );

    if ( is_wp_error( $file ) ) {
        return $file;
    }

    if ( ! in_array( $file['type'], $allowed_mime_types ) ) {
        if ( $args['file_label'] ) {
            return new WP_Error( 'upload', sprintf( __( '"%s" (filetype %s) needs to be one of the following file types: %s', 'jobzilla' ), $args['file_label'], $file['type'], implode( ', ', array_keys( $allowed_mime_types ) ) ) );
        } else {
            return new WP_Error( 'upload', sprintf( __( 'Uploaded files need to be one of the following file types: %s', 'jobzilla' ), implode( ', ', array_keys( $allowed_mime_types ) ) ) );
        }
    } else {
        $upload = wp_handle_upload( $file, apply_filters( 'submit_property_wp_handle_upload_overrides', array( 'test_form' => false ) ) );
        if ( ! empty( $upload['error'] ) ) {
            return new WP_Error( 'upload', $upload['error'] );
        } else {
            $uploaded_file->url       = $upload['url'];
            $uploaded_file->file      = $upload['file'];
            $uploaded_file->name      = basename( $upload['file'] );
            $uploaded_file->type      = $upload['type'];
            $uploaded_file->size      = $file['size'];
            $uploaded_file->extension = substr( strrchr( $uploaded_file->name, '.' ), 1 );
        }
    }

    $jobzilla_upload         = false;
    $jobzilla_uploading_file = '';

    return $uploaded_file;
}

