<?php
/**
 * Require libraries if needed.
 */
function dsx_require_folder($foldername,$path)
{
    $dir = $path . DIRECTORY_SEPARATOR . $foldername;
    if (!is_dir($dir)) {
        return;
    }
    $files = array_diff(scandir($dir), array('..', '.'));
    foreach ($files as $file) {
        $patch = $dir . DIRECTORY_SEPARATOR . $file;
        if (file_exists($patch) && strpos($file, ".php") !== false) {
            include_once $patch;
        }
    }
}


function dsx_do_the_content( $content, $autop = true ) {

    if ( $autop ) {
        $content = wpautop( preg_replace( '/<\/?p\>/', "\n", $content ) . "\n" );
    }

    return do_shortcode( shortcode_unautop( $content ) );
}

function dsx_allow_embed( $content ) {
	echo do_shortcode( $content );
}

function dsx_allow_html( $content ) {
	echo $content;
}

function dsx_crop_images()
{
	$query = array(
		'post_type'      => 'attachment',
		'posts_per_page' => -1,
		'post_status'    => 'inherit',
	);

	$media = new WP_Query($query);
	if ($media->have_posts()) {
		foreach ($media->posts as $image) {
			if (strpos($image->post_mime_type, 'image/') !== false) {
				$image_path = get_attached_file($image->ID);
				$metadata = wp_generate_attachment_metadata($image->ID, $image_path);
				wp_update_attachment_metadata($image->ID, $metadata);
			}
		}
	}
}

function dz_register_widget($class)
{
    register_widget($class);
}

function dz_register_cpt($key, $args)
{
    register_post_type($key, $args);
}

function dz_register_taxonomy($key, $id, $cat)
{
    register_taxonomy($key, $id, $cat);
}
