<?php 
	class DZ_Recent_Activities {
		
		public function __construct() {

			add_action( 'transition_post_status', array( $this, 'hooks_transition_post_status' ), 10, 3 );
		}
		
		public function hooks_transition_post_status( $new_status, $old_status, $post ) {
			global $wpdb;
			if ( 'job_listing' == get_post_type( $post->ID)) {
				$action = '';
				if( 'preview' === $old_status && 'publish' == $new_status ) {
					$action = 'listing_created';
				} elseif ( 'preview' === $old_status && 'pending_payment' == $new_status ){
					$action = 'listing_created';
				} elseif ( 'pending' === $old_status && 'publish' == $new_status ){
					$action = 'listing_approved';
				} elseif ( 'trash' === $new_status ) {
					// page was deleted.
					$action = 'listing_trashed';
				} elseif ( 'trash' === $old_status ) {
					$action = 'listing_restored';
				} elseif ('publish' == $old_status ) {
					$action = 'listing_updated';
				}
		

				if ( wp_is_post_revision( $post->ID ) )
					return;

				// Skip for menu items.
				
				$activity = array(
					'user_id' => get_post_field( 'post_author', $post->ID ),
					'post_id' => $post->ID,
					'activity' => $action,
				);
				
				if($action) {
					$wpdb->insert( $wpdb->prefix . 'dz_core_activity_log', $activity);	
				}
			}
	
			if ( 'resume' == get_post_type( $post->ID)) {
				$action = '';
				if( 'preview' === $old_status && 'publish' == $new_status ) {
					$action = 'resume_created';
				} elseif ( 'preview' === $old_status && 'pending_payment' == $new_status ){
					$action = 'resume_created';
				} elseif ( 'pending' === $old_status && 'publish' == $new_status ){
					$action = 'resume_approved';
				} elseif ( 'trash' === $new_status ) {
					// page was deleted.
					$action = 'resume_trashed';
				} elseif ( 'trash' === $old_status ) {
					$action = 'resume_restored';
				} elseif ('publish' == $old_status ) {
					$action = 'resume_updated';
				}
				

				if ( wp_is_post_revision( $post->ID ) )
					return;
				
				$activity = array(
					'user_id' => get_post_field( 'post_author', $post->ID ),
					'post_id' => $post->ID,
					'activity' => $action,
					
				);
				// Skip for menu items.
				
				if($action) {
					$wpdb->insert( $wpdb->prefix . 'dz_core_activity_log', $activity );	
				}
			}	
		}
		public function dz_core_activity($limit = null){
			global $wpdb;
			$limit = !empty($limit)? 'Limit '.$limit : '';
			$current_user = wp_get_current_user();	 
			$user_id = $current_user->ID;
			$result = $wpdb -> get_results( "
						SELECT * FROM 
						`" . $wpdb->prefix . "dz_core_activity_log` 
						WHERE  `user_id` = '$user_id'
						ORDER BY id DESC ".$limit
					);
			return $result;
		}
	}
new DZ_Recent_Activities();