<?php
/**
 * Custom post types register.
 * @since   1.0
 * @author Dexignlab
 *
 */

class Dexignlab_CPT_Register {
    // die('Working...............!');
    /**
     * Constructor
     *
     * @access private
     */
    function __construct() {
        add_action('admin_init', array($this, 'init'));
        // die('Working...............!');
    }

    function init() {
        
        // Register Default custom post type.
        $this->default_cpts();

        // Register Custom custom post type.
        $this->custom_cpts();

        // Register custom post type created by user.
        global $DZThemOptions;
        global $dsx_theme_options;

        $temp_dz_cpt_data = $DZThemOptions->ReduxFramework->get('dz_cpt_data');
        $temp_dz_cpt_data = !empty($temp_dz_cpt_data) ?  unserialize($temp_dz_cpt_data) : "";

        /* get new cpt form values */
        $dz_cpt_new_title = $dsx_theme_options[ 'dz_cpt_new_title' ];
        $dz_cpt_new_icon = $dsx_theme_options[ 'dz_cpt_new_icon' ];
        $dz_cpt_new_featured_image = $dsx_theme_options[ 'dz_cpt_new_featured_image' ];

        $dz_cpt_new_title = strtolower($dz_cpt_new_title);
        $dz_cpt_new_id = str_replace(" ", "_", $dz_cpt_new_title);

        $dz_cpt_new_title = ucfirst($dz_cpt_new_title);

        $dz_new_cpt_data = array(
            'dz_cpt_title' => $dz_cpt_new_title,
            'dz_cpt_id' => 'dz_' . $dz_cpt_new_id,
            'dz_cpt_icon' => $dz_cpt_new_icon,
            'dz_cpt_featured_image' => $dz_cpt_new_featured_image,
            'dz_cpt_type' => 'custom'
        );

        if(!empty($dz_new_cpt_data['dz_cpt_title']))
        {
            $cpt_name = $dz_new_cpt_data['dz_cpt_title'];
            $dz_cpt_id = $dz_new_cpt_data['dz_cpt_id'];
            $dz_cpt_icon = $dz_new_cpt_data['dz_cpt_icon'];
            $_featured_image = $dz_new_cpt_data['dz_cpt_featured_image'];
            /* register new cpt */ 
            $args = array_merge(array(
                'labels'              => array_merge(array(
                    'name'                  => __($cpt_name, 'dexignlab'),
                    'singular_name'         => __($cpt_name, 'dexignlab'),
                    'add_new'               => _x('Add New', 'add new on admin panel', 'dexignlab'),
                    'add_new_item'          => __('Add New', 'dexignlab') . ' ' . $cpt_name,
                    'edit_item'             => __('Edit', 'dexignlab') . ' ' . $cpt_name,
                    'new_item'              => __('New', 'dexignlab') . ' ' . $cpt_name,
                    'view_item'             => __('View', 'dexignlab') . ' ' . $cpt_name,
                    'view_items'            => __('View', 'dexignlab') . ' ' . $cpt_name . 's',
                    'search_items'          => __('Search', 'dexignlab') . ' ' . $cpt_name . 's',
                    'not_found'             => __('No', 'dexignlab') . ' ' . $cpt_name . 's' . ' ' . __('Found', 'dexignlab'),
                    'not_found_in_trash'    => __('No', 'dexignlab') . ' ' . $cpt_name . 's' . ' ' . __('Found in Trash', 'dexignlab'),
                    'parent_item_colon'     => __('Parent', 'dexignlab') . ' ' . $cpt_name . ':',
                    'all_items'             => __('All', 'dexignlab') . ' ' . $cpt_name . 's',
                    'archives'              => $cpt_name . ' ' . __('Archives', 'dexignlab'),
                    'attributes'            => $cpt_name . ' ' . __('Entry Attributes', 'dexignlab'),
                    'uploaded_to_this_item' => __('Uploaded to this', 'dexignlab') . ' ' . $cpt_name,
                    'menu_name'             => $cpt_name,
                    'filter_items_list'     => __('Filter', 'dexignlab') . ' ' . $cpt_name . ' ' . __('list', 'dexignlab'),
                    'items_list_navigation' => $cpt_name . ' ' . __('list navigation', 'dexignlab'),
                    'items_list'            => $cpt_name . ' ' . __('list', 'dexignlab'),
                    'name_admin_bar'        => $cpt_name
                )),
                'status'              => true,
                'item_name'           => __($cpt_name, 'dexignlab'),
                'items_name'          => __($cpt_name . 's', 'dexignlab'),
                'args'                => array(),
                'hierarchical'        => false,
                'description'         => '',
                'public'              => true,
                'show_ui'             => true,
                'show_in_rest'        => false,
                'show_in_menu'        => true,
                'show_in_admin_bar'   => true,
                'menu_position'       => null,
                'menu_icon'           => $dz_cpt_icon,
                'show_in_nav_menus'   => true,
                'publicly_queryable'  => true,
                'exclude_from_search' => false,
                'has_archive'         => true,
                'query_var'           => true,
                'can_export'          => true,
                'capability_type'     => 'post',
                'supports'            => array(
                    'title',
                    'editor',
                    $_featured_image,
                    'excerpt',
                    'revisions'
                )
            ));
            register_post_type($dz_cpt_id, $args);

            $DZThemOptions->ReduxFramework->set('dz_cpt_new_title', '');
            $DZThemOptions->ReduxFramework->set('dz_cpt_new_icon', '');
            $DZThemOptions->ReduxFramework->set('dz_cpt_new_featured_image', true);

            flush_rewrite_rules();
            $temp_dz_cpt_data = array_merge(array($dz_cpt_new_id => $dz_new_cpt_data ), $temp_dz_cpt_data);
            $temp_dz_cpt_data = serialize($temp_dz_cpt_data);
            $DZThemOptions->ReduxFramework->set('dz_cpt_data', $temp_dz_cpt_data);

        }
    }

    /**
     * Register custom post type
     *
     * @access public
     * @return array CPTArray
     */
    function default_cpts() {

        $dz_default_cpt_data = array(
            'dz_portfolio' => array(
                'dz_cpt_title' => 'Portfolio',
                'dz_cpt_id' => 'dz_portfolio',
                'dz_cpt_icon' => 'dashicons-portfolio',
                'dz_cpt_featured_image' => 'thumbnail',
                'dz_cpt_type' => 'default'
            ),
            'dz_team' => array(
                'dz_cpt_title' => 'Team',
                'dz_cpt_id' => 'dz_team',
                'dz_cpt_icon' => 'dashicons-buddicons-buddypress-logo',
                'dz_cpt_featured_image' => 'thumbnail',
                'dz_cpt_type' => 'default'
            ),
            'dz_service' => array(
                'dz_cpt_title' => 'Service',
                'dz_cpt_id' => 'dz_service',
                'dz_cpt_icon' => 'dashicons-admin-site-alt3',
                'dz_cpt_featured_image' => 'thumbnail',
                'dz_cpt_type' => 'default'
            ),
            'dz_testimonial' => array(
                'dz_cpt_title' => 'Testimonial',
                'dz_cpt_id' => 'dz_testimonial',
                'dz_cpt_icon' => 'dashicons-editor-insertmore',
                'dz_cpt_featured_image' => 'thumbnail',
                'dz_cpt_type' => 'default'
            )
        );

        global $DZThemOptions;
        global $dsx_theme_options;
        
        $temp_dz_cpt_data = $DZThemOptions->ReduxFramework->get('dz_cpt_data');
        $temp_dz_cpt_data = unserialize($temp_dz_cpt_data);
        
        $temp_dz_cpt_data = is_array($temp_dz_cpt_data) ? $temp_dz_cpt_data : array();

        $temp_dz_cpt_data = array_merge($temp_dz_cpt_data, $dz_default_cpt_data);
    
        $temp_dz_cpt_data = serialize($temp_dz_cpt_data);
        $DZThemOptions->ReduxFramework->set('dz_cpt_data', $temp_dz_cpt_data);
        // pr($dsx_theme_options); die();
        
        foreach ($dz_default_cpt_data as $key => $cpt) {
        
            $cpt_id = $cpt['dz_cpt_id'];
            $cpt_name = $cpt['dz_cpt_title'];
            $cpt_icon = $cpt['dz_cpt_icon'];
        
            $_featured_image_on = $dsx_theme_options[ 'cpt_'.$cpt_id.'_featured_image_on' ];

            $_editor_type = $dsx_theme_options[ 'cpt_'.$cpt_id.'_editor_type' ];

            $_featured_image = ( !$_featured_image_on || $_featured_image_on == false ) ? null : 'thumbnail';
            $_editor = ( !$_editor_type || $_editor_type == 'default' ) ? false : true;
         
            $args = array_merge(array(
                'labels'              => array_merge(array(
                    'name'                  => __($cpt_name, 'dexignlab'),
                    'singular_name'         => __($cpt_name, 'dexignlab'),
                    'add_new'               => _x('Add New', 'add new on admin panel', 'dexignlab'),
                    'add_new_item'          => __('Add New', 'dexignlab') . ' ' . $cpt_name,
                    'edit_item'             => __('Edit', 'dexignlab') . ' ' . $cpt_name,
                    'new_item'              => __('New', 'dexignlab') . ' ' . $cpt_name,
                    'view_item'             => __('View', 'dexignlab') . ' ' . $cpt_name,
                    'view_items'            => __('View', 'dexignlab') . ' ' . $cpt_name . 's',
                    'search_items'          => __('Search', 'dexignlab') . ' ' . $cpt_name . 's',
                    'not_found'             => __('No', 'dexignlab') . ' ' . $cpt_name . 's' . ' ' . __('Found', 'dexignlab'),
                    'not_found_in_trash'    => __('No', 'dexignlab') . ' ' . $cpt_name . 's' . ' ' . __('Found in Trash', 'dexignlab'),
                    'parent_item_colon'     => __('Parent', 'dexignlab') . ' ' . $cpt_name . ':',
                    'all_items'             => __('All', 'dexignlab') . ' ' . $cpt_name . 's',
                    'archives'              => $cpt_name . ' ' . __('Archives', 'dexignlab'),
                    'attributes'            => $cpt_name . ' ' . __('Entry Attributes', 'dexignlab'),
                    'uploaded_to_this_item' => __('Uploaded to this', 'dexignlab') . ' ' . $cpt_name,
                    'menu_name'             => $cpt_name,
                    'filter_items_list'     => __('Filter', 'dexignlab') . ' ' . $cpt_name . ' ' . __('list', 'dexignlab'),
                    'items_list_navigation' => $cpt_name . ' ' . __('list navigation', 'dexignlab'),
                    'items_list'            => $cpt_name . ' ' . __('list', 'dexignlab'),
                    'name_admin_bar'        => $cpt_name
                )),
                'status'              => true,
                'item_name'           => __($cpt_name, 'dexignlab'),
                'items_name'          => __($cpt_name . 's', 'dexignlab'),
                'args'                => array(),
                'hierarchical'        => false,
                'description'         => '',
                'public'              => true,
                'show_ui'             => true,
                'show_in_rest'        => $_editor,
                'show_in_menu'        => true,
                'show_in_admin_bar'   => true,
                'menu_position'       => null,
                'menu_icon'           => $cpt_icon,
                'show_in_nav_menus'   => true,
                'publicly_queryable'  => true,
                'exclude_from_search' => false,
                'has_archive'         => true,
                'query_var'           => true,
                'can_export'          => true,
                'capability_type'     => 'post',
                'supports'            => array(
                    'title',
                    'editor',
                    $_featured_image,
                    'excerpt',
                    'revisions'
                )
            ));

            register_post_type($cpt_id, $args);

            flush_rewrite_rules();
        }
    }

    function custom_cpts() {
        global $DZThemOptions;
        global $dsx_theme_options;

        $temp_dz_cpt_data = $DZThemOptions->ReduxFramework->get('dz_cpt_data');
        $temp_dz_cpt_data = unserialize($temp_dz_cpt_data);

        if(empty($temp_dz_cpt_data))
        {
            return false;
        }   

        foreach ($temp_dz_cpt_data as $cpt) {

            if($cpt['dz_cpt_type'] == 'custom')
            {
                $cpt_name = $cpt['dz_cpt_title'];
                $cpt_id = $cpt['dz_cpt_id'];
                $dz_cpt_icon = $cpt['dz_cpt_icon'];
                $_featured_image = $cpt['dz_cpt_featured_image'];

                $_editor_type = $dsx_theme_options[ 'cpt_'.$cpt_id.'_editor_type' ];
                $_editor = ($_editor_type == 'default' ) ? false : true;

                $args = array_merge(array(
                    'labels'              => array_merge(array(
                        'name'                  => __($cpt_name, 'dexignlab'),
                        'singular_name'         => __($cpt_name, 'dexignlab'),
                        'add_new'               => _x('Add New', 'add new on admin panel', 'dexignlab'),
                        'add_new_item'          => __('Add New', 'dexignlab') . ' ' . $cpt_name,
                        'edit_item'             => __('Edit', 'dexignlab') . ' ' . $cpt_name,
                        'new_item'              => __('New', 'dexignlab') . ' ' . $cpt_name,
                        'view_item'             => __('View', 'dexignlab') . ' ' . $cpt_name,
                        'view_items'            => __('View', 'dexignlab') . ' ' . $cpt_name . 's',
                        'search_items'          => __('Search', 'dexignlab') . ' ' . $cpt_name . 's',
                        'not_found'             => __('No', 'dexignlab') . ' ' . $cpt_name . 's' . ' ' . __('Found', 'dexignlab'),
                        'not_found_in_trash'    => __('No', 'dexignlab') . ' ' . $cpt_name . 's' . ' ' . __('Found in Trash', 'dexignlab'),
                        'parent_item_colon'     => __('Parent', 'dexignlab') . ' ' . $cpt_name . ':',
                        'all_items'             => __('All', 'dexignlab') . ' ' . $cpt_name . 's',
                        'archives'              => $cpt_name . ' ' . __('Archives', 'dexignlab'),
                        'attributes'            => $cpt_name . ' ' . __('Entry Attributes', 'dexignlab'),
                        'uploaded_to_this_item' => __('Uploaded to this', 'dexignlab') . ' ' . $cpt_name,
                        'menu_name'             => $cpt_name,
                        'filter_items_list'     => __('Filter', 'dexignlab') . ' ' . $cpt_name . ' ' . __('list', 'dexignlab'),
                        'items_list_navigation' => $cpt_name . ' ' . __('list navigation', 'dexignlab'),
                        'items_list'            => $cpt_name . ' ' . __('list', 'dexignlab'),
                        'name_admin_bar'        => $cpt_name
                    )),
                    'status'              => true,
                    'item_name'           => __($cpt_name, 'dexignlab'),
                    'items_name'          => __($cpt_name . 's', 'dexignlab'),
                    'args'                => array(),
                    'hierarchical'        => false,
                    'description'         => '',
                    'public'              => true,
                    'show_ui'             => true,
                    'show_in_rest'        => $_editor,
                    'show_in_menu'        => true,
                    'show_in_admin_bar'   => true,
                    'menu_position'       => null,
                    'menu_icon'           => $dz_cpt_icon,
                    'show_in_nav_menus'   => true,
                    'publicly_queryable'  => true,
                    'exclude_from_search' => false,
                    'has_archive'         => true,
                    'query_var'           => true,
                    'can_export'          => true,
                    'capability_type'     => 'post',
                    'supports'            => array(
                        'title',
                        'editor',
                        $_featured_image,
                        'excerpt',
                        'revisions'
                    )
                ));
                register_post_type($cpt_id, $args);

                flush_rewrite_rules();
            }
        }
    }
}
new Dexignlab_CPT_Register();