<?php
/**
 * Custom taxonomies register
 *
 * @package CTFramework
 * @since   1.0
 */

class Dxignlab_Texonomy_Register
{
    /**
     * Store supported taxonomies in an array
     * @var array
     * @access private
     */
    private $taxonomies = array();

    /**
     * Constructor
     *
     * @access private
     */
    function __construct()
    {
        add_action('admin_init', array($this, 'init'));
	}

    /**
     * init hook - 0
     */
    function init()
    {
		global $DZThemOptions;
        $temp_dz_cpt_data = $DZThemOptions->ReduxFramework->get('dz_cpt_data');
        $this->taxonomies = unserialize($temp_dz_cpt_data);

        foreach ($this->taxonomies as $dz_taxonomy) {
            
            $taxonomy_title = $dz_taxonomy['dz_cpt_title'];
            $taxonomy_id = $dz_taxonomy['dz_cpt_id'];
            $taxonomy_cat_id = str_replace("_", "-", $taxonomy_id);

            $categories = array_merge(array(
                'status'       => true,
                'hierarchical' => true,
                'show_ui'      => true,
                'labels'       => array_merge(array(
                    'name'              => esc_html__( $taxonomy_title . ' Categories', 'dexignlab'),
                    'singular_name'     => esc_html__( $taxonomy_title . ' Category', 'dexignlab'),
                    'edit_item'         => esc_html__('Edit', 'dexignlab') . ' ' . $taxonomy_title,
                    'update_item'       => esc_html__('Update', 'dexignlab') . ' ' . $taxonomy_title,
                    'add_new_item'      => esc_html__('Add New', 'dexignlab') . ' ' . $taxonomy_title,
                    'new_item_name'     => esc_html__('New Type', 'dexignlab') . ' ' . $taxonomy_title,
                    'all_items'         => esc_html__('All', 'dexignlab') . ' ' . $taxonomy_title.'s',
                    'search_items'      => esc_html__('Search', 'dexignlab') . ' ' . $taxonomy_title,
                    'parent_item'       => esc_html__('Parent', 'dexignlab') . ' ' . $taxonomy_title,
                    'parent_item_colon' => esc_html__('Parent', 'dexignlab') . ' ' . $taxonomy_title . ':',
                )),
                'show_in_menu' => true,
                'rewrite'      => array(
                    'slug' => $taxonomy_cat_id . '-category'
                )
            ));

            register_taxonomy($taxonomy_id . '_category', $taxonomy_id, $categories);
        }
    }
}
new Dxignlab_Texonomy_Register();