<?php

/*
Template Name: Jobzilla - Personal Blog Template

Variable
	$recaptchaSecret : Recaptcha Secret Key
 
	$dzName : Customer Name
	$dzPhone : Customer Phone Number
	
	
	$dzMailSubject : Mail Subject.
	$dzMailMessage : Mail Body
	$dzMailHeader : Mail Header
	$dzEmailReceiver : Contact receiver email address
	$dzEmailFrom : Mail Form title
	$dzEmailHeader : Mail headers
*/
/* require ReCaptcha class */
require('recaptcha-master/src/autoload.php');
require('email.php');

/* ReCaptch Secret */
$recaptchaSecret = '6LefsVUUAAAAABy0gWJlqIPO3YpVkxgcjy9XJ5kQ';

if( !function_exists( "dz_customer_enquiry" ) )
{
	function dz_customer_enquiry() 
	{
		
		$contact_email = dexignzone_get_opt('contact_email');

		$dzEmailTo		= $contact_email;   /* Receiver Email Address */
		//$dzEmailTo	= 'developer.w3itexperts@gmail.com';   /* Receiver Email Address */
		$dzEmailFrom    = "Jobzilla Contact";
		$isPHPMailer	=	'no';

		$dzRes = array();
		
		try {
			if (!empty($_POST)) {

				$reCaptchaEnable = isset($_POST['reCaptchaEnable']) ? $_POST['reCaptchaEnable'] : 1;
			
				/* validate the ReCaptcha, if something is wrong, we throw an Exception,
					i.e. code stops executing and goes to catch() block */
				if($reCaptchaEnable)
				{
				
					if (!isset($_POST['g-recaptcha-response'])) {
						$dzRes['status'] = 0;
						$dzRes['msg'] = esc_html__('ReCaptcha is not set.');
						echo json_encode($dzRes);
						exit;
					} 

					/* do not forget to enter your secret key from https://www.google.com/recaptcha/admin */
					
					$recaptcha = new \ReCaptcha\ReCaptcha($recaptchaSecret, new \ReCaptcha\RequestMethod\CurlPost());
					
					/* we validate the ReCaptcha field together with the user's IP address */
					 
					$response = $recaptcha->verify($_POST['g-recaptcha-response'], $_SERVER['REMOTE_ADDR']);

					if (!$response->isSuccess()) {
						$error = true;
						$dzRes['status'] = 0;
						$dzRes['msg'] = esc_html__('ReCaptcha was not validated.');
						echo json_encode($dzRes);
						exit;
					}
				}
				
				#### Newsletter Form Script ####
				if($_POST['dzToDo'] == 'Newsletter')
				{
						$dzName		=  isset($_POST['dzName'])?$_POST['dzName']:'';
						$dzPhone	=  isset($_POST['dzPhone'])?$_POST['dzPhone']:'';
						
						if(empty($dzName) || empty($dzPhone))
						{
							$dzRes['status']	= 0;
							$dzRes['msg']		= 'Please fill all required fields.';
							echo json_encode($dzRes);
							exit;
						}
						
						$dzName = trim(strip_tags($dzName));
						$dzPhone = strip_tags($dzPhone);	
						$dzRes = array();
						
						/* Search Mobile Number is exists */
						$post = dz_search_meta_value('dz_customer_inquiry','inquiry_mobile_number',$dzPhone,'publish');
						
						if(!empty($post))
						{
							/* Insert Data In Customer Inquiry */
							$insert_customer = array(
								'post_type'=>'dz_customer_inquiry', // default : post 
								'ID'=>'',
								'post_title'=>$dzName,
								'post_status'=>'publish', // default : draft
								'meta_input'=>array('inquiry_mobile_number'=>$dzPhone)
							);
						
							$dzMailSubject = esc_html__('Jobzilla |Newsletter: A Person want to contact');
							$dzMailMessage	= 	"
												A person want to contact you: <br><br>
												Name: $dzName<br/>
												Phone No.: $dzPhone<br/>
												";
							
							
							if($isPHPMailer == 'yes')
							{
								/* If you want to send mail using PHPMailer */	
								
								$args['fromEmail']	= $contact_email;
								$args['toEmail']	= $dzEmailTo;
								$args['fromName']	= $dzName;
								$args['message']	= $dzMailMessage;
								$args['subject']	= $dzMailSubject;
								
								/* Send Mail */
								$mail_response = dz_mail($args);
								
								if($mail_response['status'])
								{
									
									$dzRes['status'] = 1;
									$dzRes['msg'] = esc_html__('We have received your message successfully. Thanks for Contact.');
									echo json_encode($dzRes);
									exit;
								}
								else
								{
									$dzRes['status'] = 0;
									$dzRes['msg'] = $mail_response['msg'];
									echo json_encode($dzRes);
									exit;
								}
								
							}else{
								
								/* If you want to send mail using simple mail function */
								
								$dzEmailHeader  	= "MIME-Version: 1.0\r\n";
								$dzEmailHeader 		.= "Content-type: text/html; charset=iso-8859-1\r\n";
								$dzEmailHeader 		.= "From:$dzEmailFrom <$dzName>";
								
								if(mail($dzEmailTo, $dzMailSubject, $dzMailMessage, $dzEmailHeader))
								{
									
									$dzRes['status'] = 1;
									$dzRes['msg'] = esc_html__('We have received your message successfully. Thanks for Contact.');
									echo json_encode($dzRes);
									exit;
								}
								else
								{
									$dzRes['status'] = 0;
									$dzRes['msg'] = esc_html__('Some problem in sending mail, please try again later.');
									echo json_encode($dzRes);
									exit;
								}
								
							}
						
						}else{
							$dzRes['status'] = 2;
							$dzRes['msg'] = esc_html__('Welcome in our website.');
							echo json_encode($dzRes);
							exit;
						}
				}else{
						$dzRes['status'] = 0;
						$dzRes['msg'] = esc_html__('Some problem in sending mail, please try again later.');
						echo json_encode($dzRes);
						exit;
				}
				#### Newsletter Form Script End ####
			}
		} 
		catch (\Exception $e) {
			$dzRes['status'] = 0;
			$dzRes['msg'] = $e->getMessage().esc_html__('Some problem in sending mail, please try again later.');
			echo json_encode($dzRes);
			exit;
		}
		
		
		exit;
	}
	
	
	
}

add_action( 'wp_ajax_dz_customer_enquiry', 'dz_customer_enquiry');
add_action( 'wp_ajax_nopriv_dz_customer_enquiry', 'dz_customer_enquiry');
