<?php
if( !function_exists('dexignzone_dzbase') ) {
	function dexignzone_dzbase()
	{
		return $GLOBALS['_dz_base'];
	}
}

if( !function_exists( 'dz_theme_color_scheme' ) )
{
	function dz_theme_color_scheme()
	{	
		$options = dexignzone_dzbase()->option();
		$dir = DZ_TH_ROOT;
		include_once($dir.'/includes/thirdparty/lessc.inc.php');
		$styles = dexignzone_dzbase()->option('custom_color_scheme');
		
		if( ! $styles ) return;	
		
		$transient = get_transient( '_dz_color_scheme' );
		
	
		$update = ( $styles != $transient ) ? true : false;
		if(dz_set($options, 'color_scheme') == 'custom') wp_enqueue_style( 'custom_colors', dexignzone_dzbase()->includes( 'assets/css/colors.css', true ) );
			
		set_transient( '_dz_color_scheme', $styles, DAY_IN_SECONDS );
		
		$less = new lessc;
	
		$less->setVariables(array(
		  "dz_color" => $styles,
		));
		
		// create a new cache object, and compile
		$cache = $less->cachedCompile( dexignzone_dzbase()->includes("/assets/css/color.less" ) );
	
		file_put_contents( dexignzone_dzbase()->includes('/assets/css/colors.css'), $cache["compiled"]);
		
	}
}

function dz_get_categories($arg = false, $by_slug = false, $show_all = true)
{
	global $wp_taxonomies;
	
	$dexignzone_dropdown_categories_args = array(
		'orderby'   => 'name', 
		'order'     => 'ASC', 			
		'hide_empty'    => false
    );
	
	
	if( ! empty($arg['taxonomy']) && isset($wp_taxonomies[$arg['taxonomy']]))
	{
		$dexignzone_dropdown_categories_args['taxonomy'] = $arg['taxonomy'];
	}	
	
	$categories = get_categories($dexignzone_dropdown_categories_args);
	  
	$cats = array();
	//if( $show_all ) $cats[] = esc_html__( 'All Categories', 'dexignzone' );
	
	if( !is_wp_error( $categories ) ) 
	{
		foreach($categories as $category)
		{
			if( $by_slug ) 
			{$cats[$category->slug] = $category->name;}
			else 
			{$cats[$category->term_id] = $category->name;}
		}
	}
	
	return $cats;
} 

function dz_get_sidebars($multi = false)
{
	global $wp_registered_sidebars;
	$sidebars = !($wp_registered_sidebars) ? get_option('wp_registered_sidebars') : $wp_registered_sidebars;
	if( $multi ) $data[] = array('value'=>'', 'label' => 'No Sidebar');
	else $data = array('No_Sidebar' => esc_html__('No Sidebar', 'dexignzone'));
	foreach( (array)$sidebars as $sidebar)
	{
		if( $multi ) $data[] = array( 'value'=> dz_set($sidebar, 'id'), 'label' => dz_set( $sidebar, 'name') );
		else $data[dz_set($sidebar, 'id')] = dz_set($sidebar, 'name');
	}
	return $data;
}
if( !function_exists( 'dz_set' ) ) {
	function dz_set( $var, $key, $def = '' )
	{
		if( !$var ) return false;
	
		if( is_object( $var ) && isset( $var->$key ) ) return $var->$key;
		elseif( is_array( $var ) && isset( $var[$key] ) ) return $var[$key];
		elseif( $def ) return $def;
		else return false;
	}
}
function dz_get_posts_array( $post_type = 'post', $flip = false )
{
	global $wpdb;
	$res = $wpdb->get_results( "SELECT `ID`, `post_title` FROM `" .$wpdb->prefix. "posts` WHERE `post_type` = '$post_type' AND `post_status` = 'publish' ", ARRAY_A );
	
	$return = array();
	foreach( $res as $k => $r) {
		if( $flip ) {
			if( isset( $return[dz_set($r, 'post_title')] ) ) $return[dz_set($r, 'post_title').$k] = dz_set($r, 'ID');
			else $return[dz_set($r, 'post_title')] = dz_set( $r, 'ID' );
		}
		else $return[dz_set($r, 'ID')] = dz_set($r, 'post_title');
	}
	return $return;
}
function dz_base_decode($string){
	return urldecode(base64_decode($string));
}
function dz_user_extra( $extras = array() )
{
	dexignzone_dzbase()->extras = $extras;
	add_filter('user_contactmethods', 'dz_newuserfilter' );
}

function dz_newuserfilter($old)
{
	$array = dexignzone_dzbase()->extras;
	
	$new = array_merge($array, $old);
	return $new;
}

function dz_get_font_settings( $FontSettings = array(), $StyleBefore = '', $StyleAfter = '' )
{
	$i = 1;
	$settings = dexignzone_dzbase()->option();
	$Style = '';
	foreach( $FontSettings as $k => $v )
	{
		if( $i == 1 || $i == 5 )
		{
			$Style .= ( dz_set( $settings, $k )  ) ? $v.':'.dz_set( $settings, $k ).'px;': '';
		}
		else
		{
			$Style .= ( dz_set( $settings, $k  )  ) ? $v.':'.dz_set( $settings, $k ).' !important;': '';
		}
		$i++;
	}
	return ( !empty( $Style ) ) ? $StyleBefore.$Style.$StyleAfter: '';
}

if( !function_exists( 'dz_contact_form7' ) )
{
	function dz_contact_form7(){
		$wp_posts = get_posts(array(
		'post_type' => 'wpcf7_contact_form',
		'orderby'   => 'date',
		'order'     => 'ASC',
		));
		$result = array();
		foreach ($wp_posts as $post)
		{
		$result[ $post->ID ] = $post->post_title;
		}
		return $result;
	}
}

if( !function_exists( 'dz_get_categories' ) )
{
	function dz_get_categories($arg = false)
	{	
		die('Not Running ');
		global $wp_taxonomies;		
		
		$dexignzone_categories_default_args = array(	
				'orderby'            => 'ID',
				'order'              => 'ASC',				
				'hide_empty'         => 1,				
				'hierarchical'       => true,				
		  );
		
		if( ! empty($arg['taxonomy']) && isset($wp_taxonomies[$arg['taxonomy']]) )
		{
			$dexignzone_categories_default_args['taxonomy'] = wp_kses_post($arg['taxonomy']);
		}
		
		$categories = get_categories($dexignzone_categories_default_args);		
		$cats = array();
		
		if( !is_wp_error( $categories ) ) {
			foreach($categories as $category)
			{
				$cats[$category->slug] = wp_kses_post($category->name);				
			}
		}
		return $cats;
	}
}

if( !function_exists( 'dz_generate_rand_number' ) )
{
	function dz_generate_rand_number($digit=6)
	{
	  $no = substr(strtoupper(md5(uniqid(rand()))),0,$digit);
	  return $no;
	}
}

if( !function_exists( 'dz_search_meta_value' ) )
{
	function dz_search_meta_value($post_type,$meta_key,$meta_value,$status = '')
	{
	   $post = array();
	   $query_args = array(	
			'post_type'	=> 'dz_customer_inquiry',
			'meta_key'	=>	$meta_key,
			'meta_value'=>	$meta_value,
			'meta_compare'=>'='
		);
		
		if(!empty($status))
		{
			$query_args['post_status'] = $status;
		}
		
		$query = new WP_Query($query_args);	
		
		if($query->have_posts()) {
			$post =  (array) $query->posts[0];
		}
		
		return $post;
	}
}


if(!function_exists('dz_is_plugin_active'))
{
	function dz_is_plugin_active($plugin_file_path){
		if ( 
		  in_array( 
			$plugin_file_path, 
			apply_filters( 'active_plugins', get_option( 'active_plugins' ) ) 
		  ) 
		) {
			return true;
		}else{
			return false;
		}
	}
}

/* Remove type attribute from included CSS/JS files */

if(!function_exists('dz_remove_type_attr'))
{
	function dz_remove_type_attr($tag, $handle) 
	{
		return preg_replace( "/type=['\"]text\/(javascript|css)['\"]/", '', $tag );
	}
}

add_filter('style_loader_tag', 'dz_remove_type_attr', 10, 2);
add_filter('script_loader_tag', 'dz_remove_type_attr', 10, 2);

if( !function_exists( 'dexignzone_get_opt' ) )
{
	function dexignzone_get_opt( $opt_id, $default = false ) {
		$opt_name = dexignzone_get_opt_name();
		if ( empty( $opt_name ) ) {
			return $default;
		}

		global ${$opt_name};
		if ( ! isset( ${$opt_name} ) || ! isset( ${$opt_name}[ $opt_id ] ) ) {
			$options = get_option( $opt_name );
		} else {
			$options = ${$opt_name};
		}
		if ( ! isset( $options ) || ! isset( $options[ $opt_id ] ) || $options[ $opt_id ] === '' ) {
			return $default;
		}
		if ( is_array( $options[ $opt_id ] ) && is_array( $default ) ) {
			foreach ( $options[ $opt_id ] as $key => $value ) {
				if ( isset( $default[ $key ] ) && $value === '' ) {
					$options[ $opt_id ][ $key ] = $default[ $key ];
				}
			}
		}

		return $options[ $opt_id ];
	}
}

/**
 * Get theme option based on its id.
 *
 * @param  string $opt_id Required. the option id.
 * @param  mixed $default Optional. Default if the option is not found or not yet saved.
 *                         If not set, false will be used
 *
 * @return mixed
 */
if( !function_exists( 'dexignzone_get_opt' ) )
{
	function dexignzone_get_opt( $opt_id, $default = false ) {
		$opt_name = dexignzone_get_opt_name();
		if ( empty( $opt_name ) ) {
			return $default;
		}

		global ${$opt_name};
		if ( ! isset( ${$opt_name} ) || ! isset( ${$opt_name}[ $opt_id ] ) ) {
			$options = get_option( $opt_name );
		} else {
			$options = ${$opt_name};
		}
		if ( ! isset( $options ) || ! isset( $options[ $opt_id ] ) || $options[ $opt_id ] === '' ) {
			return $default;
		}
		if ( is_array( $options[ $opt_id ] ) && is_array( $default ) ) {
			foreach ( $options[ $opt_id ] as $key => $value ) {
				if ( isset( $default[ $key ] ) && $value === '' ) {
					$options[ $opt_id ][ $key ] = $default[ $key ];
				}
			}
		}

		return $options[ $opt_id ];
	}
}


/**
 * Get opt_name for Redux Framework options instance args and for
 * getting option value.
 *
 * @return string
 */
if( !function_exists( 'dexignzone_get_opt_name' ) )
{ 
	function dexignzone_get_opt_name() {
		return apply_filters( 'dexignzone_opt_name', 'jobzilla_theme_options' );
	}
}

if( !function_exists( 'dexignzone_latest_sticky' ) )
{ 
	function dexignzone_latest_sticky() 
	{
		/* Get all sticky posts */
		$sticky = get_option( 'sticky_posts' );
		/* Sort the stickies with the newest ones at the top */
		rsort( $sticky );
		/* Get the 5 newest stickies (change 5 for a different number) */
		$sticky = array_slice( $sticky, 0, 5 );
		/* Query sticky posts */
		$the_query = new WP_Query( array( 'post__in' => $sticky, 'ignore_sticky_posts' => 1 ) );
		// The Loop
		if ( $the_query->have_posts() ) 
		{
			$result .= '<ul>';
			while ( $the_query->have_posts() ) 
			{
				$the_query->the_post();
				$result .= '<li><a href="' .get_permalink(). '" title="'  . get_the_title() . '">' . get_the_title() . '</a><br />' . get_the_excerpt(). '</li>';
				 
			}
			$result .= '</ul>';
		} 
		else 
		{
			// no posts found
		}
		/* Restore original Post Data */
		wp_reset_postdata();
		return $result; 
	} 
	add_shortcode('latest_stickies', 'jobzilla_latest_sticky');
}	

if( !function_exists( 'dz_get_cpt_category' ) )
{ 
	function dz_get_cpt_category($cpt_taxonomy,$key='term_id') 
	{
		$categories_options = get_terms($cpt_taxonomy,array('hide_empty'=>false));
		//$categories_options = wp_list_pluck( $categories_options, 'name', 'term_id');  
		$categories_options = wp_list_pluck( $categories_options, 'name', $key);  
		$categories_options = array(0=>'Choose Category') + $categories_options ;
		$categories_options = array_flip($categories_options) ;
		
		return $categories_options;
	}
}


/**
 * Minify css
 *
 * @param  string $css
 *
 * @return string
 *
 * function prefix is theme name because this function is using in theme and you cannot put this function in theme folder because of themeforest rules
 *
 */
 
if(!function_exists('jobzilla_css_minifier')){ 
 
	function jobzilla_css_minifier( $css ) 
	{
		// Normalize whitespace
		$css = preg_replace( '/\s+/', ' ', $css );
		// Remove spaces before and after comment
		$css = preg_replace( '/(\s+)(\/\*(.*?)\*\/)(\s+)/', '$2', $css );
		// Remove comment blocks, everything between /* and */, unless
		// preserved with /*! ... */ or /** ... */
		$css = preg_replace( '~/\*(?![\!|\*])(.*?)\*/~', '', $css );
		// Remove ; before }
		$css = preg_replace( '/;(?=\s*})/', '', $css );
		// Remove space after , : ; { } */ >
		$css = preg_replace( '/(,|:|;|\{|}|\*\/|>) /', '$1', $css );
		// Remove space before , ; { } ( ) >
		$css = preg_replace( '/ (,|;|\{|}|\(|\)|>)/', '$1', $css );
		// Strips leading 0 on decimal values (converts 0.5px into .5px)
		$css = preg_replace( '/(:| )0\.([0-9]+)(%|em|ex|px|in|cm|mm|pt|pc)/i', '${1}.${2}${3}', $css );
		// Strips units if value is 0 (converts 0px to 0)
		$css = preg_replace( '/(:| )(\.?)0(%|em|ex|px|in|cm|mm|pt|pc)/i', '${1}0', $css );
		// Converts all zeros value into short-hand
		$css = preg_replace( '/0 0 0 0/', '0', $css );
		// Shortern 6-character hex color codes to 3-character where possible
		$css = preg_replace( '/#([a-f0-9])\\1([a-f0-9])\\2([a-f0-9])\\3/i', '#\1\2\3', $css );

		return trim( $css );
	}
}

/**
 * Check Color Code
 *
 * @param  string $css
 *
 * @return string
 *
 * function prefix is theme name because this function is using in theme and you cannot put this function in theme folder because of themeforest rules
 *
 */

/* Using in Theme CSS Generator File*/

if(!function_exists('jobzilla_is_valid_color')){ 
	function jobzilla_is_valid_color( $color ) 
	{
		$color = preg_replace( "/\s+/m", '', $color );

		if ( $color === 'transparent' ) {
			return true;
		}

		if ( '' == $color ) {
			return false;
		}

		// Hex format
		if ( preg_match( "/(?:^#[a-fA-F0-9]{6}$)|(?:^#[a-fA-F0-9]{3}$)/", $color ) ) {
			return true;
		}

		// rgb or rgba format
		if ( preg_match( "/(?:^rgba\(\d+\,\d+\,\d+\,(?:\d*(?:\.\d+)?)\)$)|(?:^rgb\(\d+\,\d+\,\d+\)$)/", $color ) ) {
			preg_match_all( "/\d+\.*\d*/", $color, $matches );
			if ( empty( $matches ) || empty( $matches[0] ) ) {
				return false;
			}

			$red   = empty( $matches[0][0] ) ? $matches[0][0] : 0;
			$green = empty( $matches[0][1] ) ? $matches[0][1] : 0;
			$blue  = empty( $matches[0][2] ) ? $matches[0][2] : 0;
			$alpha = empty( $matches[0][3] ) ? $matches[0][3] : 1;

			if ( $red < 0 || $red > 255 || $green < 0 || $green > 255 || $blue < 0 || $blue > 255 || $alpha < 0 || $alpha > 1.0 ) {
				return false;
			}
		} else {
			return false;
		}

		return true;
	}
}


function jobzilla_get_ws_data($options)
{
	$dzRes = array();
	$dzRes['comingsoon_bg'] = dz_set($options, 'comingsoon_bg');	
	$dzRes['comingsoon_page_title'] = dz_set($options, 'comingsoon_page_title');
	$dzRes['comingsoon_page_description'] = dz_set($options, 'comingsoon_page_description');
	$dzRes['comingsoon_page_url'] = dz_set($options, 'comingsoon_page_url');
	$dzRes['comingsoon_bg'] = !empty($dzRes['comingsoon_bg']['url'])?$dzRes['comingsoon_bg']['url']:get_template_directory_uri() . '/assets/images/bg8.jpg';
	
	/* Manage Subscription Form */
	$dzRes['comingsoon_subscribe_on'] = jobzilla_set($options, 'comingsoon_subscribe_on');
	$dzRes['subscribe_popup_title'] = jobzilla_set($options, 'subscribe_popup_title','SUBSCRIBE TO OUR NEWSLATTER');
	$dzRes['subscribe_popup_image'] = !empty($dzRes['subscribe_popup_image']['url'])?$dzRes['subscribe_popup_image']['url']:get_template_directory_uri() . '/assets/images/img1.jpg';
	
	/* End Manage Subscription Form */
	
	
	/* Maintenence Page Settings */
	$dzRes['maintenance_bg'] = dz_set($options, 'maintenance_bg');
	$dzRes['maintenance_bg'] = !empty($dzRes['maintenance_bg']['url'])?$dzRes['maintenance_bg']['url']:get_template_directory_uri() . '/assets/images/under-construct.jpg';
	
	$dzRes['maintenance_icon'] = dz_set($options, 'maintenance_icon');
	$dzRes['maintenance_icon'] = !empty($dzRes['maintenance_icon']['url'])?$dzRes['maintenance_icon']['url']:get_template_directory_uri() . '/assets/images/vlc.png';
	
	$dzRes['maintenance_title'] = dz_set($options, 'maintenance_title');
	$dzRes['maintenance_desc'] = dz_set($options, 'maintenance_desc');
	
	$dzRes['maintenence_vlc'] = get_template_directory_uri().'/assets/images/vlc.png';
	/* Maintenence Page Settings END */
	
	return $dzRes;
}

function dzcore_enqueue_scripts(){
	/*Job_Manager_Ajax hendel*/
	
	if(class_exists('WP_Job_Manager_Ajax')){
	    $ajax_url  = WP_Job_Manager_Ajax::get_endpoint();
		
		wp_dequeue_script('wp-job-manager-ajax-filters' );
		wp_deregister_script('wp-job-manager-ajax-filters');
		
		wp_register_script( 'jobzilla-wp-job-manager-ajax-filters', DZ_TH_URL . '/assets/js/jobzilla-ajax-filters.js', array( 'jquery', 'jquery-deserialize' ), 1.0, true );
		
		wp_localize_script( 'jobzilla-wp-job-manager-ajax-filters', 'job_manager_ajax_filters', array(
				'ajax_url'    => $ajax_url,
				'is_rtl'      => is_rtl() ? 1 : 0,
				'lang'        => defined( 'ICL_LANGUAGE_CODE' ) ? ICL_LANGUAGE_CODE : '', 
				'single_job_text'			=> esc_html__('job offer','jobzilla'),
				'plural_job_text'			=> esc_html__('job offers','jobzilla'),
			) 
		);
		$ajax_url = admin_url( 'admin-ajax.php', 'relative' );
		
		/*Resume filter*/
		
		wp_dequeue_script('wp-resume-manager-ajax-filters' );
		wp_deregister_script('wp-resume-manager-ajax-filters');
		
		wp_register_script( 'jobzilla-wp-resume-manager-ajax-filters', DZ_TH_URL . '/assets/js/jobzilla-resume-ajax-filters.js', array( 'jquery', 'jquery-deserialize' ), 1.0, true );
		
		wp_localize_script( 'jobzilla-wp-resume-manager-ajax-filters', 'resume_manager_ajax_filters', array(
			'ajax_url' 		=> $ajax_url,
			/*'showing_all'	=> esc_html__('Showing all resumes','jobzilla')*/
		) );
	}
}
add_action( 'wp_enqueue_scripts', 'dzcore_enqueue_scripts' );
function jobzilla_send_mail($email_to, $subject, $message, $headers, $attachments){
	$mail = wp_mail( $email_to, $subject, $message, $headers, $attachments );
	return $mail;
}
add_filter('get_avatar', 'jobzilla_gravatar_filter', 10, 6);
function jobzilla_gravatar_filter($avatar, $id_or_email, $size, $default, $alt, $args) {
			
			if(is_object($id_or_email)) {
		      // Checks if comment author is registered user by user ID
		      
		      if($id_or_email->user_id != 0) {
		        $email = $id_or_email->user_id;
		      // Checks that comment author isn't anonymous
		      } elseif(!empty($id_or_email->comment_author_email)) {
		        // Checks if comment author is registered user by e-mail address
		        $user = get_user_by('email', $id_or_email->comment_author_email);
		        // Get registered user info from profile, otherwise e-mail address should be value
		        $email = !empty($user) ? $user->ID : $id_or_email->comment_author_email;
		      }
		      $alt = $id_or_email->comment_author;
		    } else {
		      if(!empty($id_or_email)) {
		        // Find user by ID or e-mail address
		        $user = is_numeric($id_or_email) ? get_user_by('id', $id_or_email) : get_user_by('email', $id_or_email);
		      } else {
		        // Find author's name if id_or_email is empty
		        $author_name = get_query_var('author_name');
		        if(is_author()) {
		          // On author page, get user by page slug
		          $user = get_user_by('slug', $author_name);
		        } else {
		          // On post, get user by author meta
		          $user_id = get_the_author_meta('ID');
		          $user = get_user_by('id', $user_id);
		        }
		      }
		      // Set user's ID and name
		      if(!empty($user)) {
		        $email = $user->ID;
		        $alt = $user->display_name;
		      }
		    }
			if( isset($email) && is_email( $email ) && ! email_exists( $email ) ) {
				return $avatar;
			}
		

			$class = array( 'avatar', 'avatar-' . (int) $args['size'], 'photo' );

			if ( ! $args['found_avatar'] || $args['force_default'] ) {
				$class[] = 'avatar-default';
			}

			if ( $args['class'] ) {
				if ( is_array( $args['class'] ) ) {
					$class = array_merge( $class, $args['class'] );
				} else {
					$class[] = $args['class'];
				}
			}
			
			if(isset($email) && !empty($email)){
				$custom_avatar_id = get_user_meta($email, 'jobzilla_avatar_id', true); 
				$custom_avatar = wp_get_attachment_image_src($custom_avatar_id,'jobzilla-avatar');
			}

			if (isset($custom_avatar) && !empty($custom_avatar)) {
				$return = '<img src="'.$custom_avatar[0].'" class="'.esc_attr( join( ' ', $class ) ).'" width="'.$size.'" height="'.$size.'" alt="'.$alt.'" />';
			} elseif ($avatar) {
				$return = $avatar;
			} else {
				$return = '<img src="'.$default.'" class="'.esc_attr( join( ' ', $class ) ).'" width="'.$size.'" height="'.$size.'" alt="'.$alt.'" />';
			}
			
			return $return;
			
		}
		
add_action( 'show_user_profile',  'dzcore_extra_profile_fields', 10 );
add_action( 'edit_user_profile',  'dzcore_extra_profile_fields', 10 );
add_action( 'personal_options_update',  'dzcore_save_extra_profile_fields' );
add_action( 'edit_user_profile_update', 'dzcore_save_extra_profile_fields' );	
function dzcore_save_extra_profile_fields( $user_id ) {
	if ( !current_user_can( 'edit_user', $user_id ) )
	return false;
	if(isset($_POST['jobzilla_avatar_id'])) {
		update_user_meta( $user_id, 'jobzilla_avatar_id', $_POST['jobzilla_avatar_id'] );	
	}
	

}
function dzcore_media_enqueue_scripts(){
wp_enqueue_script( 'dz-media', DZ_TH_URL . '/assets/js/dz-media.js', array( 'jquery' ), '1.0', true );
wp_enqueue_script( 'dz-script', DZ_TH_URL . '/assets/js/dz-script.js', array( 'jquery' ), '1.0', true );
}
add_action( 'admin_enqueue_scripts', 'dzcore_media_enqueue_scripts' );
function  dzcore_extra_profile_fields( $user ) { 
wp_enqueue_media(); 
?>
	 
	<h3><?php esc_html_e('JobZilla Avatar' , DZ_TH_DOMAIN ); ?></h3>
	
	<table class="form-table">
		<tr>
			<th><label for="image"><?php esc_html_e('Agent Avatar' , DZ_TH_DOMAIN ); ?></label></th>
		 
			<td>
				<div class="screenshot">
				<?php 
					$custom_avatar_id = get_the_author_meta( 'jobzilla_avatar_id', $user->ID ) ;
					$custom_avatar = wp_get_attachment_image_src($custom_avatar_id,'jobzilla-avatar');
					if ($custom_avatar)  {
						echo '<img src="'.$custom_avatar[0].'" style="width:100px;height: auto;"/><br>';
					} 
				?>
				</div>
				<input type="hidden" name="jobzilla_avatar_id" id="agent-avatar" value="<?php echo esc_attr( get_the_author_meta( 'jobzilla_avatar_id', $user->ID ) ); ?>" class="regular-text" />
				<input type="button" class="realteo-additional-user-image button-primary" value="<?php esc_attr_e( 'Upload Image',DZ_TH_DOMAIN ); ?>" id="uploadimage"/>
				<input type="button" class="realteo-additional-user-image button-primary" value="<?php esc_attr_e( 'Remove Image',DZ_TH_DOMAIN ); ?>" id="removeimage"/>
				<br />
				<span class="description"><?php esc_html_e('This avatar will be displayed instead of default one',DZ_TH_DOMAIN); ?></span>
			</td>
		</tr>
	 
	</table>
	
<?php }

if(function_exists('dashboard_view')){
	add_shortcode('jobzilla_dashboard' ,'dashboard_view');
}
if(function_exists('login_view')){
	add_shortcode('jobzilla_login' ,'login_view');
}
if(function_exists('register_view')){
	add_shortcode('jobzilla_register' ,'register_view');
}
if(function_exists('lost_password_view')){ 
	add_shortcode('jobzilla_forgot_password' ,'lost_password_view');
}

/* Temporary Code */
function jobzilla_hide_admin_bar(){
	if(!WP_DEBUG){
		show_admin_bar(false);
	}
}
/* Temporary Code END */

