<?php
if( !function_exists( 'dz_set' ) ) {
	function dz_set( $var, $key, $def = '' )
	{
		if( !$var ) return false;
	
		if( is_object( $var ) && isset( $var->$key ) ) return $var->$key;
		elseif( is_array( $var ) && isset( $var[$key] ) ) return $var[$key];
		elseif( $def ) return $def;
		else return false;
	}
}

function dz_get_rev_slider() {
	global $wpdb;
	
	$table = $wpdb->get_results("SHOW TABLES LIKE '".$wpdb->prefix."revslider_sliders'", ARRAY_A);
	if( !$table ) return array();
	
	$res = $wpdb->get_results("SELECT * FROM ".$wpdb->prefix."revslider_sliders");
	$return = array();
	if( $res ){
		foreach( $res as $r )
		{
			$return[dz_set( $r, 'alias' )] = dz_set( $r, 'title' );
		}
	}
	return $return;
}

function _load_plugins_class($class, $directory = 'libraries', $global = true, $prefix = 'Dexignzone_DZ_') {
	$obj = &$GLOBALS['_dz_base'];
	$obj = is_object( $obj ) ? $obj : new stdClass;
	$name = false;
	// Is the request a class extension?  If so we load it too
	$path = DZ_TH_ROOT.'includes/'.$directory.'/'.$class.'.php';
	if( file_exists($path) )
	{
		$name = $prefix.ucwords( $class );
		if (class_exists($name) === false)	require($path);
		}
	// Did we find the class?
	if ($name === false) exit('Unable to locate the specified class: '.$class.'.php');
	if( $global ) $GLOBALS['_dz_base']->$class = new $name();
	else new $name();
}
if( isset( $_GET['dz_shortcode_editor_action'] ) ) {
	include_once('resource/shortcode_output.php'); exit;
}

function _dz_widget_init_register() {
	/*Footer Widget*/
	if( class_exists( 'Jobzilla_DZ_About_Us' ) ){register_widget( 'Jobzilla_DZ_About_Us' );	}
	if( class_exists( 'Jobzilla_DZ_Navigation' ) ){register_widget( 'Jobzilla_DZ_Navigation' );	}
	if( class_exists( 'Jobzilla_DZ_Recent_Post' ) ){register_widget( 'Jobzilla_DZ_Recent_Post' );	}
}
add_action( 'widgets_init', '_dz_widget_init_register' );

function _dz_plugin_init() {
	
	global $pagenow;
	
	
	include_once( 'library/functions.php' );
	include_once( 'library/mailchimp.php' );
	
	_load_plugins_class( 'post_types', 'helpers', false );
	
	_load_plugins_class( 'taxonomies', 'helpers', false );

	_load_plugins_class( 'ajax', 'helpers', false );
	
	_load_plugins_class( 'shortcodes', 'helpers', true );

	_load_plugins_class( 'region_category_image', 'helpers', true );
	_load_plugins_class( 'job_category_image', 'helpers', true );
	
	
	/* Add Shortcodes */
		//add_shortcode('jobzilla_user_profile', 'jobzilla_user_profile');	
		//add_shortcode('jobzilla_change_password', 'jobzilla_user_change_password');
	/* Add Shortcodes */
	
		
	if( function_exists( 'vc_map' )){
		include_once( 'vc_map.php' );
	
		/* VC Custom Field */
			include_once( 'resource/vc_custom_fields/dropdown_multi.php' );
		/* VC Custom Field END */
	}
	if(class_exists('ReduxFramework')){
		include_once DZ_TH_ROOT.'/includes/dz-redux/template-functions.php';
	}
	
	if(dz_is_plugin_active('elementor/elementor.php')){
		include_once DZ_TH_ROOT.'/includes/resource/elementor/DZElementor.php';
	}
	
	
	// scss compiler library
	if (!class_exists('scssc')) {
		 require_once ('library/classes/scss.inc.php');
	}
	
	// scss compiler library
	if(!class_exists('Front_End_Media')){
		//require_once('media.php');
	}
	if(class_exists('WP_Job_Manager')) {
		require_once ('include/class-jobzilla-wpjm-shortcodes.php');
	} 
	
	//user recent activities
	if (!class_exists('DZ_Recent_Activities')) {
		require_once ('include/recent-activities.php');
	} 
	
	if (!class_exists('Theme_Actiovation_Check')) {
		require_once ('helpers/theme_activation_check.php');
	}
	
	require_once ('include/avatar.php');
	
	


	dz_user_extra( array('facebook'=>__('Facebook', DZ_TH_DOMAIN), 'twitter'=>__('Twitter', DZ_TH_DOMAIN), 'dribbble'=>__('Dribble', DZ_TH_DOMAIN), 'github'=>__('Github', DZ_TH_DOMAIN),
	'flickr'=>__('Flickr', DZ_TH_DOMAIN), 'google-plus'=>__('Google+', DZ_TH_DOMAIN), 'youtube'=>__('Youtube', DZ_TH_DOMAIN)) );
		
}
add_action('init', '_dz_plugin_init');

function jobzilla_latest_sticky() 
{
	/* Get all sticky posts */
	$sticky = get_option( 'sticky_posts' );
	/* Sort the stickies with the newest ones at the top */
	rsort( $sticky );
	/* Get the 5 newest stickies (change 5 for a different number) */
	$sticky = array_slice( $sticky, 0, 5 );
	/* Query sticky posts */
	$the_query = new WP_Query( array( 'post__in' => $sticky, 'ignore_sticky_posts' => 1 ) );
	// The Loop
	if ( $the_query->have_posts() ) 
	{
		$result .= '<ul>';
		while ( $the_query->have_posts() ) 
		{
			$the_query->the_post();
			$result .= '<li><a href="' .get_permalink(). '" title="'  . get_the_title() . '">' . get_the_title() . '</a><br />' . get_the_excerpt(). '</li>';
			 
		}
		$result .= '</ul>';
	} 
	else 
	{
		// no posts found
	}
	/* Restore original Post Data */
	wp_reset_postdata();
	return $result; 
} 
add_shortcode('latest_stickies', 'jobzilla_latest_sticky');