<?php
namespace ElementorControls;
if (!defined('ABSPATH')) exit; // Exit if accessed directly

class Elementor_Custom_Controls {

	public function __construct() {
		add_action('elementor/controls/controls_registered', [$this, 'register_controls']);
	}
	
	public function includes() {
		require_once(DZ_ELEMENTOR_ROOT.'/custom_control/image_selector/image-selector-control.php');
	}

	public function register_controls() {
		$this->includes();
		$controls_manager = \Elementor\Plugin::$instance->controls_manager;
		$controls_manager->register_control(\Elementor\CustomControl\ImageSelector_Control::ImageSelector, new \Elementor\CustomControl\ImageSelector_Control());
	}

}
new Elementor_Custom_Controls();