<?php

/**
*
* Add Category For Theme Elements
*
**/
	
/* Contact Function Start */
function dz_get_contact_form_list() 
{
	
	$contact_form_options_arr = get_posts(
									array('post_type'     => 'wpcf7_contact_form',
									'numberposts'   => -1)
								);
	$contact_form_options = wp_list_pluck($contact_form_options_arr, 'post_title', 'post_name');
	$contact_form_options = array(esc_html__('Choose Contact Form',DZ_TH_DOMAIN)=>0) + $contact_form_options ;
	$contact_form_options = array_flip($contact_form_options);	
	return $contact_form_options;

}

/* Contact Function END */

/* Post Function Start */

function dz_add_elementor_widget_categories( $elements_manager ) 
{
	$elements_manager->add_category(
		'jobzilla',
		[
			'title' => esc_html__( 'Jobzilla', DZ_TH_DOMAIN ),
			'icon' => 'fa fa-plug',
		]
	);
}
add_action( 'elementor/elements/categories_registered', 'dz_add_elementor_widget_categories' );


function dz_get_orderby_options_list() 
{
	
	
		$orderby_options = array(
						''  =>  esc_html__('Choose Order', DZ_TH_DOMAIN),
						'date'=>esc_html__('Date', DZ_TH_DOMAIN),
						'title'=>esc_html__('Title', DZ_TH_DOMAIN),
						'name'=>esc_html__('Name', DZ_TH_DOMAIN),
						'author'=>esc_html__('Author', DZ_TH_DOMAIN),
						'comment_count' =>esc_html__('Comment Count', DZ_TH_DOMAIN),
						'meta_value_num' =>esc_html__('View Count', DZ_TH_DOMAIN),
						'rand' =>esc_html__('Random', DZ_TH_DOMAIN) 
						);
		return $orderby_options;

}

function dz_get_orderby_options_list2() 
{
	
	
		$orderby_options = array(
						''  =>  esc_html__('Choose Order', DZ_TH_DOMAIN),
						'date'=>esc_html__('Date', DZ_TH_DOMAIN),
						'title'=>esc_html__('Title', DZ_TH_DOMAIN),
						'name'=>esc_html__('Name', DZ_TH_DOMAIN),
						'author'=>esc_html__('Author', DZ_TH_DOMAIN),
						'rand' =>esc_html__('Random', DZ_TH_DOMAIN) 
						);
		return $orderby_options;

}

function dz_get_order_options_list() 
{
	
	$order_options = array(
						''  =>  esc_html__('Choose Sorting', DZ_TH_DOMAIN),
						'ASC'=> esc_html__('Ascending', DZ_TH_DOMAIN),
						'DESC'=> esc_html__('Descending', DZ_TH_DOMAIN)
						);
	return $order_options;

}

function dz_get_sidebar_layout_options_list() 
{
	
	$sidebar_layout_options = array(
								'Select Options'=>esc_html__('Choose Sidebar Layout', DZ_TH_DOMAIN),
								'left'=>esc_html__('Left Sidebar', DZ_TH_DOMAIN),
								'right'=>esc_html__('Right Sidebar', DZ_TH_DOMAIN)
								);
	return $sidebar_layout_options;

}

function dz_get_selected_sidebar_options_list() 
{
	
	$selected_sidebar_options = dz_get_sidebars();
	$selected_sidebar_options = array('' => esc_html__('Choose Sidebar')) + $selected_sidebar_options ;
	
	
	return $selected_sidebar_options;

}

function dz_get_image_preference_options_list() 
{
	
	$image_preference_options = array('all_posts'=>'All Posts', 'image_post_only'=>'Image Post Only', 'text_post_only' => 'Text Post Only'); 
	return $image_preference_options;

}

function dz_get_pagination_options_list() 
{
	
	$pagination_options = array(
					'no' 		=> esc_html__('No Pagination', DZ_TH_DOMAIN),
					'load_more' => esc_html__('Ajax Load More Button', DZ_TH_DOMAIN),
					);
	return $pagination_options;

}
/* Post Function END */

/* Extra Function Start */
function dz_get_column_options_list() 
{
	$column_options = array(
		'Select Option' => esc_html__('Choose Column', DZ_TH_DOMAIN) ,
		'col_2' => esc_html__('2 Column', DZ_TH_DOMAIN) ,
		'col_3' => esc_html__('3 Column', DZ_TH_DOMAIN),
		'col_4' => esc_html__('4 Column', DZ_TH_DOMAIN)
		
	);
	return $column_options;

}

function dz_get_column_options_list2() 
{
	$column_options = array(
		'Select Option' => esc_html__('Choose Column', DZ_TH_DOMAIN) ,
		'col_1' => esc_html__('1 Column', DZ_TH_DOMAIN) ,
		'col_2' => esc_html__('2 Column', DZ_TH_DOMAIN),
		'col_3' => esc_html__('3 Column', DZ_TH_DOMAIN)
		
	);
	return $column_options;

}

function dz_get_container_options_list() 
{
	
	$container_options = array(
		esc_html__('Select Options', DZ_TH_DOMAIN) => 'Choose Layout',
		esc_html__('container-fluid', DZ_TH_DOMAIN) => 'Wide',
		esc_html__('container', DZ_TH_DOMAIN) => 'Box'
	);
	return $container_options;

}

function dz_get_section_padding_options_list() 
{
	
	$section_padding_options = array(
		''			   =>esc_html__('Choose Padding',DZ_TH_DOMAIN),
		'content-inner'=>esc_html__('Padding Top-100 Bottom-70',DZ_TH_DOMAIN),
		'content-inner-1'=>esc_html__('Padding Top-Bottom-100',DZ_TH_DOMAIN),
		'content-inner-2'=>esc_html__('Padding Top-100 Bottom-0',DZ_TH_DOMAIN)
	);
	return $section_padding_options;

}

function dz_get_section_background_options_list() 
{
	
	$section_background_options = array(
		'0'		 =>esc_html__('Choose Background',DZ_TH_DOMAIN),
		'site-bg-light-purple'=>esc_html__('Primary Background',DZ_TH_DOMAIN),
		'site-bg-gray'=>esc_html__('Gray Background',DZ_TH_DOMAIN),
		'site-bg-white'		 =>esc_html__('White Background',DZ_TH_DOMAIN)
		);
	return $section_background_options;

}


function dz_get_active_options_list() 
{
	
	$active_options = array(
		''=>esc_html__('Inactive',DZ_TH_DOMAIN),
		'active'=>esc_html__('Active',DZ_TH_DOMAIN)
	  );
	return $active_options;

}

function dz_get_sidebar_element_options_list() 
{
	
	$sidebar_element_options = array(
		esc_html__('Select Options', DZ_TH_DOMAIN) => 'Choose Sidebar',
		esc_html__('left', DZ_TH_DOMAIN) => 'Left',
		esc_html__('right', DZ_TH_DOMAIN) => 'Right'
	);
	return $sidebar_element_options;

}

function dz_get_position_element_options_list() 
{
	
	$position_element_options = array(
		esc_html__('Select Options', DZ_TH_DOMAIN) => 'Choose Sidebar',
		esc_html__('left', DZ_TH_DOMAIN) => 'Left',
		esc_html__('right', DZ_TH_DOMAIN) => 'Right'
	);
	return $position_element_options;

}
/* Extra Function END */

function dz_get_post_slider_element_style_options_list() 
{
	
	$post_slider_element_style = array(
		esc_html__('Select Options', DZ_TH_DOMAIN) => 'Choose Style',
		esc_html__('style_1', DZ_TH_DOMAIN) => 'Style 1',
		esc_html__('style_2', DZ_TH_DOMAIN) => 'Style 2',
		esc_html__('style_3', DZ_TH_DOMAIN) => 'Style 3'
	);
	return $post_slider_element_style;

}

function dz_get_service_section_element_style() 
{
	
	$service_element_style = array(
		esc_html__('Select Options', DZ_TH_DOMAIN) => 'Choose Style',
		esc_html__('style_1', DZ_TH_DOMAIN) => 'Style 1',
		esc_html__('style_2', DZ_TH_DOMAIN) => 'Style 2',
		esc_html__('style_3', DZ_TH_DOMAIN) => 'Style 3'
		
	);
	return $service_element_style;

}

/* Section Column */
function dz_get_section_column_list() 
{
		$column_options = array(
						'col_2'=>esc_html__('Column 2', DZ_TH_DOMAIN),
						'col_3'=>esc_html__('Column 3', DZ_TH_DOMAIN),
						'col_4'=>esc_html__('Column 4', DZ_TH_DOMAIN),
					);
		return $column_options;
}

function dz_get_team_element_style_options_list() 
{
	
	$team_element_style = array(
		'choose style' => esc_html__('Choose Layout', DZ_TH_DOMAIN) ,
		esc_html__('slider', DZ_TH_DOMAIN) => 'Slider',
		esc_html__('list', DZ_TH_DOMAIN) => 'List'
	);
	return $team_element_style;

}

function dz_get_pricing_element_style_options_list() 
{
	
	$pricing_element_style = array(
		'choose style' => esc_html__('Choose Layout', DZ_TH_DOMAIN) ,
		esc_html__('wide', DZ_TH_DOMAIN) => 'Wide',
		esc_html__('right_side', DZ_TH_DOMAIN) => 'Right Side'
	);
	return $pricing_element_style;

}