<?php

namespace DZElementor\Widgets;

use Elementor\Widget_Base;

use Elementor\Controls_Manager;

class DZCandidateListing1 extends Widget_Base 
{
	public function get_name() {
		return 'dz-candidate-listing-1';
	}
	
	public function get_title() {
		return esc_html__('Candidate Listing 1',DZ_TH_DOMAIN);
	}
	
	public function get_icon() {
		return 'eicon-bullet-list';
		}
	
	public function get_categories() {
		return [ 'jobzilla' ];
	}
	
	protected function register_controls() {
		
		$this->start_controls_section(
			'general',
			[
				'label' => esc_html__( 'General', DZ_TH_DOMAIN ),
			]
		);
		
		$this->add_control(
			'candidate_listing_1_element_title',
			[
				'label' 		=> esc_html__( 'Title', DZ_TH_DOMAIN ),
				'label_block' 	=> true,
				'type' 			=> Controls_Manager::TEXT,
				'placeholder' 	=> esc_html__( 'Enter your title', DZ_TH_DOMAIN ),
				'default'		=>  esc_html__( 'Featured Candidates', DZ_TH_DOMAIN ),
			]
		);
		
		$this->add_control(
			'candidate_listing_1_element_subtitle',
			[
				'label' 		=> esc_html__( 'Subtitle', DZ_TH_DOMAIN ),
				'label_block' 	=> true,
				'type' 			=> Controls_Manager::TEXT,
				'placeholder' 	=> esc_html__( 'Enter your subtitle', DZ_TH_DOMAIN ),
				'default'		=>  esc_html__( 'Candidates', DZ_TH_DOMAIN ),
			]
		);
		
		
		$this->add_control(
			'company_listing_1_element_posts_in_categories',
			[
				'label' 		=> esc_html__( 'Include These Categories', DZ_TH_DOMAIN ),
				'show_label'	=> true,
				'label_block' 	=> true,
				'multiple' 		=> true,
				'type' 		 	=> Controls_Manager::SELECT2,
				'options'		=> dz_get_categories(array( 'taxonomy' => 'resume_category'),true),	
				'description'	=> esc_html__( 'Select multiple/ single categories', DZ_TH_DOMAIN ),
			]
		);


		$this->add_control(
			'candidate_listing_1_element_link_title',
				[
					'label'  	   => esc_html__('Button Text'),
					'label_block'  => true,
					'type'         => \Elementor\Controls_Manager::TEXT,
					'placeholder'  => esc_html__( 'Enter your Button Text', DZ_TH_DOMAIN ),
					'default'      => esc_html__('All Candidates', DZ_TH_DOMAIN),
				]
		);
		
		$this->add_control(
			'company_listing_1_element_link',
				[
					'label'  	   => esc_html__('Button Url'),
					'label_block'  => true,
					'type'         => \Elementor\Controls_Manager::URL,
					'placeholder'  => esc_html__( 'Enter your Button Url', DZ_TH_DOMAIN ),
				]
		
		);
		
		$this->end_controls_section();		
		
		/* Advance Section Start */
		$this->start_controls_section(
			'advance',
			[
				'label' => esc_html__( 'Advance', DZ_TH_DOMAIN ),
			]
		);				
		
		$this->add_control(
			'company_listing_1_element_no_of_posts',
			[
				'label' 		=> esc_html__( 'No. Of Posts Per Page', DZ_TH_DOMAIN ),
				'show_label'	=> true,
				'label_block' 	=> true,
				'type' 		 	=> Controls_Manager::NUMBER,
				'default'		=> 4,
				'title'			=>  esc_html__( 'No. Of Posts Per Page', DZ_TH_DOMAIN ),
				'description'	=> esc_html__( 'Enter no. of posts to show per page.', DZ_TH_DOMAIN ),
			]
		);
		

		$this->add_control(
			'company_listing_1_element_cols',
			[
				'label' 		=> esc_html__( 'Select Column', DZ_TH_DOMAIN ),
				'show_label'	=> true,
				'label_block' 	=> true,
				'type' 		 	=> Controls_Manager::SELECT,
				'options'		=> dz_get_column_options_list(),				
				'default'		=>  'col_2',
			]
		);
		$this->add_control(
			'company_listing_1_element_style',
			[
				'label' 	 => esc_html__( 'Style', DZ_TH_DOMAIN ),
				'show_label' => true,
				'label_block'=> true,
				'type' 		 => Controls_Manager::SELECT,
				'options'	 => array(
                                'full_width'=>esc_html__('Full Width', DZ_TH_DOMAIN),
                                'container'=>esc_html__('Container', DZ_TH_DOMAIN),
                            ),
				'default'	 =>  'full_width',
			]
		);
		
		$this->add_control(
			'company_listing_1_element_orderby',
			[
				'label' 		   => esc_html__( 'Order By', DZ_TH_DOMAIN ),
				'show_label'	   => true,
				'label_block' 	   => true,
				'type' 		 	   => Controls_Manager::SELECT,
				'options'		   => dz_get_orderby_options_list2(),
				'default'		   => 'date' ,
			]
		);
		
		$this->add_control(
			'company_listing_1_element_order',
			[
				'label' 	 => esc_html__( 'Order', DZ_TH_DOMAIN ),
				'show_label' => true,
				'label_block'=> true,
				'type' 		 => Controls_Manager::SELECT,
				'options'	 => dz_get_order_options_list(),
				'default'	 =>  'ASC',
			]
		);		
		$this->end_controls_section();
		
		
	}
	
	protected function render() 
	{

        $settings = $this->get_settings_for_display();
      
		
		DZTemplate::show_dz_template('dz-inc/elementor/elements/candidate_listing_1_element.php',$settings);
	}
	
	protected function content_template() 
	{

    }
}