<?php 
namespace DZElementor\Widgets;

use Elementor\Widget_Base;

use Elementor\Controls_Manager;

class DZContactForm1 extends Widget_Base 
{
	public function get_name() {
		return 'dz-contact-form-1';
	}
	
	public function get_title() {
		return esc_html__('Contact Form 1',DZ_TH_DOMAIN);
	}
	
	public function get_icon() {
		return 'eicon-form-horizontal';
	}
	
	public function get_categories() {
		return [ 'jobzilla' ];
	}
	
	protected function register_controls() {
		
		$this->start_controls_section(
			'general',
			[
				'label' => esc_html__( 'General', DZ_TH_DOMAIN ),
			]
		);
		
		$this->add_control(
			'contact_form_1_element_title',
			[
				'label' 		=> esc_html__( 'Title', DZ_TH_DOMAIN ),
				'label_block' 	=> true,
				'type' 			=> Controls_Manager::TEXT,
				'placeholder'	=> esc_html__( 'Enter your title', DZ_TH_DOMAIN ),
				'default' 		=> esc_html__( 'Send Us a Message', DZ_TH_DOMAIN ),
			]
		);		
		
		$this->add_control(
			'contact_form_1_element_description',
			[
				'label' 		=> esc_html__( 'Enter Description.', DZ_TH_DOMAIN ),
				'show_label'	=> true,
				'label_block' 	=> true,
				'type' 		 	=> Controls_Manager::TEXTAREA,
				'placeholder'	=> esc_html__( 'Enter Description. Here', DZ_TH_DOMAIN ),
				'default'		=> esc_html__( 'Feel free to contact us and we will get back to you as soon as we can.', DZ_TH_DOMAIN ),
				'separator'		=>  'default',
				'rows'			=>  5,
				'description'	=> esc_html__( 'Enter Description Here', DZ_TH_DOMAIN ),
			]
		);
		
		$this->add_control(
		'contact_form_1_element_contact_form',
			[
				'label' 	 => esc_html__( 'Contact Form', DZ_TH_DOMAIN ),
				'show_label' => true,
				'label_block'=> true,
				'type' 		 => Controls_Manager::SELECT,
				'options'	 => dz_get_contact_form_list(),
				'default'	 => 'jobzilla-contact-form',
			]
		);

		$this->add_control(
			'contact_form_1_element_map_iframe',
			[
				'label' 		=> esc_html__( 'Enter Map Iframe Code.', DZ_TH_DOMAIN ),
				'show_label'	=> true,
				'label_block' 	=> true,
				'type' 		 	=> Controls_Manager::TEXTAREA,
				'placeholder'	=> esc_html__( 'Enter  Map Iframe Code Here', DZ_TH_DOMAIN ),
				'separator'		=>  'default',
				'default'		=>  '<iframe src="https://www.google.com/maps/embed?pb=!1m18!1m12!1m3!1d227748.3825624477!2d75.65046970649679!3d26.88544791796718!2m3!1f0!2f0!3f0!3m2!1i1024!2i768!4f13.1!3m3!1m2!1s0x396c4adf4c57e281%3A0xce1c63a0cf22e09!2sJaipur%2C+Rajasthan!5e0!3m2!1sen!2sin!4v1500819483219" class="align-self-stretch radius-sm" style="border:0; width:100%; min-height:100%;" allowfullscreen></iframe>',
				'rows'			=>  5,
				'description'	=> esc_html__( 'Enter  Map Iframe Code Here', DZ_TH_DOMAIN ),
			]
		);
		
		$this->end_controls_section();

		/* Contact Information */
		$this->start_controls_section(
			'contact_information',
			[
				'label' => esc_html__( 'Contact Information', DZ_TH_DOMAIN ),
			]
		);
		
		$repeater = new \Elementor\Repeater();

		$repeater->add_control(
			'contact_form_1_element_item_title', [
				'label' 		=> esc_html__( 'Title', DZ_TH_DOMAIN ),
				'type' 			=> \Elementor\Controls_Manager::TEXT,
				'default' 		=> esc_html__( 'In the bay area?' , DZ_TH_DOMAIN ),
				'label_block' 	=> true,
			]
		);
		
		$repeater->add_control(
			'contact_form_1_element_item_description',
			[
				'label' 		=> esc_html__( 'Enter Description.', DZ_TH_DOMAIN ),
				'show_label'	=> true,
				'label_block' 	=> true,
				'type' 		 	=> Controls_Manager::TEXTAREA,
				'placeholder'	=> esc_html__( 'Enter Description Here', DZ_TH_DOMAIN ),
				'default'		=>  '1363-1385 Sunset Blvd Los Angeles, CA 90026, USA',
				'rows'			=>  5,
				'description'	=> esc_html__( 'Enter Description Here', DZ_TH_DOMAIN ),
			]
		);
		
		$repeater->add_control(
			'contact_form_1_element_item_icon',
			[
				'label' 		=> esc_html__( 'Icon', DZ_TH_DOMAIN ),
				'show_label'	=> true,
				'label_block' 	=> true,
				'type' 		 	=> Controls_Manager::ICONS,
			]
		);
		
		$this->add_control(
			'contact_form_1_element_item',
			[
				'label' 		=> esc_html__( 'Item List', DZ_TH_DOMAIN ),
				'type' 			=> \Elementor\Controls_Manager::REPEATER,
				'fields' 		=> $repeater->get_controls(),
				'default' 		=> [
					[
						'contact_form_1_element_item_title' 		=> esc_html__( 'In the bay area?', DZ_TH_DOMAIN ),
						'contact_form_1_element_item_description' 	=> '1363-1385 Sunset Blvd Los Angeles, CA 90026, USA',
						
					],
					[
						'contact_form_1_element_item_title' 		=> esc_html__( 'Feel free to contact us', DZ_TH_DOMAIN ),
						'contact_form_1_element_item_description' 	=> '+2 900 234 4241 <br> +2 900 234 3219',
						
					],
					[
						'contact_form_1_element_item_title' 		=> esc_html__( 'Support', DZ_TH_DOMAIN ),
						'contact_form_1_element_item_description' 	=> 'info@example.com <br> services@example.com',
						
					],
				],
				'title_field' => '{{{ contact_form_1_element_item_title }}}',
			]
		);
        
		$this->end_controls_section();
	
	}
	
	protected function render() 
	{

        $settings = $this->get_settings_for_display();
		
		DZTemplate::show_dz_template('dz-inc/elementor/elements/contact_form_1_element.php',$settings);
	}
	
	protected function content_template() 
	{

    }
}
?>