<?php 
namespace DZElementor\Widgets;

use Elementor\Widget_Base;

use Elementor\Controls_Manager;

class DZContentBox1 extends Widget_Base 
{
	public function get_name() {
		return 'dz-content-box-1';
	}
	
	public function get_title() {
		return esc_html__('Content Box 1',DZ_TH_DOMAIN);
	}
	
	public function get_icon() {
		return 'eicon-lightbox';
	}
	
	public function get_categories() {
		return [ 'jobzilla' ];
	}
	
	protected function register_controls() {
		
		$this->start_controls_section(
			'general',
			[
				'label' => esc_html__( 'General', DZ_TH_DOMAIN ),
			]
		);
		
		$this->add_control(
			'content_box_1_element_title',
			[
				'label' 		=> esc_html__( 'Title', DZ_TH_DOMAIN ),
				'label_block' 	=> true,
				'type' 			=> Controls_Manager::TEXT,
				'placeholder'	=> esc_html__( 'Enter your title', DZ_TH_DOMAIN ),
				'default' 		=> esc_html__( 'Millions of jobs. Find the one that’s right for you.', DZ_TH_DOMAIN ),
			]
		);

		$this->add_control(
			'content_box_1_element_subtitle',
			[
				'label' 		=> esc_html__( 'Subtitle', DZ_TH_DOMAIN ),
				'label_block' 	=> true,
				'type' 			=> Controls_Manager::TEXT,
				'placeholder'	=> esc_html__( 'Enter your title', DZ_TH_DOMAIN ),
				'default' 		=> esc_html__( 'About', DZ_TH_DOMAIN ),
			]
		);
		
		$this->add_control(
			'content_box_1_element_list',
			[
				'label' 		=> esc_html__( 'Enter Description.', DZ_TH_DOMAIN ),
				'show_label'	=> true,
				'label_block' 	=> true,
				'type' 		 	=> Controls_Manager::TEXTAREA,
				'placeholder'	=> esc_html__( 'Enter comma seprated Description list', DZ_TH_DOMAIN ),
				'default'		=> esc_html__( 'Full lifetime access, 20+ downloadable resources, Certificate of completion, Free Trial 7 Days', DZ_TH_DOMAIN ),
				'separator'		=>  'default',
				'rows'			=>  5,
				'description'	=> esc_html__( 'Enter Description Here', DZ_TH_DOMAIN ),
			]
		);
		
		$this->add_control(
			'content_box_1_element_image',
			[
				'label' 		=> esc_html__( 'Image', DZ_TH_DOMAIN ),
				'type' 			=> \Elementor\Controls_Manager::MEDIA,
			]
		);
		$this->add_control(
			'content_box_1_element_style',
			[
				'label' 	 => esc_html__( 'Style', DZ_TH_DOMAIN ),
				'show_label' => true,
				'label_block'=> true,
				'type' 		 => Controls_Manager::SELECT,
				'options'	 => array(
                                'style_1'=>esc_html__('Style 1', DZ_TH_DOMAIN),
                                'style_2'=>esc_html__('Style 2', DZ_TH_DOMAIN),
                            ),
				'default'	 =>  'style_1',
			]
		);
		$this->add_control(
			'content_box_1_element_job_title',
			[
				'label' 		=> esc_html__( 'Title', DZ_TH_DOMAIN ),
				'label_block' 	=> true,
				'type' 			=> Controls_Manager::TEXT,
				'placeholder' 	=> esc_html__( 'Enter your title', DZ_TH_DOMAIN ),
				'default'		=>  esc_html__( 'Job For Countries', DZ_TH_DOMAIN ),
				'condition' => [
					'content_box_1_element_style' => ['style_2'],
				],
			]
		);
		
		$this->add_control(
			'content_box_1_element_gallery',
			[
				'label' 		=> esc_html__( 'Gallery', DZ_TH_DOMAIN ),
				'type' 			=> \Elementor\Controls_Manager::GALLERY,
				'condition' => [
					'content_box_1_element_style' => ['style_2'],
				],
			]
		);
		$this->add_control(
			'content_box_1_element_number',
			[
				'label' 		=> esc_html__( 'Number', DZ_TH_DOMAIN ),
				'show_label'	=> true,
				'label_block' 	=> true,
				'type' 		 	=> Controls_Manager::NUMBER,
				'default'		=> 5,
				'title'			=>  esc_html__( 'Number', DZ_TH_DOMAIN ),
				'description'	=> esc_html__( 'Enter Number', DZ_TH_DOMAIN ),
				'condition' => [
					'content_box_1_element_style' => ['style_2'],
				],
			]
		);
		$this->add_control(
			'content_box_1_element_prefix', [
				'label' 		=> esc_html__( 'Symbol', DZ_TH_DOMAIN ),
				'type' 			=> \Elementor\Controls_Manager::TEXT,
				'default' 		=> 'M+',
				'label_block' 	=> true,
				'condition' => [
					'content_box_1_element_style' => ['style_2'],
				],
			]
		);	
		$this->add_control(
			'content_box_1_element_color',
			[
				'label' 	 => esc_html__( 'Background Color', DZ_TH_DOMAIN ),
				'show_label' => true,
				'label_block'=> true,
				'type' 		 => Controls_Manager::SELECT,
				'options'	 => array(
                                'style_1'=>esc_html__('Background Gray', DZ_TH_DOMAIN),
                                'style_2'=>esc_html__('Background White', DZ_TH_DOMAIN),
                            ),
				'default'	 =>  'style_1',
				'condition' => [
					'content_box_1_element_style' => ['style_1'],
				],
			]
		);
		$this->end_controls_section();

		$this->start_controls_section(
			'item',
			[
				'label' => esc_html__( 'Counter Box', DZ_TH_DOMAIN ),
			]
		);
		
		$repeater = new \Elementor\Repeater();
		
		$repeater->add_control(
			'content_box_1_element_item_title',
			[
				'label' 		=> esc_html__( 'Title', DZ_TH_DOMAIN ),
				'label_block' 	=> true,
				'type' 			=> Controls_Manager::TEXT,
				'placeholder' 	=> esc_html__( 'Enter your title', DZ_TH_DOMAIN ),
				'default'		=>  esc_html__( 'Job For Countries', DZ_TH_DOMAIN ),
			]
		);
		
		$repeater->add_control(
			'content_box_1_element_item_number',
			[
				'label' 		=> esc_html__( 'Number', DZ_TH_DOMAIN ),
				'show_label'	=> true,
				'label_block' 	=> true,
				'type' 		 	=> Controls_Manager::NUMBER,
				'default'		=> 5,
				'title'			=>  esc_html__( 'Number', DZ_TH_DOMAIN ),
				'description'	=> esc_html__( 'Enter Number', DZ_TH_DOMAIN ),
			]
		);

		$repeater->add_control(
			'content_box_1_element_item_image',
			[
				'label' 		=> esc_html__( 'Image', DZ_TH_DOMAIN ),
				'type' 			=> \Elementor\Controls_Manager::MEDIA,
			]
		);
		$repeater->add_control(
			'content_box_1_element_item_gallery',
			[
				'label' 		=> esc_html__( 'Gallery', DZ_TH_DOMAIN ),
				'type' 			=> \Elementor\Controls_Manager::GALLERY,
				
			]
		);
		
		$repeater->add_control(
			'content_box_1_element_item_prefix', [
				'label' 		=> esc_html__( 'Symbol', DZ_TH_DOMAIN ),
				'type' 			=> \Elementor\Controls_Manager::TEXT,
				'default' 		=> 'M+',
				'label_block' 	=> true,
			]
		);	

		$repeater->add_control(
			'content_box_1_element_item_icon_bg_color',
			[
				'label' => esc_html__( 'Icon Background Color', DZ_TH_DOMAIN ),
				'type' => \Elementor\Controls_Manager::COLOR,
			]
		);	
		
		$this->add_control(
			'content_box_1_element_item',
			[
				'label' 		=> esc_html__( 'Item List', DZ_TH_DOMAIN ),
				'type' 			=> \Elementor\Controls_Manager::REPEATER,
				'fields' 		=> $repeater->get_controls(),
				'default' 		=> [
					[
						'content_box_1_element_item_title' 	=> esc_html__( 'Job For Countries', DZ_TH_DOMAIN ),
						'content_box_1_element_item_number' 	=> 98,
						'content_box_1_element_item_prefix' 	=> '+',	
					],
					[
						'content_box_1_element_item_title' 	=> esc_html__( 'Jobs Done', DZ_TH_DOMAIN ),
						'content_box_1_element_item_number' 	=> 3,
						'content_box_1_element_item_prefix' 	=> 'K+',	
					],
					[
						'content_box_1_element_item_title' 	=> esc_html__( 'Companies Jobs', DZ_TH_DOMAIN ),
						'content_box_1_element_item_number' 	=> 12,
						'content_box_1_element_item_prefix' 	=> 'K+',	
					],
					
				],
				'title_field' => '{{{ content_box_1_element_item_title }}}'
			]
		);
        
        $this->end_controls_section();
	
	}
	
	protected function render() 
	{

        $settings = $this->get_settings_for_display();
		
		DZTemplate::show_dz_template('dz-inc/elementor/elements/content_box_1_element.php',$settings);
	}
	
	protected function content_template() 
	{

    }
}
?>