<?php 
namespace DZElementor\Widgets;

use Elementor\Widget_Base;

use Elementor\Controls_Manager;

class DZContentBox3 extends Widget_Base 
{
	public function get_name() {
		return 'dz-content-box-3';
	}
	
	public function get_title() {
		return esc_html__('Content Box 3',DZ_TH_DOMAIN);
	}
	
	public function get_icon() {
		return 'eicon-lightbox';
	}
	
	public function get_categories() {
		return [ 'jobzilla' ];
	}
	
	protected function register_controls() {
		
		$this->start_controls_section(
			'general',
			[
				'label' => esc_html__( 'General', DZ_TH_DOMAIN ),
			]
		);
		
		$this->add_control(
			'content_box_3_element_title',
			[
				'label' 		=> esc_html__( 'Title', DZ_TH_DOMAIN ),
				'label_block' 	=> true,
				'type' 			=> Controls_Manager::TEXT,
				'placeholder'	=> esc_html__( 'Enter your title', DZ_TH_DOMAIN ),
				'default' 		=> esc_html__( 'We help you connect with the organizer', DZ_TH_DOMAIN ),
			]
		);

		$this->add_control(
			'content_box_3_element_subtitle',
			[
				'label' 		=> esc_html__( 'Subtitle', DZ_TH_DOMAIN ),
				'label_block' 	=> true,
				'type' 			=> Controls_Manager::TEXT,
				'placeholder'	=> esc_html__( 'Enter your title', DZ_TH_DOMAIN ),
				'default' 		=> esc_html__( 'About', DZ_TH_DOMAIN ),
			]
		);
		
		$this->add_control(
			'content_box_3_element_description',
			[
				'label' 		=> esc_html__( 'Enter Description.', DZ_TH_DOMAIN ),
				'show_label'	=> true,
				'label_block' 	=> true,
				'type' 		 	=> Controls_Manager::TEXTAREA,
				'placeholder'	=> esc_html__( 'Enter Description', DZ_TH_DOMAIN ),
				'default'		=> esc_html__( 'Get paid easily and security. Use our resources to become independent and showcase your professional skills.', DZ_TH_DOMAIN ),
				'separator'		=>  'default',
				'rows'			=>  5,
				'description'	=> esc_html__( 'Enter Description Here', DZ_TH_DOMAIN ),
			]
		);
		
		$this->add_control(
			'content_box_3_element_image',
			[
				'label' 		=> esc_html__( 'Image', DZ_TH_DOMAIN ),
				'type' 			=> \Elementor\Controls_Manager::MEDIA,
			]
		);
	
		$this->add_control(
			'content_box_3_element_jobs',
				[
					'label'  	   => esc_html__('Jobs Available'),
					'label_block'  => true,
					'type'         => \Elementor\Controls_Manager::TEXT,
					'placeholder'  => esc_html__( 'Enter your jobs', DZ_TH_DOMAIN ),
					'default'      => '<span>45 +</span>'.esc_html__('Jobs Available', DZ_TH_DOMAIN),
				]
		);
		
		$this->add_control(
			'content_box_3_element_link_title',
				[
					'label'  	   => esc_html__('Button Text'),
					'label_block'  => true,
					'type'         => \Elementor\Controls_Manager::TEXT,
					'placeholder'  => esc_html__( 'Enter your Button Text', DZ_TH_DOMAIN ),
					'default'      => esc_html__('Read More', DZ_TH_DOMAIN),
				]
		);
		
		$this->add_control(
			'content_box_3_element_link',
				[
					'label'  	   => esc_html__('Button Url'),
					'label_block'  => true,
					'type'         => \Elementor\Controls_Manager::URL,
					'placeholder'  => esc_html__( 'Enter your Button Url', DZ_TH_DOMAIN ),
					
				]
		
		);
		
		$this->end_controls_section();
		$this->start_controls_section(
			'item',
			[
				'label' => esc_html__( 'Items', DZ_TH_DOMAIN ),
			]
		);
		
		$repeater = new \Elementor\Repeater();
		
		
		$repeater->add_control(
			'content_box_3_element_item_image',
			[
				'label' 		=> esc_html__( 'Image', DZ_TH_DOMAIN ),
				'type' 			=> \Elementor\Controls_Manager::MEDIA,
			]
		);
		$repeater->add_control(
		'margin_top',
			[
				'label' => esc_html__( 'TOP', DZ_TH_DOMAIN ),
				'type' => \Elementor\Controls_Manager::NUMBER,
				'placeholder' => '0',
				'min' => -100,
				'max' => 100,
				'step' => 1,
			]
		);
		$repeater->add_control(
			'margin_left',
			[
				'label' => esc_html__( 'Left', DZ_TH_DOMAIN ),
				'type' => \Elementor\Controls_Manager::NUMBER,
				'placeholder' => '0',
				'min' => -100,
				'max' => 100,
				'step' => 1,
			]
		);
		$repeater->add_control(
			'margin_right',
			[
				'label' => esc_html__( 'Right', DZ_TH_DOMAIN ),
				'type' => \Elementor\Controls_Manager::NUMBER,
				'placeholder' => '0',
				'min' => -100,
				'max' => 100,
				'step' => 1,
			]
		);
		$repeater->add_control(
			'margin_bottom',
			[
				'label' => esc_html__( 'Bottom', DZ_TH_DOMAIN ),
				'type' => \Elementor\Controls_Manager::NUMBER,
				'placeholder' => '0',
				'min' => -100,
				'max' => 100,
				'step' => 1,
			]
		);
		
		
		$this->add_control(
			'content_box_3_element_item',
			[
				'label' 		=> esc_html__( 'Item List', DZ_TH_DOMAIN ),
				'type' 			=> \Elementor\Controls_Manager::REPEATER,
				'fields' 		=> $repeater->get_controls(),
				'default' 		=> [
					
				],
			]
		);
        
        $this->end_controls_section();
	}
	
	protected function render() 
	{

        $settings = $this->get_settings_for_display();
		
		DZTemplate::show_dz_template('dz-inc/elementor/elements/content_box_3_element.php',$settings);
	}
	
	protected function content_template() 
	{

    }
}
?>