<?php 
namespace DZElementor\Widgets;

use Elementor\Widget_Base;

use Elementor\Controls_Manager;

class DZContentBox4 extends Widget_Base 
{
	public function get_name() {
		return 'dz-content-box-4';
	}
	
	public function get_title() {
		return esc_html__('Content Box 4',DZ_TH_DOMAIN);
	}
	
	public function get_icon() {
		return 'eicon-lightbox';
	}
	
	public function get_categories() {
		return [ 'jobzilla' ];
	}
	
	protected function register_controls() {
		
		$this->start_controls_section(
			'general',
			[
				'label' => esc_html__( 'General', DZ_TH_DOMAIN ),
			]
		);
		
		$this->add_control(
			'content_box_4_element_title',
			[
				'label' 		=> esc_html__( 'Title', DZ_TH_DOMAIN ),
				'label_block' 	=> true,
				'type' 			=> Controls_Manager::TEXT,
				'placeholder'	=> esc_html__( 'Enter your title', DZ_TH_DOMAIN ),
				'default' 		=> esc_html__( 'Build Your Personal Account Profile', DZ_TH_DOMAIN ),
			]
		);

		$this->add_control(
			'content_box_4_element_subtitle',
			[
				'label' 		=> esc_html__( 'Subtitle', DZ_TH_DOMAIN ),
				'label_block' 	=> true,
				'type' 			=> Controls_Manager::TEXT,
				'placeholder'	=> esc_html__( 'Enter your title', DZ_TH_DOMAIN ),
				'default' 		=> esc_html__( 'How to get your job', DZ_TH_DOMAIN ),
			]
		);
		
		$this->add_control(
			'content_box_4_element_description',
			[
				'label' 		=> esc_html__( 'Enter Description.', DZ_TH_DOMAIN ),
				'show_label'	=> true,
				'label_block' 	=> true,
				'type' 		 	=> Controls_Manager::TEXTAREA,
				'placeholder'	=> esc_html__( 'Enter Description', DZ_TH_DOMAIN ),
				'default'		=> esc_html__( 'Create an account for job information that you wanted, get notification everyday and you can easily apply directly to the company you want create and account now for free.', DZ_TH_DOMAIN ),
				'separator'		=>  'default',
				'rows'			=>  5,
				'description'	=> esc_html__( 'Enter Description Here', DZ_TH_DOMAIN ),
			]
		);
		
	
		$this->add_control(
			'content_box_4_element_link_title',
				[
					'label'  	   => esc_html__('Button Text'),
					'label_block'  => true,
					'type'         => \Elementor\Controls_Manager::TEXT,
					'placeholder'  => esc_html__( 'Enter your Button Text', DZ_TH_DOMAIN ),
					'default'      => esc_html__('Edit Profile', DZ_TH_DOMAIN),
				]
		);
		

		$this->add_control(
			'content_box_4_element_link',
				[
					'label'  	   => esc_html__('Button Url'),
					'label_block'  => true,
					'type'         => \Elementor\Controls_Manager::URL,
					'placeholder'  => esc_html__( 'Enter your Button Url', DZ_TH_DOMAIN ),
					
				]
		
		);
		$this->add_control(
			'content_box_4_element_icon',
				[
					'label'  	   => esc_html__('Icon'),
					'label_block'  => true,
					'type'         => \Elementor\Controls_Manager::ICONS,
				]
		);

		$this->add_control(
			'content_box_4_element_icon_title',
				[
					'label'  	   => esc_html__('Title'),
					'label_block'  => true,
					'type'         => \Elementor\Controls_Manager::TEXT,
					'placeholder'  => esc_html__( 'Enter your title', DZ_TH_DOMAIN ),
					'default'      => esc_html__('New Interview', DZ_TH_DOMAIN),
				]
		);
		$this->add_control(
			'content_box_4_element_icon_text',
				[
					'label'  	   => esc_html__('Text'),
					'label_block'  => true,
					'type'         => \Elementor\Controls_Manager::TEXT,
					'placeholder'  => esc_html__( 'Enter your  Text', DZ_TH_DOMAIN ),
					'default'      => esc_html__('You has new interview today', DZ_TH_DOMAIN),
				]
		);
		$this->add_control(
			'content_box_4_element_image',
			[
				'label' 		=> esc_html__( 'Image', DZ_TH_DOMAIN ),
				'type' 			=> \Elementor\Controls_Manager::MEDIA,
			]
		);
		$this->end_controls_section();


		$this->start_controls_section(
			'group',
			[
				'label' => esc_html__( 'Group', DZ_TH_DOMAIN ),
			]
		);
		$this->add_control(
			'content_box_4_element_item_image1',
			[
				'label' 		=> esc_html__( 'Image', DZ_TH_DOMAIN ),
				'type' 			=> \Elementor\Controls_Manager::MEDIA,
			]
		);
		$this->add_control(
			'content_box_4_element_item_title1',
			[
				'label' 		=> esc_html__( 'Title 1', DZ_TH_DOMAIN ),
				'label_block' 	=> true,
				'type' 			=> Controls_Manager::TEXT,
				'placeholder'	=> esc_html__( 'Enter your title', DZ_TH_DOMAIN ),
				'default' 		=> esc_html__( 'Complete your profile', DZ_TH_DOMAIN ),
			]
		);
		$this->add_control(
			'content_box_4_element_item_text1',
			[
				'label' 		=> esc_html__( 'Text 1', DZ_TH_DOMAIN ),
				'label_block' 	=> true,
				'type' 			=> Controls_Manager::TEXT,
				'placeholder'	=> esc_html__( 'Enter your title', DZ_TH_DOMAIN ),
				'default' 		=> esc_html__( '95% Completed', DZ_TH_DOMAIN ),
			]
		);
		$this->add_control(
			'content_box_4_element_item_image2',
			[
				'label' 		=> esc_html__( 'Image', DZ_TH_DOMAIN ),
				'type' 			=> \Elementor\Controls_Manager::MEDIA,
			]
		);
		$this->add_control(
			'content_box_4_element_item_user_name',
			[
				'label' 		=> esc_html__( 'Name', DZ_TH_DOMAIN ),
				'label_block' 	=> true,
				'type' 			=> Controls_Manager::TEXT,
				'placeholder'	=> esc_html__( 'Enter your title', DZ_TH_DOMAIN ),
				'default' 		=> esc_html__( 'Devid Smith', DZ_TH_DOMAIN ),
			]
		);
		$this->add_control(
			'content_box_4_element_item_title2',
			[
				'label' 		=> esc_html__( 'Title 2', DZ_TH_DOMAIN ),
				'label_block' 	=> true,
				'type' 			=> Controls_Manager::TEXT,
				'placeholder'	=> esc_html__( 'Enter your title', DZ_TH_DOMAIN ),
				'default' 		=> esc_html__( 'Hire Me!', DZ_TH_DOMAIN ),
			]
		);
		$this->add_control(
			'content_box_4_element_item_text2',
			[
				'label' 		=> esc_html__( 'Text 2', DZ_TH_DOMAIN ),
				'label_block' 	=> true,
				'type' 			=> Controls_Manager::TEXT,
				'placeholder'	=> esc_html__( 'Enter your title', DZ_TH_DOMAIN ),
				'default' 		=> esc_html__( 'UI/UX Designer', DZ_TH_DOMAIN ),
			]
		);
		$this->end_controls_section();
		
	}
	
	protected function render() 
	{

        $settings = $this->get_settings_for_display();
		
		DZTemplate::show_dz_template('dz-inc/elementor/elements/content_box_4_element.php',$settings);
	}
	
	protected function content_template() 
	{

    }
}
?>