<?php 
namespace DZElementor\Widgets;

use Elementor\Widget_Base;

use Elementor\Controls_Manager;

class DZContentBox5 extends Widget_Base 
{
	public function get_name() {
		return 'dz-content-box-5';
	}
	
	public function get_title() {
		return esc_html__('Content Box 5',DZ_TH_DOMAIN);
	}
	
	public function get_icon() {
		return 'eicon-lightbox';
	}
	
	public function get_categories() {
		return [ 'jobzilla' ];
	}
	
	protected function register_controls() {
		
		$this->start_controls_section(
			'general',
			[
				'label' => esc_html__( 'General', DZ_TH_DOMAIN ),
			]
		);
		
		$this->add_control(
			'content_box_5_element_title',
			[
				'label' 		=> esc_html__( 'Title', DZ_TH_DOMAIN ),
				'label_block' 	=> true,
				'type' 			=> Controls_Manager::TEXT,
				'placeholder'	=> esc_html__( 'Enter your title', DZ_TH_DOMAIN ),
				'default' 		=> esc_html__( 'We also have ', DZ_TH_DOMAIN ).'<span class="site-text-primary">job offers</span> '.esc_html('in other countries',DZ_TH_DOMAIN),
			]
		);

		$this->add_control(
			'content_box_5_element_bg_image',
			[
				'label' 		=> esc_html__( 'Background Image', DZ_TH_DOMAIN ),
				'type' 			=> \Elementor\Controls_Manager::MEDIA,
			]
		);
		
		$this->add_control(
			'content_box_5_element_image',
			[
				'label' 		=> esc_html__( 'Image', DZ_TH_DOMAIN ),
				'type' 			=> \Elementor\Controls_Manager::MEDIA,
			]
		);
	
		
		$this->add_control(
			'content_box_5_element_btn_text',
			[
				'label' 		=> esc_html__( 'Button Text', DZ_TH_DOMAIN ),
				'label_block' 	=> true,
				'type' 			=> Controls_Manager::TEXT,
				'placeholder'	=> esc_html__( 'Enter your button text', DZ_TH_DOMAIN ),
				'default' 		=> esc_html__( 'More Offers ', DZ_TH_DOMAIN ),
			]
		);

		$this->add_control(
			'content_box_5_element_link',
			[
				'label' 		=> esc_html__( 'Link', DZ_TH_DOMAIN ),
				'label_block' 	=> true,
				'type' 			=> Controls_Manager::TEXT,
				'placeholder'	=> esc_html__( 'Enter your link', DZ_TH_DOMAIN ),
			]
		);
	
		$this->end_controls_section();
		$this->start_controls_section(
			'item',
			[
				'label' => esc_html__( 'Items', DZ_TH_DOMAIN ),
			]
		);
		
		$repeater = new \Elementor\Repeater();
		
		
		$repeater->add_control(
			'content_box_5_element_item_image',
			[
				'label' 		=> esc_html__( 'Image', DZ_TH_DOMAIN ),
				'type' 			=> \Elementor\Controls_Manager::MEDIA,
			]
		);
		
		$repeater->add_control(
			'content_box_5_element_item_title',
			[
				'label' 		=> esc_html__( 'Title', DZ_TH_DOMAIN ),
				'label_block' 	=> true,
				'type' 			=> Controls_Manager::TEXT,
				'placeholder'	=> esc_html__( 'Enter your title', DZ_TH_DOMAIN ),
				'default' 		=> esc_html__( 'Denmark', DZ_TH_DOMAIN ),
			]
		);

		$this->add_control(
			'content_box_5_element_item',
			[
				'label' 		=> esc_html__( 'Item List', DZ_TH_DOMAIN ),
				'type' 			=> \Elementor\Controls_Manager::REPEATER,
				'fields' 		=> $repeater->get_controls(),
				'default' 		=> [
					[
						'content_box_5_element_item_title' 	=> esc_html__( 'Denmark', DZ_TH_DOMAIN ),
					],
					[
						'content_box_5_element_item_title' 	=> esc_html__( 'France', DZ_TH_DOMAIN ),
					],
					[
						'content_box_5_element_item_title' 	=> esc_html__( 'Netherlands', DZ_TH_DOMAIN ),
					],
					[
						'content_box_5_element_item_title' 	=> esc_html__( 'Poland', DZ_TH_DOMAIN ),
					],
					[
						'content_box_5_element_item_title' 	=> esc_html__( 'Portugal', DZ_TH_DOMAIN ),
					],
					[
						'content_box_5_element_item_title' 	=> esc_html__( 'Spain', DZ_TH_DOMAIN ),
					],
					[
						'content_box_5_element_item_title' 	=> esc_html__( 'Turkey', DZ_TH_DOMAIN ),
					],
					[
						'content_box_5_element_item_title' 	=> esc_html__( 'UAE', DZ_TH_DOMAIN ),
					],
					[
						'content_box_5_element_item_title' 	=> esc_html__( 'UK', DZ_TH_DOMAIN ),
					],
					
				],
			]
		);
		
        $this->end_controls_section();
	}
	
	protected function render() 
	{

        $settings = $this->get_settings_for_display();
		
		DZTemplate::show_dz_template('dz-inc/elementor/elements/content_box_5_element.php',$settings);
	}
	
	protected function content_template() 
	{

    }
}
?>