<?php 
namespace DZElementor\Widgets;

use Elementor\Widget_Base;

use Elementor\Controls_Manager;

class DZCounterBox1 extends Widget_Base
{
	
	public function get_name() {
		return 'dz-counter-box-1';
	}
	
	public function get_title() {
		return esc_html__('Counter Box 1',DZ_TH_DOMAIN);
	}
	
	public function get_icon() {
		return 'eicon-counter';
	}
	
	public function get_categories() {
		return [ 'jobzilla' ];
	}
	
	protected function register_controls() {
		
		$this->start_controls_section(
			'general',
			[
				'label' => esc_html__( 'General', DZ_TH_DOMAIN ),
			]
		);	
		
		$this->add_control(
			'counter_box_1_element_title',
			[
				'label' 		=> esc_html__( 'Title', DZ_TH_DOMAIN ),
				'label_block' 	=> true,
				'type' 			=> Controls_Manager::TEXT,
				'placeholder'	=> esc_html__( 'Enter your title', DZ_TH_DOMAIN ),
				'default' 		=> esc_html__( 'We help you connect with the organizer', DZ_TH_DOMAIN ),
			]
		);

		$this->add_control(
			'counter_box_1_element_subtitle',
			[
				'label' 		=> esc_html__( 'Subtitle', DZ_TH_DOMAIN ),
				'label_block' 	=> true,
				'type' 			=> Controls_Manager::TEXT,
				'placeholder'	=> esc_html__( 'Enter your title', DZ_TH_DOMAIN ),
				'default' 		=> esc_html__( 'For Employee', DZ_TH_DOMAIN ),
			]
		);

		$this->add_control(
			'counter_box_1_element_description',
			[
				'label' 		=> esc_html__( 'Enter Description.', DZ_TH_DOMAIN ),
				'show_label'	=> true,
				'label_block' 	=> true,
				'type' 		 	=> Controls_Manager::TEXTAREA,
				'placeholder'	=> esc_html__( 'Enter Description. Here', DZ_TH_DOMAIN ),
				'default'		=> esc_html__( 'Get paid easily and security. Use our resources to become independent and showcase your professional skills.', DZ_TH_DOMAIN ),
				'separator'		=>  'default',
				'rows'			=>  5,
				'description'	=> esc_html__( 'Enter Description Here', DZ_TH_DOMAIN ),
			]
		);

		$this->add_control(
			'counter_box_1_element_link_title',
				[
					'label'  	   => esc_html__('Button Text'),
					'label_block'  => true,
					'type'         => \Elementor\Controls_Manager::TEXT,
					'placeholder'  => esc_html__( 'Enter your Button Text', DZ_TH_DOMAIN ),
					'default'      => esc_html__('Get Started', DZ_TH_DOMAIN),
				]
		);
		
		$this->add_control(
			'counter_box_1_element_link',
				[
					'label'  	   => esc_html__('Button Url'),
					'label_block'  => true,
					'type'         => \Elementor\Controls_Manager::URL,
					'placeholder'  => esc_html__( 'Enter your Button Url', DZ_TH_DOMAIN ),
					
				]
		
		);
		$this->add_control(
			'counter_box_1_element_style',
				[
					'label'  	   => esc_html__('Select Style'),
					'label_block'  => true,
					'type'         => \Elementor\Controls_Manager::SELECT,
					'options'	 => array(
                                'style_1'=>esc_html__('Style 1', DZ_TH_DOMAIN),
                                'style_2'=>esc_html__('Style 2', DZ_TH_DOMAIN),
                                'style_3'=>esc_html__('Style 3', DZ_TH_DOMAIN),
                            ),
					'default'	 =>  'style_1', 
					
				]
		
		);
		$this->add_control(
			'counter_box_1_element_color',
				[
					'label' => esc_html__( 'Background Color', DZ_TH_DOMAIN ),
					'type' => \Elementor\Controls_Manager::COLOR,
					'condition' => [
						'counter_box_1_element_style' => ['style_1'],
					],
				]
		
		);
		$this->add_control(
			'counter_box_1_element_image',
			[
				'label' 		=> esc_html__( 'Upload Images', DZ_TH_DOMAIN ),
				'type' 			=> \Elementor\Controls_Manager::MEDIA,
			]
		);
		
		$this->end_controls_section();

		$this->start_controls_section(
			'item',
			[
				'label' => esc_html__( 'Counter Box 1', DZ_TH_DOMAIN ),
			]
		);
		
		$repeater = new \Elementor\Repeater();
		
		$repeater->add_control(
			'counter_box_1_element_item_title',
			[
				'label' 		=> esc_html__( 'Title', DZ_TH_DOMAIN ),
				'label_block' 	=> true,
				'type' 			=> Controls_Manager::TEXT,
				'placeholder' 	=> esc_html__( 'Enter your title', DZ_TH_DOMAIN ),
				'default'		=>  esc_html__( 'Million daily active users', DZ_TH_DOMAIN ),
			]
		);
		
		$repeater->add_control(
			'counter_box_1_element_item_number',
			[
				'label' 		=> esc_html__( 'Number', DZ_TH_DOMAIN ),
				'show_label'	=> true,
				'label_block' 	=> true,
				'type' 		 	=> Controls_Manager::TEXT,
				'default'		=> 5,
				'title'			=>  esc_html__( 'Number', DZ_TH_DOMAIN ),
				'description'	=> esc_html__( 'Enter Number', DZ_TH_DOMAIN ),
			]
		);
		
		$repeater->add_control(
			'counter_box_1_element_item_prefix', [
				'label' 		=> esc_html__( 'Symbol', DZ_TH_DOMAIN ),
				'type' 			=> \Elementor\Controls_Manager::TEXT,
				'default' 		=> 'M+',
				'label_block' 	=> true,
			]
		);		
		$repeater->add_control(
			'counter_box_1_element_item_icon', [
				'label' 		=> esc_html__( 'Icon', DZ_TH_DOMAIN ),
				'type' 			=> \Elementor\Controls_Manager::ICONS,
				'label_block' 	=> true,
			]
		);		
		
		$repeater->add_control(
			'counter_box_1_element_text_color', [
				'label' 		=> esc_html__( 'Text Color', DZ_TH_DOMAIN ),
				'type' 			=> \Elementor\Controls_Manager::COLOR,
				'default' 		=> '#56d8b1',
			]
		);		
		$this->add_control(
			'counter_box_1_element_item',
			[
				'label' 		=> esc_html__( 'Item List', DZ_TH_DOMAIN ),
				'type' 			=> \Elementor\Controls_Manager::REPEATER,
				'fields' 		=> $repeater->get_controls(),
				'default' 		=> [
					[
						'counter_box_1_element_item_title' 	=> esc_html__( 'Million daily active users', DZ_TH_DOMAIN ),
						'counter_box_1_element_item_number' 	=> 5,
						'counter_box_1_element_item_prefix' 	=> 'M+',	
					],
					[
						'counter_box_1_element_item_title' 	=> esc_html__( 'Open job positions', DZ_TH_DOMAIN ),
						'counter_box_1_element_item_number' 	=> 9,
						'counter_box_1_element_item_prefix' 	=> 'K+',	
					],
					[
						'counter_box_1_element_item_title' 	=> esc_html__( 'Million stories shared', DZ_TH_DOMAIN ),
						'counter_box_1_element_item_number' 	=> 2,
						'counter_box_1_element_item_prefix' 	=> 'M+',	
					],
					
				],
				'title_field' => '{{{ counter_box_1_element_item_number }}}'
			]
		);
        
        $this->end_controls_section();

	}
	
	protected function render() 
	{

        $settings = $this->get_settings_for_display();
		
		DZTemplate::show_dz_template('dz-inc/elementor/elements/counter_box_1_element.php',$settings);
	}
	
	protected function content_template() 
	{

    }
	
}