<?php

namespace DZElementor\Widgets;

use Elementor\Widget_Base;

use Elementor\Controls_Manager;

class DZDisplayJobs extends Widget_Base 
{
	public function get_name() {
		return 'dz-display-job';
	}
	
	public function get_title() {
		return esc_html__('Display Jobs',DZ_TH_DOMAIN);
	}
	
	public function get_icon() {
		return 'eicon-post-list';
		}
	
	public function get_categories() {
		return [ 'jobzilla' ];
	}
	
	protected function register_controls() {
		
		$this->start_controls_section(
			'general',
			[
				'label' => esc_html__( 'General', DZ_TH_DOMAIN ),
			]
		);
		$this->add_control(
			'shortcode',
			[
				'label' 	 => esc_html__( 'Jobs/Resume', DZ_TH_DOMAIN ),
				'show_label' => true,
				'label_block'=> true,
				'type' 		 => Controls_Manager::SELECT,
				'options'	 => array(
					''  =>  esc_html__('Choose shortcode', DZ_TH_DOMAIN),
					'jobs' => esc_html__('Jobs',DZ_TH_DOMAIN),
					'resumes' => esc_html__('Resumes',DZ_TH_DOMAIN),
				),
				'default'	 =>  'jobs',
			]
		);		
		
		$this->add_control(
			'display_jobs_element_list_layout',
			[
				'label' 	 => esc_html__( 'List Layout', DZ_TH_DOMAIN ),
				'show_label' => true,
				'label_block'=> true,
				'type' 		 => Controls_Manager::SELECT,
				'options'	 => array(
					''  =>  esc_html__('Choose Layout', DZ_TH_DOMAIN),
					'list' => esc_html__('List',DZ_TH_DOMAIN),
					'grid' => esc_html__('Grid',DZ_TH_DOMAIN),
				),
				'default'	 =>  'list',
			]
		);		
		
		$this->add_control(
			'display_jobs_element_show_categories',
			[
				'label' 		=> esc_html__( 'Show Categories', DZ_TH_DOMAIN ),
				'show_label'	=> true,
				'label_block' 	=> true,
				'type' 		 	=> Controls_Manager::SELECT2,
				'options'		=> array( 
					''  =>  esc_html__('Choose Option', DZ_TH_DOMAIN),
					'true' => esc_html__( 'Enabled',DZ_TH_DOMAIN ),
					'false' => esc_html__( 'Disabled',DZ_TH_DOMAIN ),
				),	
				'default'		=> 'false',
			]
		);
		
		$this->add_control(
			'display_jobs_element_categories',
			[
				'label' 		=> esc_html__( 'Include These Categories', DZ_TH_DOMAIN ),
				'show_label'	=> true,
				'label_block' 	=> true,
				'multiple' 		=> true,
				'type' 		 	=> Controls_Manager::SELECT2,
				'options'		=> dz_get_categories(array( 'taxonomy' => 'job_listing_category'),true),	
				'description'	=> esc_html__( 'Comma separate slugs to select by default.', DZ_TH_DOMAIN ),
				'condition' => [
					'shortcode' => ['jobs'],
				],
			]
		);
		
		$this->add_control(
			'display_jobs_element_selected_job_types',
			[
				'label' 		=> esc_html__( 'Include These Job Types', DZ_TH_DOMAIN ),
				'show_label'	=> true,
				'label_block' 	=> true,
				'multiple' 		=> true,
				'type' 		 	=> Controls_Manager::SELECT2,
				'options'		=> dz_get_categories(array( 'taxonomy' => 'job_listing_type'),true),	
				'description'	=> esc_html__( 'Comma separate slugs to select by default.', DZ_TH_DOMAIN ),
				'condition' => [
					'shortcode' => ['jobs'],
				],
			]
		);
		$this->add_control(
			'display_jobs_element_keywords', [
				'label' 		=> esc_html__( 'Keywords', DZ_TH_DOMAIN ),
				'type' 			=> \Elementor\Controls_Manager::TEXT,
				'label_block' 	=> true,
				'description'	=> esc_html__( 'Enter a keyword to search by default.', DZ_TH_DOMAIN ),
				'condition' => [
					'shortcode' => ['jobs'],
				],
			]
		);
		$this->add_control(
			'display_jobs_element_location', [
				'label' 		=> esc_html__( 'Location', DZ_TH_DOMAIN ),
				'type' 			=> \Elementor\Controls_Manager::TEXT,
				'label_block' 	=> true,
				'description'	=> esc_html__( 'Enter a location keyword to search by default.', DZ_TH_DOMAIN ),
				'condition' => [
					'shortcode' => ['jobs'],
				],
			]
		);
		$this->add_control(
			'display_jobs_element_featured',
			[
				'label' 		=> esc_html__( 'Include Only Featured Jobs', DZ_TH_DOMAIN ),
				'show_label'	=> true,
				//'label_block' 	=> true,
				'type' 		 	=> Controls_Manager::SWITCHER,
				'return_value' 	=> 'yes',
				'description'	=> esc_html__( 'Set to true to show only featured jobs, false to show no featured jobs.', DZ_TH_DOMAIN ),
			]
		);
		$this->add_control(
			'display_jobs_element_filled',
			[
				'label' 		=> esc_html__( ' Filled ', DZ_TH_DOMAIN ),
				'show_label'	=> true,
				//'label_block' 	=> true,
				'type' 		 	=> Controls_Manager::SWITCHER,
				'return_value' 	=> 'yes',
				'description'	=> esc_html__( 'Set to true to show only filled jobs, false to show no filled jobs.', DZ_TH_DOMAIN ),
				'condition' => [
					'shortcode' => ['jobs'],
				],
			]
		);
		$this->end_controls_section();
		
		
		$this->start_controls_section(
			'advance',
			[
				'label' => esc_html__( 'Advance', DZ_TH_DOMAIN ),
			]
		);				
		
		$this->add_control(
			'display_jobs_element_per_page',
			[
				'label' 		=> esc_html__( 'No. Of Jobs Per Page', DZ_TH_DOMAIN ),
				'show_label'	=> true,
				//'label_block' 	=> true,
				'type' 		 	=> Controls_Manager::NUMBER,
				'default'		=> 10,
				'title'			=>  esc_html__( 'No. Of Jobs Per Page', DZ_TH_DOMAIN ),
				'description'	=> esc_html__( 'Enter no. of Jobs to show per page.', DZ_TH_DOMAIN ),
			]
		);
		
		
		
		$this->add_control(
			'display_jobs_element_orderby',
			[
				'label' 		   => esc_html__( 'Order By', DZ_TH_DOMAIN ),
				'show_label'	   => true,
				'label_block' 	   => true,
				'type' 		 	   => Controls_Manager::SELECT,
				'options'		   => dz_get_orderby_options_list2(),
				'default'		   => 'date' ,
			]
		);
		
		$this->add_control(
			'display_jobs_element_order',
			[
				'label' 	 => esc_html__( 'Order', DZ_TH_DOMAIN ),
				'show_label' => true,
				'label_block'=> true,
				'type' 		 => Controls_Manager::SELECT,
				'options'	 => dz_get_order_options_list(),
				'default'	 =>  'ASC',
			]
		);		
		$this->add_control(
			'display_jobs_element_post_status',
			[
				'label' 	 => esc_html__( 'Post Status', DZ_TH_DOMAIN ),
				'show_label' => true,
				'label_block'=> true,
				'type' 		 => Controls_Manager::SELECT,
				'options'	 => array(
					''  =>  esc_html__('Choose Status', DZ_TH_DOMAIN),
					'expired' => esc_html__('Expired',DZ_TH_DOMAIN),
					'publish' => esc_html__('Publish',DZ_TH_DOMAIN),
				),
				'default'	 =>  'publish',
				'condition' => [
					'shortcode' => ['jobs'],
				],
			]
		);		
		$this->add_control(
			'display_jobs_element_show_filters',
			[
				'label' 	 => esc_html__( 'Show Filter', DZ_TH_DOMAIN ),
				'show_label' => true,
				'label_block'=> true,
				'type' 		 => Controls_Manager::SELECT,
				'options'		=> array( 
					''  =>  esc_html__('Choose Option', DZ_TH_DOMAIN),
					'true' => esc_html__( 'Enabled',DZ_TH_DOMAIN ),
					'false' => esc_html__( 'Disabled',DZ_TH_DOMAIN ),
				),	
				'default'	 =>  'true',
			]
		);		
		$this->add_control(
			'display_jobs_element_show_pagination',
			[
				'label' 	 => esc_html__( 'Pagination/Load More', DZ_TH_DOMAIN ),
				'show_label' => true,
				'label_block'=> true,
				'type' 		 => Controls_Manager::SELECT,
				'options'	 => array(
					''  =>  esc_html__('Choose Pagination', DZ_TH_DOMAIN),
					'true' => esc_html__('Pagination',DZ_TH_DOMAIN),
					'false' => esc_html__('Load More',DZ_TH_DOMAIN),
				),
				'default'	 =>  'false',
			]
		);		
		$this->end_controls_section();
		
		
	}
	
	protected function render() 
	{

        $settings = $this->get_settings_for_display();
		
		if(!empty($settings)){

		$parameters = '';
		foreach($settings as $key => $value){
			if((strpos($key, 'display_jobs_element_') !== false) && !empty($value)){
				
				if(is_array($value)){
					$value = implode(',',$value);
				}
				
				$actual_key	=	str_replace('display_jobs_element_','',$key);
				$parameters	.=	' '.$actual_key.'="'.$value.'" ';
			}
		}

		$shortcode = $settings['shortcode'].' '.$parameters;
		if(!empty($shortcode)){
			echo do_shortcode('['.$shortcode.']'); 
		}
	  }
		
	}
	
	protected function content_template() 
	{

    }
}