<?php

namespace DZElementor\Widgets;

use Elementor\Widget_Base;

use Elementor\Controls_Manager;

class DZFaq1 extends Widget_Base 
{
	public function get_name() {
		return 'dz-faq-1';
	}
	
	public function get_title() {
		return esc_html__('Faq 1',DZ_TH_DOMAIN);
	}
	
	public function get_icon() {
		return 'eicon-accordion';
		}
	
	public function get_categories() {
		return [ 'jobzilla' ];
	}
	
	protected function register_controls() {
		
		$this->start_controls_section(
			'general',
			[
				'label' => esc_html__( 'General', DZ_TH_DOMAIN ),
			]
		);
		
		$this->add_control(
			'faq_1_element_title',
			[
				'label'		   => esc_html__('Title', DZ_TH_DOMAIN),
				'label_block'  => true,
				'type' 		   => Controls_Manager::TEXT,
				'placeholder'  => esc_html__('Enter your title', DZ_TH_DOMAIN),
				'default'  => esc_html__('Faq', DZ_TH_DOMAIN),
			]
		
		);
		
		$this->add_control(
			'faq_1_element_subtitle',
			[
				'label'		   => esc_html__('Content', DZ_TH_DOMAIN),
				'label_block'  => true,
				'type' 		   => Controls_Manager::TEXT,
				'placeholder'  =>  esc_html__('Enter your Content', DZ_TH_DOMAIN),
				'default'      => esc_html__('Frequently Asked Question', DZ_TH_DOMAIN),
			]
		
		);
		
		$this->add_control(
			'faq_1_element_posts_in_categories',
			[
				'label' 		=> esc_html__( 'Include These Categories', DZ_TH_DOMAIN ),
				'show_label'	=> true,
				'label_block' 	=> true,
				'multiple' 		=> true,
				'type' 		 	=> Controls_Manager::SELECT2,
				'options'		=> dz_get_categories(array( 'taxonomy' => 'faq_category'),true),				
				'description'	=> esc_html__( 'Select multiple/ single categories', DZ_TH_DOMAIN ),
			]
		);
	
		$this->end_controls_section();
		
		$this->start_controls_section(
			'advance',
			[
				'label' => esc_html__( 'Advance', DZ_TH_DOMAIN ),
			]
		);
		
		$this->add_control(
			'faq_1_element_text_limit',
			[
				'label' 		=> esc_html__( 'Text Limit', DZ_TH_DOMAIN ),
				'show_label'	=> true,
				'label_block' 	=> true,
				'type' 		 	=> Controls_Manager::NUMBER,
				'title'			=> esc_html__( 'Text Limit', DZ_TH_DOMAIN ),
				'description'	=> esc_html__( 'Enter Text Limit', DZ_TH_DOMAIN ),
			]
		);
		
		$this->add_control(
			'faq_1_element_no_of_posts',
			[
				'label' 		=> esc_html__( 'No. Of Posts Per Page', DZ_TH_DOMAIN ),
				'show_label'	=> true,
				'label_block' 	=> true,
				'type' 		 	=> Controls_Manager::NUMBER,
				'title'			=>  esc_html__( 'No. Of Posts Per Page', DZ_TH_DOMAIN ),
				'description'	=> esc_html__( 'Enter no. of posts to show per page.', DZ_TH_DOMAIN ),
			]
		);
		
		
		$this->add_control(
			'faq_1_element_orderby',
			[
				'label' 		   => esc_html__( 'Order By', DZ_TH_DOMAIN ),
				'show_label'	   => true,
				'label_block' 	   => true,
				'type' 		 	   => Controls_Manager::SELECT,
				'options'		   => dz_get_orderby_options_list(),				
				'default'		   => 'date' ,
			]
		);
		
		$this->add_control(
			'faq_1_element_order',
			[
				'label' 	 => esc_html__( 'Order', DZ_TH_DOMAIN ),
				'show_label' => true,
				'label_block'=> true,
				'type' 		 => Controls_Manager::SELECT,
				'options'	 => dz_get_order_options_list(),				
				'default'	 =>  'ASC',
			]
		);
		
		
		$this->end_controls_section();	
		
		
	}
	
	protected function render() 
	{

        $settings = $this->get_settings_for_display();
      
		
		DZTemplate::show_dz_template('dz-inc/elementor/elements/faq_1_element.php',$settings);
	}
	
	protected function content_template() 
	{

    }
}