<?php

namespace DZElementor\Widgets;

use Elementor\Widget_Base;

use Elementor\Controls_Manager;

class DZHomeBanner1 extends Widget_Base 
{
	public function get_name() {
		return 'dz-home-banner-1';
	}
	
	public function get_title() {
		return esc_html__('Home Banner 1',DZ_TH_DOMAIN);
	}
	
	public function get_icon() {
		return 'eicon-slides';
	}
	
	public function get_categories() {
		return [ 'jobzilla' ];
	}
	
	protected function register_controls() {
		
		$this->start_controls_section(
			'general',
			[
				'label' => esc_html__( 'General', DZ_TH_DOMAIN ),
			]
		);

		$this->add_control(
			'home_banner_1_element_title', [
				'label' 		=> esc_html__( 'Title', DZ_TH_DOMAIN ),
				'type' 			=> \Elementor\Controls_Manager::TEXT,
				'default' 		=> esc_html__( 'Find the', DZ_TH_DOMAIN ). '<span class="site-text-primary">job</span> '. esc_html__('that fits your life', DZ_TH_DOMAIN ),
				'label_block' 	=> true,
			]
		);
		
		$this->add_control(
			'home_banner_1_element_subtitle',
			[
				'label' 		=> esc_html__( 'Subtitle', DZ_TH_DOMAIN ),
				'label_block' 	=> true,
				'type' 			=> Controls_Manager::TEXT,
				'placeholder' 	=> esc_html__( 'Enter your Subtitle', DZ_TH_DOMAIN ),
				'default'		=>  esc_html__( 'We Have', DZ_TH_DOMAIN ). '<span class="site-text-primary">208,000+</span> '. esc_html__('Live Jobs', DZ_TH_DOMAIN ),
			]
		);

		$this->add_control(
			'home_banner_1_element_description',
			[
				'label' 		=> esc_html__( 'Enter Description.', DZ_TH_DOMAIN ),
				'show_label'	=> true,
				'label_block' 	=> true,
				'type' 		 	=> Controls_Manager::TEXTAREA,
				'placeholder'	=> esc_html__( 'Enter Description', DZ_TH_DOMAIN ),
				'default'		=> esc_html__( 'Type your keyword, then click search to find your perfect job.', DZ_TH_DOMAIN ),
				'separator'		=>  'default',
				'rows'			=>  5,
				'description'	=> esc_html__( 'Enter Description Here', DZ_TH_DOMAIN ),
			]
		);
		
		$this->add_control(
			'home_banner_1_element_images',
			[
				'label' 		=> esc_html__( 'Upload Multiple Images', DZ_TH_DOMAIN ),
				'type' 			=> \Elementor\Controls_Manager::GALLERY,
			]
		);
        
        
        $this->add_control(
			'home_banner_1_element_placeholder_text',
			[
				'label' 		=> esc_html__( 'Placeholder Text', DZ_TH_DOMAIN ),
				'label_block' 	=> true,
				'type' 			=> Controls_Manager::TEXT,
				'placeholder' 	=> esc_html__( 'Enter your Placeholder Text', DZ_TH_DOMAIN ),
				'default'		=>  esc_html__( 'Jobs', DZ_TH_DOMAIN ),
			]
		);

		$this->add_control(
			'home_banner_1_element_search_btn',
			[
				'label' 		=> esc_html__( 'Search Button Text', DZ_TH_DOMAIN ),
				'label_block' 	=> true,
				'type' 			=> Controls_Manager::TEXT,
				'placeholder' 	=> esc_html__( 'Enter your Search Button Text', DZ_TH_DOMAIN ),
				'default'		=>  esc_html__( 'Find Jobs', DZ_TH_DOMAIN ),
			]
		);

		$this->end_controls_section();

		$this->start_controls_section(
			'item',
			[
				'label' => esc_html__( 'Items', DZ_TH_DOMAIN ),
			]
		);
		
		$repeater = new \Elementor\Repeater();
		
		$repeater->add_control(
			'home_banner_1_element_item_title',
			[
				'label' 		=> esc_html__( 'Title', DZ_TH_DOMAIN ),
				'label_block' 	=> true,
				'type' 			=> Controls_Manager::TEXT,
				'placeholder' 	=> esc_html__( 'Enter your title', DZ_TH_DOMAIN ),
				'default'		=>  esc_html__( 'Companies Jobs', DZ_TH_DOMAIN ),
			]
		);
		
		$repeater->add_control(
			'home_banner_1_element_item_number',
			[
				'label' 		=> esc_html__( 'Number', DZ_TH_DOMAIN ),
				'show_label'	=> true,
				'label_block' 	=> true,
				'type' 		 	=> Controls_Manager::NUMBER,
				'default'		=> 12,
				'title'			=>  esc_html__( 'Number', DZ_TH_DOMAIN ),
				'description'	=> esc_html__( 'Enter Number', DZ_TH_DOMAIN ),
			]
		);
		
		$repeater->add_control(
			'home_banner_1_element_item_prefix', [
				'label' 		=> esc_html__( 'Symbol', DZ_TH_DOMAIN ),
				'type' 			=> \Elementor\Controls_Manager::TEXT,
				'default' 		=> 'k+',
				'label_block' 	=> true,
			]
		);		

		$repeater->add_control(
			'home_banner_1_element_item_image',
			[
				'label' 		=> esc_html__( 'Image', DZ_TH_DOMAIN ),
				'type' 			=> \Elementor\Controls_Manager::MEDIA,
			]
		);

		$repeater->add_control(
			'home_banner_1_element_item_icon_bg_color',
			[
				'label' => esc_html__( 'Icon Background Color', DZ_TH_DOMAIN ),
				'type' => \Elementor\Controls_Manager::COLOR,
			]
		);
		
		$this->add_control(
			'home_banner_1_element_item',
			[
				'label' 		=> esc_html__( 'Item List', DZ_TH_DOMAIN ),
				'type' 			=> \Elementor\Controls_Manager::REPEATER,
				'fields' 		=> $repeater->get_controls(),
				'item_actions' => [
					'add'       => false,
					'duplicate' => false,
					'remove'    => false,
					'sort'      => true,
				],
				'default' 		=> [
					[
						'home_banner_1_element_item_title' 	=> esc_html__( 'Companies Jobs', DZ_TH_DOMAIN ),
						'home_banner_1_element_item_number' 	=> 12,
						'home_banner_1_element_item_prefix' 	=> 'K+',	
					],
					[
						'home_banner_1_element_item_title' 	=> esc_html__( 'Job For Countries', DZ_TH_DOMAIN ),
						'home_banner_1_element_item_number' 	=> 98,
						'home_banner_1_element_item_prefix' 	=> '+',	
					],
					[
						'home_banner_1_element_item_title' 	=> esc_html__( 'Jobs Done', DZ_TH_DOMAIN ),
						'home_banner_1_element_item_number' 	=> 3,
						'home_banner_1_element_item_prefix' 	=> 'K+',	
					],
					
				],
				'title_field' => '{{{ home_banner_1_element_item_title }}}'
			]
		);
        
        $this->end_controls_section();


        $this->start_controls_section(
			'search',
			[
				'label' => esc_html__( 'Search Fields', DZ_TH_DOMAIN ),
			]
		);

        $this->add_control(
			'home_banner_1_element_search_job_title',
			[
				'label' 		=> esc_html__( 'Search Job Title', DZ_TH_DOMAIN ),
				'show_label'	=> true,
				'label_block' 	=> true,
				'type' 		 	=> Controls_Manager::SWITCHER,
				'default' 		=>'yes',
				'return_value' 	=> 'yes',
				'description'	=> esc_html__( 'Enable to show Search Job Title.', DZ_TH_DOMAIN ),
			]
		);

		$this->add_control(
			'home_banner_1_element_search_job_type',
			[
				'label' 		=> esc_html__( 'Search Job Category', DZ_TH_DOMAIN ),
				'show_label'	=> true,
				'label_block' 	=> true,
				'type' 		 	=> Controls_Manager::SWITCHER,
				'default' 		=>'yes',
				'return_value' 	=> 'yes',
				'description'	=> esc_html__( 'Enable to show Search Job Category.', DZ_TH_DOMAIN ),
			]
		);

		$this->add_control(
			'home_banner_1_element_search_job_location',
			[
				'label' 		=> esc_html__( 'Search Job Location', DZ_TH_DOMAIN ),
				'show_label'	=> true,
				'label_block' 	=> true,
				'type' 		 	=> Controls_Manager::SWITCHER,
				'default' 		=>'yes',
				'return_value' 	=> 'yes',
				'description'	=> esc_html__( 'Enable to show Search Job Location.', DZ_TH_DOMAIN ),
			]
		);

		$this->add_control(
			'home_banner_1_element_job_tags_title', [
				'label' 		=> esc_html__( 'Tags Title', DZ_TH_DOMAIN ),
				'type' 			=> \Elementor\Controls_Manager::TEXT,
				'default' 		=> esc_html__( 'Popular Searches:', DZ_TH_DOMAIN ),
				'label_block' 	=> true,
			]
		);

		$this->add_control(
			'home_banner_1_element_job_tags',
			[
				'label' 		=> esc_html__( 'Job Tags', DZ_TH_DOMAIN ),
				'show_label'	=> true,
				'label_block' 	=> true,
				'type' 		 	=> Controls_Manager::SWITCHER,
				'default' 		=>'yes',
				'return_value' 	=> 'yes',
				'description'	=> esc_html__( 'Enable to show Job Tags.', DZ_TH_DOMAIN ),
			]
		);

		$this->end_controls_section();
	}
	
	protected function render() 
	{
		
        $settings = $this->get_settings_for_display();
		
		DZTemplate::show_dz_template('dz-inc/elementor/elements/home_banner_1_element.php',$settings);
		
		echo "<script>
				jQuery(document).ready(function(){
					if(jQuery('.elementor-element-edit-mode').length > 0){
						handleTwmH1BnrCarousal();
						jQuery('select').selectpicker();
					}					
				});
			 </script>
			";
	}
	
	
	protected function content_template() 
	{

    }
}