<?php

namespace DZElementor\Widgets;

use Elementor\Widget_Base;

use Elementor\Controls_Manager;

class DZHomeBanner12 extends Widget_Base 
{
	public function get_name() {
		return 'dz-home-banner-12';
	}
	
	public function get_title() {
		return esc_html__('Home Banner 12',DZ_TH_DOMAIN);
	}
	
	public function get_icon() {
		return 'eicon-accordion';
	}
	
	public function get_categories() {
		return [ 'jobzilla' ];
	}
	
	protected function register_controls() {
		
		$this->start_controls_section(
			'general',
			[
				'label' => esc_html__( 'General', DZ_TH_DOMAIN ),
			]
		);

		$this->add_control(
			'home_banner_12_element_title', [
				'label' 		=> esc_html__( 'Title', DZ_TH_DOMAIN ),
				'type' 			=> \Elementor\Controls_Manager::TEXT,
				'default' 		=> esc_html__( 'FIND TOP IT JOBS', DZ_TH_DOMAIN ),
				'label_block' 	=> true,
			]
		);
		
		$this->add_control(
			'home_banner_12_element_subtitle',
			[
				'label' 		=> esc_html__( 'Subtitle', DZ_TH_DOMAIN ),
				'label_block' 	=> true,
				'type' 			=> Controls_Manager::TEXT,
				'placeholder' 	=> esc_html__( 'Enter your Subtitle', DZ_TH_DOMAIN ),
				'default'		=>  esc_html__( 'For talent Developers', DZ_TH_DOMAIN ),
			]
		);

		$this->add_control(
			'home_banner_12_element_description',
			[
				'label' 		=> esc_html__( 'Enter Description.', DZ_TH_DOMAIN ),
				'show_label'	=> true,
				'label_block' 	=> true,
				'type' 		 	=> Controls_Manager::TEXTAREA,
				'placeholder'	=> esc_html__( 'Enter Description', DZ_TH_DOMAIN ),
				'default'		=> esc_html__( 'Type your keyword, then click search to find your perfect job.', DZ_TH_DOMAIN ),
				'separator'		=>  'default',
				'rows'			=>  5,
				'description'	=> esc_html__( 'Enter Description Here', DZ_TH_DOMAIN ),
			]
		);
		
		$this->add_control(
			'home_banner_12_element_images',
			[
				'label' 		=> esc_html__( 'Upload  Images', DZ_TH_DOMAIN ),
				'type' 			=> \Elementor\Controls_Manager::MEDIA,
			]
		);
        $this->add_control(
			'home_banner_12_element_bottom_images',
			[
				'label' 		=> esc_html__( 'Upload Images', DZ_TH_DOMAIN ),
				'type' 			=> \Elementor\Controls_Manager::MEDIA,
			]
		);
        
        $this->add_control(
			'home_banner_12_element_placeholder_text',
			[
				'label' 		=> esc_html__( 'Placeholder Text', DZ_TH_DOMAIN ),
				'label_block' 	=> true,
				'type' 			=> Controls_Manager::TEXT,
				'placeholder' 	=> esc_html__( 'Enter your Placeholder Text', DZ_TH_DOMAIN ),
				'default'		=>  esc_html__( 'ACHIEVE', DZ_TH_DOMAIN ),
			]
		);

		$this->add_control(
			'home_banner_12_element_search_btn',
			[
				'label' 		=> esc_html__( 'Search Button Text', DZ_TH_DOMAIN ),
				'label_block' 	=> true,
				'type' 			=> Controls_Manager::TEXT,
				'placeholder' 	=> esc_html__( 'Enter your Search Button Text', DZ_TH_DOMAIN ),
				'default'		=>  esc_html__( 'Find Jobs', DZ_TH_DOMAIN ),
			]
		);

		$this->end_controls_section();

        $this->start_controls_section(
			'search',
			[
				'label' => esc_html__( 'Search Fields', DZ_TH_DOMAIN ),
			]
		);

        $this->add_control(
			'home_banner_12_element_search_job_title',
			[
				'label' 		=> esc_html__( 'Search Job Title', DZ_TH_DOMAIN ),
				'show_label'	=> true,
				'label_block' 	=> true,
				'type' 		 	=> Controls_Manager::SWITCHER,
				'default' 		=> 'yes',
				'return_value' 	=> 'yes',
				'description'	=> esc_html__( 'Enable to show Search Job Title.', DZ_TH_DOMAIN ),
			]
		);

		$this->add_control(
			'home_banner_12_element_search_job_category',
			[
				'label' 		=> esc_html__( 'Search Job Category', DZ_TH_DOMAIN ),
				'show_label'	=> true,
				'label_block' 	=> true,
				'type' 		 	=> Controls_Manager::SWITCHER,
				'default' 		=>'yes',
				'return_value' 	=> 'yes',
				'description'	=> esc_html__( 'Enable to show Search Job Category.', DZ_TH_DOMAIN ),
			]
		);

		$this->add_control(
			'home_banner_12_element_search_job_location',
			[
				'label' 		=> esc_html__( 'Search Job Location', DZ_TH_DOMAIN ),
				'show_label'	=> true,
				'label_block' 	=> true,
				'type' 		 	=> Controls_Manager::SWITCHER,
				'default' 		=>'yes',
				'return_value' 	=> 'yes',
				'description'	=> esc_html__( 'Enable to show Search Job Location.', DZ_TH_DOMAIN ),
			]
		);

		$this->add_control(
			'home_banner_12_element_job_tags_title', [
				'label' 		=> esc_html__( 'Tags Title', DZ_TH_DOMAIN ),
				'type' 			=> \Elementor\Controls_Manager::TEXT,
				'default' 		=> esc_html__( 'Popular Searches:', DZ_TH_DOMAIN ),
				'label_block' 	=> true,
			]
		);

		$this->add_control(
			'home_banner_12_element_job_tags',
			[
				'label' 		=> esc_html__( 'Job Tags', DZ_TH_DOMAIN ),
				'show_label'	=> true,
				'label_block' 	=> true,
				'type' 		 	=> Controls_Manager::SWITCHER,
				'return_value' 	=> 'yes',
				'default' 		=>'yes',
				'description'	=> esc_html__( 'Enable to show Job Tags.', DZ_TH_DOMAIN ),
			]
		);

		$this->end_controls_section();
	}
	
	protected function render() 
	{
		
        $settings = $this->get_settings_for_display();
		
		DZTemplate::show_dz_template('dz-inc/elementor/elements/home_banner_12_element.php',$settings);
		
		echo "<script>
				jQuery(document).ready(function(){
					if(jQuery('.elementor-element-edit-mode').length > 0){
						jQuery('select').selectpicker();
					}					
				});
			 </script>
			";
	}
	
	
	protected function content_template() 
	{

    }
}