<?php

namespace DZElementor\Widgets;

use Elementor\Widget_Base;

use Elementor\Controls_Manager;

class DZHomeBanner5 extends Widget_Base 
{
	public function get_name() {
		return 'dz-home-banner-5';
	}
	
	public function get_title() {
		return esc_html__('Home Banner 5',DZ_TH_DOMAIN);
	}
	
	public function get_icon() {
		return 'eicon-filter';
	}
	
	public function get_categories() {
		return [ 'jobzilla' ];
	}
	
	protected function register_controls() {
		
		$this->start_controls_section(
			'general',
			[
				'label' => esc_html__( 'General', DZ_TH_DOMAIN ),
			]
		);

		$this->add_control(
			'home_banner_5_element_title', [
				'label' 		=> esc_html__( 'Title', DZ_TH_DOMAIN ),
				'type' 			=> \Elementor\Controls_Manager::TEXT,
				'default' 		=> esc_html__( 'Find Your Perfect', DZ_TH_DOMAIN ). '<span class="site-text-white">Job</span> '. esc_html__('Platform', DZ_TH_DOMAIN ),
				'label_block' 	=> true,
			]
		);
		
		$this->add_control(
			'home_banner_5_element_subtitle',
			[
				'label' 		=> esc_html__( 'Subtitle', DZ_TH_DOMAIN ),
				'label_block' 	=> true,
				'type' 			=> Controls_Manager::TEXT,
				'placeholder' 	=> esc_html__( 'Enter your Subtitle', DZ_TH_DOMAIN ),
				'default'		=>  esc_html__( ' Stay connect to get upcoming job with', DZ_TH_DOMAIN ). '<span class="site-text-primary">Jobzilla</span>',
			]
		);

		$this->add_control(
			'home_banner_5_element_description',
			[
				'label' 		=> esc_html__( 'Enter Description.', DZ_TH_DOMAIN ),
				'show_label'	=> true,
				'label_block' 	=> true,
				'type' 		 	=> Controls_Manager::TEXTAREA,
				'placeholder'	=> esc_html__( 'Enter Description', DZ_TH_DOMAIN ),
				'default'		=> esc_html__( 'Explore all the most exciting job roles based on your interest and study major. your dream job is waiting for you.', DZ_TH_DOMAIN ),
				'separator'		=>  'default',
				'rows'			=>  5,
				'description'	=> esc_html__( 'Enter Description Here', DZ_TH_DOMAIN ),
			]
		);
		
		$this->add_control(
			'home_banner_5_element_image',
			[
				'label' 		=> esc_html__( 'Image', DZ_TH_DOMAIN ),
				'type' 			=> \Elementor\Controls_Manager::MEDIA,
			]
		);
      
		$this->add_control(
			'home_banner_5_element_search_btn',
			[
				'label' 		=> esc_html__( 'Search Button Text', DZ_TH_DOMAIN ),
				'label_block' 	=> true,
				'type' 			=> Controls_Manager::TEXT,
				'placeholder' 	=> esc_html__( 'Enter your Search Button Text', DZ_TH_DOMAIN ),
				'default'		=>  esc_html__( 'Find Jobs', DZ_TH_DOMAIN ),
			]
		);

		$this->end_controls_section();

		$this->start_controls_section(
			'item',
			[
				'label' => esc_html__( 'Items', DZ_TH_DOMAIN ),
			]
		);
		
		$repeater = new \Elementor\Repeater();
		
		
		$repeater->add_control(
			'home_banner_5_element_item_image',
			[
				'label' 		=> esc_html__( 'Image', DZ_TH_DOMAIN ),
				'type' 			=> \Elementor\Controls_Manager::MEDIA,
			]
		);
		$repeater->add_control(
		'margin_top',
			[
				'label' => esc_html__( 'TOP', DZ_TH_DOMAIN ),
				'type' => \Elementor\Controls_Manager::NUMBER,
				'placeholder' => '0',
				'min' => -100,
				'max' => 100,
				'step' => 1,
			]
		);
		$repeater->add_control(
			'margin_left',
			[
				'label' => esc_html__( 'Left', DZ_TH_DOMAIN ),
				'type' => \Elementor\Controls_Manager::NUMBER,
				'placeholder' => '0',
				'min' => -100,
				'max' => 100,
				'step' => 1,
			]
		);
		$repeater->add_control(
			'margin_right',
			[
				'label' => esc_html__( 'Right', DZ_TH_DOMAIN ),
				'type' => \Elementor\Controls_Manager::NUMBER,
				'placeholder' => '0',
				'min' => -100,
				'max' => 100,
				'step' => 1,
			]
		);
		$repeater->add_control(
			'margin_bottom',
			[
				'label' => esc_html__( 'Bottom', DZ_TH_DOMAIN ),
				'type' => \Elementor\Controls_Manager::NUMBER,
				'placeholder' => '0',
				'min' => -100,
				'max' => 100,
				'step' => 1,
			]
		);
		
		
		$this->add_control(
			'home_banner_5_element_item',
			[
				'label' 		=> esc_html__( 'Item List', DZ_TH_DOMAIN ),
				'type' 			=> \Elementor\Controls_Manager::REPEATER,
				'fields' 		=> $repeater->get_controls(),
				'default' 		=> [
					
				],
			]
		);
        
        $this->end_controls_section();


        $this->start_controls_section(
			'search',
			[
				'label' => esc_html__( 'Search Fields', DZ_TH_DOMAIN ),
			]
		);
		$this->add_control(
			'home_banner_5_element_search_job_type',
			[
				'label' 		=> esc_html__( 'Search Job Category', DZ_TH_DOMAIN ),
				'show_label'	=> true,
				'label_block' 	=> true,
				'type' 		 	=> Controls_Manager::SWITCHER,
				'default' 		=>'yes',
				'return_value' 	=> 'yes',
				'description'	=> esc_html__( 'Enable to show Search Job Category.', DZ_TH_DOMAIN ),
			]
		);

		$this->add_control(
			'home_banner_5_element_search_job_location',
			[
				'label' 		=> esc_html__( 'Search Job Location', DZ_TH_DOMAIN ),
				'show_label'	=> true,
				'label_block' 	=> true,
				'type' 		 	=> Controls_Manager::SWITCHER,
				'default' 		=>'yes',
				'return_value' 	=> 'yes',
				'description'	=> esc_html__( 'Enable to show Search Job Location.', DZ_TH_DOMAIN ),
			]
		);

	
		$this->end_controls_section();
	}
	
	protected function render() 
	{
		
        $settings = $this->get_settings_for_display();
		
		DZTemplate::show_dz_template('dz-inc/elementor/elements/home_banner_5_element.php',$settings);
			echo "<script>
				jQuery(document).ready(function(){
					if(jQuery('.elementor-element-edit-mode').length > 0){
						jQuery('select').selectpicker();
					}					
				});
			 </script>
			";
	}
	
	
	protected function content_template() 
	{

    }
}