<?php

namespace DZElementor\Widgets;

use Elementor\Widget_Base;

use Elementor\Controls_Manager;

class DZHomeBanner6 extends Widget_Base 
{
	public function get_name() {
		return 'dz-home-banner-6';
	}
	
	public function get_title() {
		return esc_html__('Home Banner 6',DZ_TH_DOMAIN);
	}
	
	public function get_icon() {
		return 'eicon-banner';
	}
	
	public function get_categories() {
		return [ 'jobzilla' ];
	}
	
	protected function register_controls() {
		
		$this->start_controls_section(
			'general',
			[
				'label' => esc_html__( 'General', DZ_TH_DOMAIN ),
			]
		);

		$this->add_control(
			'home_banner_6_element_title', [
				'label' 		=> esc_html__( 'Title', DZ_TH_DOMAIN ),
				'type' 			=> \Elementor\Controls_Manager::TEXT,
				'default' 		=> esc_html__( 'It’s Easy to Find Your', DZ_TH_DOMAIN ). '<span class="site-text-primary">Dream Job</span> '. esc_html__('that fits your life', DZ_TH_DOMAIN ),
				'label_block' 	=> true,
			]
		);
		$this->add_control(
			'home_banner_6_element_description',
			[
				'label' 		=> esc_html__( 'Enter Description.', DZ_TH_DOMAIN ),
				'show_label'	=> true,
				'label_block' 	=> true,
				'type' 		 	=> Controls_Manager::TEXTAREA,
				'placeholder'	=> esc_html__( 'Enter Description', DZ_TH_DOMAIN ),
				'default'		=> esc_html__( 'You dream job is waiting for you.', DZ_TH_DOMAIN ),
				'separator'		=>  'default',
				'rows'			=>  5,
				'description'	=> esc_html__( 'Enter Description Here', DZ_TH_DOMAIN ),
			]
		);
		$this->add_control(
			'home_banner_6_element_candidate_title',
			[
				'label' 		=> esc_html__( 'Candidate Text', DZ_TH_DOMAIN ),
				'label_block' 	=> true,
				'type' 			=> Controls_Manager::TEXT,
				'placeholder' 	=> esc_html__( 'Enter your candidate text', DZ_TH_DOMAIN ),
				'default'		=>  esc_html__( 'Our More Candidates', DZ_TH_DOMAIN ),
			]
		);
		$this->add_control(
			'home_banner_6_element_gallery',
			[
				'label' 		=> esc_html__( 'Upload Multiple Images', DZ_TH_DOMAIN ),
				'type' 			=> \Elementor\Controls_Manager::GALLERY,
			]
		);
        $this->add_control(
			'home_banner_6_element_bg_image',
			[
				'label' 		=> esc_html__( 'Background Images', DZ_TH_DOMAIN ),
				'type' 			=> \Elementor\Controls_Manager::MEDIA,
			]
		);
         $this->add_control(
			'home_banner_6_element_image',
			[
				'label' 		=> esc_html__( 'Images', DZ_TH_DOMAIN ),
				'type' 			=> \Elementor\Controls_Manager::MEDIA,
			]
		);
		$this->add_control(
			'home_banner_6_element_counter_number',
			[
				'label' 		=> esc_html__( 'Counter Number', DZ_TH_DOMAIN ),
				'label_block' 	=> true,
				'type' 			=> Controls_Manager::TEXT,
				'placeholder' 	=> esc_html__( 'Enter your counter number', DZ_TH_DOMAIN ),
				'default'		=>  '<span class="counter">3</span>'.esc_html__( 'K+', DZ_TH_DOMAIN ),
			]
		);
       

		$this->add_control(
			'home_banner_6_element_search_btn',
			[
				'label' 		=> esc_html__( 'Search Button Text', DZ_TH_DOMAIN ),
				'label_block' 	=> true,
				'type' 			=> Controls_Manager::TEXT,
				'placeholder' 	=> esc_html__( 'Enter your Search Button Text', DZ_TH_DOMAIN ),
				'default'		=>  esc_html__( 'Find Jobs', DZ_TH_DOMAIN ),
			]
		);

		$this->end_controls_section();

        $this->start_controls_section(
			'search',
			[
				'label' => esc_html__( 'Search Fields', DZ_TH_DOMAIN ),
			]
		);
		$this->add_control(
			'home_banner_6_element_item_title',
			[
				'label' 		=> esc_html__( 'Title', DZ_TH_DOMAIN ),
				'label_block' 	=> true,
				'type' 			=> Controls_Manager::TEXT,
				'placeholder' 	=> esc_html__( 'Enter your title', DZ_TH_DOMAIN ),
				'default'		=>  esc_html__( 'Find Jobs', DZ_TH_DOMAIN ),
			]
		);
       $this->add_control(
			'home_banner_6_element_item_subtitle',
			[
				'label' 		=> esc_html__( 'SubTitle', DZ_TH_DOMAIN ),
				'label_block' 	=> true,
				'type' 			=> Controls_Manager::TEXT,
				'placeholder' 	=> esc_html__( 'Enter your subtitle', DZ_TH_DOMAIN ),
				'default'		=>  esc_html__( 'Your Latest Jobs', DZ_TH_DOMAIN ),
			]
		);
		$this->add_control(
			'home_banner_6_element_search_job_category',
			[
				'label' 		=> esc_html__( 'Search Job Category', DZ_TH_DOMAIN ),
				'show_label'	=> true,
				'label_block' 	=> true,
				'type' 		 	=> Controls_Manager::SWITCHER,
				'default' 		=>'yes',
				'return_value' 	=> 'yes',
				'description'	=> esc_html__( 'Enable to show Search Job Category.', DZ_TH_DOMAIN ),
			]
		);

		$this->add_control(
			'home_banner_6_element_search_job_location',
			[
				'label' 		=> esc_html__( 'Search Job Location', DZ_TH_DOMAIN ),
				'show_label'	=> true,
				'label_block' 	=> true,
				'type' 		 	=> Controls_Manager::SWITCHER,
				'default' 		=>'yes',
				'return_value' 	=> 'yes',
				'description'	=> esc_html__( 'Enable to show Search Job Location.', DZ_TH_DOMAIN ),
			]
		);

		$this->end_controls_section();
	}
	
	protected function render() 
	{
		
        $settings = $this->get_settings_for_display();
		
		DZTemplate::show_dz_template('dz-inc/elementor/elements/home_banner_6_element.php',$settings);
		
		echo "<script>
				jQuery(document).ready(function(){
					if(jQuery('.elementor-element-edit-mode').length > 0){
						jQuery('select').selectpicker();
					}					
				});
			 </script>
			";
	}
	
	
	protected function content_template() 
	{

    }
}