<?php

namespace DZElementor\Widgets;

use Elementor\Widget_Base;

use Elementor\Controls_Manager;

class DZHomeBanner7 extends Widget_Base 
{
	public function get_name() {
		return 'dz-home-banner-7';
	}
	
	public function get_title() {
		return esc_html__('Home Banner 7',DZ_TH_DOMAIN);
	}
	
	public function get_icon() {
		return 'eicon-banner';
	}
	
	public function get_categories() {
		return [ 'jobzilla' ];
	}
	
	protected function register_controls() {
		
		$this->start_controls_section(
			'general',
			[
				'label' => esc_html__( 'General', DZ_TH_DOMAIN ),
			]
		);

		$this->add_control(
			'home_banner_7_element_title', [
				'label' 		=> esc_html__( 'Title', DZ_TH_DOMAIN ),
				'type' 			=> \Elementor\Controls_Manager::TEXT,
				'default' 		=> esc_html__( 'For talent Developers', DZ_TH_DOMAIN ),
				'label_block' 	=> true,
			]
		);
		$this->add_control(
			'home_banner_7_element_subtitle',
			[
				'label' 		=> esc_html__( 'Subtitle', DZ_TH_DOMAIN ),
				'label_block' 	=> true,
				'type' 			=> Controls_Manager::TEXT,
				'placeholder' 	=> esc_html__( 'Enter your Subtitle', DZ_TH_DOMAIN ),
				'default'		=>  esc_html__( 'Find Top IT ', DZ_TH_DOMAIN ). '<span class="text-clr-pink">Jobs</span> ',
			]
		);
		$this->add_control(
			'home_banner_7_element_description',
			[
				'label' 		=> esc_html__( 'Enter Description.', DZ_TH_DOMAIN ),
				'show_label'	=> true,
				'label_block' 	=> true,
				'type' 		 	=> Controls_Manager::TEXTAREA,
				'placeholder'	=> esc_html__( 'Enter Description', DZ_TH_DOMAIN ),
				'default'		=> esc_html__( 'YType your keyword, then click search to find your perfect job.', DZ_TH_DOMAIN ),
				'separator'		=>  'default',
				'rows'			=>  5,
				'description'	=> esc_html__( 'Enter Description Here', DZ_TH_DOMAIN ),
			]
		);
		
		
        $this->add_control(
			'home_banner_7_element_bg_image',
			[
				'label' 		=> esc_html__( 'Background Images', DZ_TH_DOMAIN ),
				'type' 			=> \Elementor\Controls_Manager::MEDIA,
			]
		);

		

		$this->add_control(
			'home_banner_7_element_item_title',
			[
				'label' 		=> esc_html__( 'Title', DZ_TH_DOMAIN ),
				'label_block' 	=> true,
				'type' 			=> Controls_Manager::TEXT,
				'placeholder' 	=> esc_html__( 'Enter your title', DZ_TH_DOMAIN ),
				'default'		=>  esc_html__( 'jobs at a glance', DZ_TH_DOMAIN ),
			]
		);

     	$this->add_control(
			'home_banner_7_element_placeholder_text',
			[
				'label' 		=> esc_html__( 'Placeholder Text', DZ_TH_DOMAIN ),
				'label_block' 	=> true,
				'type' 			=> Controls_Manager::TEXT,
				'placeholder' 	=> esc_html__( 'Enter your Placeholder Text', DZ_TH_DOMAIN ),
				'default'		=>  esc_html__( 'you deserve!', DZ_TH_DOMAIN ),
			]
		);


		$this->end_controls_section();

        $this->start_controls_section(
			'search',
			[
				'label' => esc_html__( 'Search Fields', DZ_TH_DOMAIN ),
			]
		);


	
		$this->add_control(
			'home_banner_7_element_search_btn',
			[
				'label' 		=> esc_html__( 'Search Button Text', DZ_TH_DOMAIN ),
				'label_block' 	=> true,
				'type' 			=> Controls_Manager::TEXT,
				'placeholder' 	=> esc_html__( 'Enter your Search Button Text', DZ_TH_DOMAIN ),
				'default'		=>  esc_html__( 'Find Jobs', DZ_TH_DOMAIN ),
			]
		);
		 $this->add_control(
			'home_banner_7_element_search_job_title',
			[
				'label' 		=> esc_html__( 'Search Job Title', DZ_TH_DOMAIN ),
				'show_label'	=> true,
				'label_block' 	=> true,
				'type' 		 	=> Controls_Manager::SWITCHER,
				'default' 		=>'yes',
				'return_value' 	=> 'yes',
				'description'	=> esc_html__( 'Enable to show Search Job Title.', DZ_TH_DOMAIN ),
			]
		);

		$this->add_control(
			'home_banner_7_element_search_job_category',
			[
				'label' 		=> esc_html__( 'Search Job Category', DZ_TH_DOMAIN ),
				'show_label'	=> true,
				'label_block' 	=> true,
				'type' 		 	=> Controls_Manager::SWITCHER,
				'default' 		=>'yes',
				'return_value' 	=> 'yes',
				'description'	=> esc_html__( 'Enable to show Search Job Category.', DZ_TH_DOMAIN ),
			]
		);

		$this->add_control(
			'home_banner_7_element_search_job_location',
			[
				'label' 		=> esc_html__( 'Search Job Location', DZ_TH_DOMAIN ),
				'show_label'	=> true,
				'label_block' 	=> true,
				'type' 		 	=> Controls_Manager::SWITCHER,
				'default' 		=>'yes',
				'return_value' 	=> 'yes',
				'description'	=> esc_html__( 'Enable to show Search Job Location.', DZ_TH_DOMAIN ),
			]
		);

		$this->end_controls_section();


		$this->start_controls_section(
			'advance',
			[
				'label' => esc_html__( 'Advance', DZ_TH_DOMAIN ),
			]
		);
		$this->add_control(
			'home_banner_7_element_posts_in_categories',
			[
				'label' 		=> esc_html__( 'Include These Categories', DZ_TH_DOMAIN ),
				'show_label'	=> true,
				'label_block' 	=> true,
				'multiple' 		=> true,
				'type' 		 	=> Controls_Manager::SELECT2,
				'options'		=> dz_get_categories(array( 'taxonomy' => 'job_listing_category'),true),				
				'description'	=> esc_html__( 'Select multiple/ single categories', DZ_TH_DOMAIN ),
			]
		);

		$this->add_control(
			'home_banner_7_element_hide_empty',
			[
				'label' 		=> esc_html__( 'Hide no job cities', DZ_TH_DOMAIN ),
				'show_label'	=> true,
				'label_block' 	=> true,
				'type' 		 	=> Controls_Manager::SWITCHER,
				'return_value' 	=> 'yes',
				'description'	=> esc_html__( 'Enable to Hide no job cities.', DZ_TH_DOMAIN ),
			]
		);
		

		$this->add_control(
			'home_banner_7_element_no_of_posts',
			[
				'label' 		=> esc_html__( 'No. Of Posts Per Page', DZ_TH_DOMAIN ),
				'show_label'	=> true,
				'label_block' 	=> true,
				'type' 		 	=> Controls_Manager::NUMBER,
				'default'		=> 8,
				'title'			=>  esc_html__( 'No. Of Posts Per Page', DZ_TH_DOMAIN ),
				'description'	=> esc_html__( 'Enter no. of posts to show per page.', DZ_TH_DOMAIN ),
			]
		);
		$this->add_control(
			'home_banner_7_element_order',
			[
				'label' 	 => esc_html__( 'Order', DZ_TH_DOMAIN ),
				'show_label' => true,
				'label_block'=> true,
				'type' 		 => Controls_Manager::SELECT,
				'options'	 => dz_get_order_options_list(),				
				'default'	 =>  'ASC',
			]
		);		
		$this->end_controls_section();	
	}
	
	protected function render() 
	{
		
        $settings = $this->get_settings_for_display();
		
		DZTemplate::show_dz_template('dz-inc/elementor/elements/home_banner_7_element.php',$settings);
		
		echo "<script>
				jQuery(document).ready(function(){
					if(jQuery('.elementor-element-edit-mode').length > 0){
						jQuery('select').selectpicker();
						handlePage7JobsSlider();
					}					
				});
			 </script>
			";
	}
	
	
	protected function content_template() 
	{

    }
}