<?php

namespace DZElementor\Widgets;

use Elementor\Widget_Base;

use Elementor\Controls_Manager;

class DZHomeBanner9 extends Widget_Base 
{
	public function get_name() {
		return 'dz-home-banner-9';
	}
	
	public function get_title() {
		return esc_html__('Home Banner 9',DZ_TH_DOMAIN);
	}
	
	public function get_icon() {
		return 'eicon-banner';
	}
	
	public function get_categories() {
		return [ 'jobzilla' ];
	}
	
	protected function register_controls() {
		
		$this->start_controls_section(
			'general',
			[
				'label' => esc_html__( 'General', DZ_TH_DOMAIN ),
			]
		);

		$this->add_control(
			'home_banner_9_element_title', [
				'label' 		=> esc_html__( 'Title', DZ_TH_DOMAIN ),
				'type' 			=> \Elementor\Controls_Manager::TEXT,
				'default' 		=> esc_html__( 'Now It’s Easy.', DZ_TH_DOMAIN ),
				'label_block' 	=> true,
			]
		);
		$this->add_control(
			'home_banner_9_element_titlesub', [
				'label' 		=> esc_html__( 'TitleSub', DZ_TH_DOMAIN ),
				'type' 			=> \Elementor\Controls_Manager::TEXT,
				'default' 		=> '<span>Find Your</span><span class="typewrite site-text-primary" data-period="2000" data-type="[ "Dream Job" , "Next Job"]"></span>',
				'label_block' 	=> true,
			]
		);
		
		$this->add_control(
			'home_banner_9_element_search_btn',
			[
				'label' 		=> esc_html__( 'Search Button Text', DZ_TH_DOMAIN ),
				'label_block' 	=> true,
				'type' 			=> Controls_Manager::TEXT,
				'placeholder' 	=> esc_html__( 'Enter your Search Button Text', DZ_TH_DOMAIN ),
				'default'		=>  esc_html__( 'Find Jobs', DZ_TH_DOMAIN ),
			]
		);
       $this->add_control(
			'home_banner_9_element_bg_img', [
				'label' 		=> esc_html__( 'Background Image', DZ_TH_DOMAIN ),
				'type' 			=> \Elementor\Controls_Manager::MEDIA,
			]
		);
		$this->add_control(
			'home_banner_9_element_img', [
				'label' 		=> esc_html__( 'Image', DZ_TH_DOMAIN ),
				'type' 			=> \Elementor\Controls_Manager::MEDIA,
			]
		);
		
		$this->end_controls_section();


        $this->start_controls_section(
			'search',
			[
				'label' => esc_html__( 'Search Fields', DZ_TH_DOMAIN ),
			]
		);

        $this->add_control(
			'home_banner_9_element_search_job_title',
			[
				'label' 		=> esc_html__( 'Search Job Title', DZ_TH_DOMAIN ),
				'show_label'	=> true,
				'label_block' 	=> true,
				'type' 		 	=> Controls_Manager::SWITCHER,
				'default' 		=>'yes',
				'return_value' 	=> 'yes',
				'description'	=> esc_html__( 'Enable to show Search Job Title.', DZ_TH_DOMAIN ),
			]
		);

		$this->add_control(
			'home_banner_9_element_job_tags_title', [
				'label' 		=> esc_html__( 'Tags Title', DZ_TH_DOMAIN ),
				'type' 			=> \Elementor\Controls_Manager::TEXT,
				'default' 		=> esc_html__( 'Popular Searches:', DZ_TH_DOMAIN ),
				'label_block' 	=> true,
			]
		);

		$this->add_control(
			'home_banner_9_element_job_tags',
			[
				'label' 		=> esc_html__( 'Job Tags', DZ_TH_DOMAIN ),
				'show_label'	=> true,
				'label_block' 	=> true,
				'type' 		 	=> Controls_Manager::SWITCHER,
				'default' 		=>'yes',
				'return_value' 	=> 'yes',
				'description'	=> esc_html__( 'Enable to show Job Tags.', DZ_TH_DOMAIN ),
			]
		);

		$this->end_controls_section();
	}
	
	protected function render() 
	{
		
        $settings = $this->get_settings_for_display();
		
		DZTemplate::show_dz_template('dz-inc/elementor/elements/home_banner_9_element.php',$settings);
		echo "<script>
				jQuery(document).ready(function(){
					if(jQuery('.elementor-element-edit-mode').length > 0){
						jQuery('select').selectpicker();
					}					
				});
			 </script>
			";
	}
	
	
	protected function content_template() 
	{

    }
}