<?php 
namespace DZElementor\Widgets;

use Elementor\Widget_Base;

use Elementor\Controls_Manager;

class DZImageSlider extends Widget_Base 
{
	public function get_name() {
		return 'dz-image-slider';
	}
	
	public function get_title() {
		return esc_html__('Image Slider',DZ_TH_DOMAIN);
	}
	
	public function get_icon() {
		return 'eicon-slideshow';
	}
	
	public function get_categories() {
		return [ 'jobzilla' ];
	}
	
	protected function register_controls() {
		
		$this->start_controls_section(
			'general',
			[
				'label' => esc_html__( 'General', DZ_TH_DOMAIN ),
			]
		);	
		
		$this->add_control(
			'image_slider_element_title',
			[
				'label' 		=> esc_html__( 'Title', DZ_TH_DOMAIN ),
				'label_block' 	=> true,
				'type' 			=> Controls_Manager::TEXT,
				'placeholder'	=> esc_html__( 'Enter your title', DZ_TH_DOMAIN ),
				'default' 		=> esc_html__( 'Get hired in top companies', DZ_TH_DOMAIN ),
			]
		);

		$this->add_control(
			'image_slider_element_subtitle',
			[
				'label' 		=> esc_html__( 'Subtitle', DZ_TH_DOMAIN ),
				'label_block' 	=> true,
				'type' 			=> Controls_Manager::TEXT,
				'placeholder'	=> esc_html__( 'Enter your title', DZ_TH_DOMAIN ),
				'default' 		=> esc_html__( 'Top Companies', DZ_TH_DOMAIN ),
			]
		);

		$this->add_control(
			'image_slider_element_style',
			[
				'label' 	 => esc_html__( 'Style', DZ_TH_DOMAIN ),
				'show_label' => true,
				'label_block'=> true,
				'type' 		 => Controls_Manager::SELECT,
				'options'	 => array(
                                'style_1'=>esc_html__('Style 1', DZ_TH_DOMAIN),
                                'style_2'=>esc_html__('Style 2', DZ_TH_DOMAIN),
                            ),
				'default'	 =>  'style_1',
			]
		);

		$this->add_control(
			'image_slider_element_disable_link',
			[
				'label' 		=> esc_html__( 'Disable Hyperlink', DZ_TH_DOMAIN ),
				'show_label'	=> true,
				'label_block' 	=> true,
				'type' 		 	=> Controls_Manager::SWITCHER,
				'return_value' 	=> 'yes',
				'description'	=> esc_html__( 'Enable to Disable Hyperlink.', DZ_TH_DOMAIN ),
			]
		);
		
		$this->end_controls_section();

		$this->start_controls_section(
			'slider',
			[
				'label' => esc_html__( 'Slider', DZ_TH_DOMAIN ),
			]
		);
		
		$repeater = new \Elementor\Repeater();
		
		$repeater->add_control(
			'image_slider_element_slider_item_link',
			[
				'label' 		=> esc_html__( 'Image Link', DZ_TH_DOMAIN ),
				'label_block' 	=> true,
				'type' 			=> Controls_Manager::URL,
				'placeholder'	=> esc_html__( 'Enter your Image Link', DZ_TH_DOMAIN ),
			]
		);
		
		$repeater->add_control(
			'image_slider_element_slider_item_image',
			[
				'label' 		=> esc_html__( 'Upload Image', DZ_TH_DOMAIN ),
				'type' 			=> \Elementor\Controls_Manager::MEDIA,
			]
		);
		
		$this->add_control(
			'image_slider_element_slider',
			[
				'label' 		=> esc_html__( 'Item List', DZ_TH_DOMAIN ),
				'type' 			=> \Elementor\Controls_Manager::REPEATER,
				'fields' 		=> $repeater->get_controls(),
				'default' 		=> [
					[
						'image_slider_element_slider_item_link' 	=> 'https://www.google.com',
					],
					[
						'image_slider_element_slider_item_link' 	=> 'https://www.google.com',	
					],
					[
						'image_slider_element_slider_item_link' 	=> 'https://www.google.com',	
					],
					[
						'image_slider_element_slider_item_link' 	=> 'https://www.google.com',	
					],
					[
						'image_slider_element_slider_item_link' 	=> 'https://www.google.com',	
					],
					[
						'image_slider_element_slider_item_link' 	=> 'https://www.google.com',	
					],					
				],
				
			]
		);
        
        $this->end_controls_section();

		$this->start_controls_section(
			'counter',
			[
				'label' => esc_html__( 'Counter', DZ_TH_DOMAIN ),
			]
		);
		
		$repeater = new \Elementor\Repeater();
		
		$repeater->add_control(
			'image_slider_counter_element_item_title',
			[
				'label' 		=> esc_html__( 'Title', DZ_TH_DOMAIN ),
				'label_block' 	=> true,
				'type' 			=> Controls_Manager::TEXT,
				'placeholder' 	=> esc_html__( 'Enter your title', DZ_TH_DOMAIN ),
				'default'		=>  esc_html__( 'Million daily active users', DZ_TH_DOMAIN ),
			]
		);
		
		$repeater->add_control(
			'image_slider_counter_element_item_number',
			[
				'label' 		=> esc_html__( 'Number', DZ_TH_DOMAIN ),
				'show_label'	=> true,
				'label_block' 	=> true,
				'type' 		 	=> Controls_Manager::NUMBER,
				'default'		=> 5,
				'title'			=>  esc_html__( 'Number', DZ_TH_DOMAIN ),
				'description'	=> esc_html__( 'Enter Number', DZ_TH_DOMAIN ),
			]
		);
		
		$repeater->add_control(
			'image_slider_counter_element_item_prefix', [
				'label' 		=> esc_html__( 'Symbol', DZ_TH_DOMAIN ),
				'type' 			=> \Elementor\Controls_Manager::TEXT,
				'default' 		=> 'M+',
				'label_block' 	=> true,
			]
		);		
		
		$this->add_control(
			'image_slider_counter_element_item',
			[
				'label' 		=> esc_html__( 'Item List', DZ_TH_DOMAIN ),
				'type' 			=> \Elementor\Controls_Manager::REPEATER,
				'fields' 		=> $repeater->get_controls(),
				'default' 		=> [
					[
						'image_slider_counter_element_item_title' 	=> esc_html__( 'Million daily active users', DZ_TH_DOMAIN ),
						'image_slider_counter_element_item_number' 	=> 5,
						'image_slider_counter_element_item_prefix' 	=> 'M+',	
					],
					[
						'image_slider_counter_element_item_title' 	=> esc_html__( 'Open job positions', DZ_TH_DOMAIN ),
						'image_slider_counter_element_item_number' 	=> 9,
						'image_slider_counter_element_item_prefix' 	=> 'K+',	
					],
					[
						'image_slider_counter_element_item_title' 	=> esc_html__( 'Million stories shared', DZ_TH_DOMAIN ),
						'image_slider_counter_element_item_number' 	=> 2,
						'image_slider_counter_element_item_prefix' 	=> 'M+',	
					],
					
				],
				'title_field' => '{{{ image_slider_counter_element_item_number }}}'
			]
		);
        
        $this->end_controls_section();
	
	}
	
	protected function render() 
	{

        $settings = $this->get_settings_for_display();
		$style =  $settings['image_slider_element_style'];
		DZTemplate::show_dz_template('dz-inc/elementor/elements/image_slider_element.php',$settings);
		
		echo "<script>
				jQuery(document).ready(function(){
					if(jQuery('.elementor-element-edit-mode').length > 0){
			";
			
			if($style == 'style_1'){
			echo 'handleHomeClientCarousel2();';
			}else if($style == 'style_2'){				
				echo 'handleHomeClientCarousel3();';
			}
						
				echo "}					
				});
			 </script>
			";
	}
	
	protected function content_template() 
	{

    }
}
?>