<?php 
namespace DZElementor\Widgets;

use Elementor\Widget_Base;

use Elementor\Controls_Manager;

class DZJobCategorySlider extends Widget_Base 
{
	public function get_name() {
		return 'dz-job-category-slider';
	}
	
	public function get_title() {
		return esc_html__('Job Category Slider',DZ_TH_DOMAIN);
	}
	
	public function get_icon() {
		return ' eicon-slider-full-screen';
	}
	
	public function get_categories() {
		return [ 'jobzilla' ];
	}
	
	protected function register_controls() {
		
		$this->start_controls_section(
			'general',
			[
				'label' => esc_html__( 'General', DZ_TH_DOMAIN ),
			]
		);
		
		$this->add_control(
			'job_category_slider_element_title',
			[
				'label' 		=> esc_html__( 'Title', DZ_TH_DOMAIN ),
				'label_block' 	=> true,
				'type' 			=> Controls_Manager::TEXT,
				'placeholder'	=> esc_html__( 'Enter your title', DZ_TH_DOMAIN ),
				'default' 		=> esc_html__( 'Choose Your Desire Category', DZ_TH_DOMAIN ),
			]
		);
		
		$this->add_control(
			'job_category_slider_element_subtitle',
			[
				'label' 		=> esc_html__( 'Subtitle', DZ_TH_DOMAIN ),
				'label_block' 	=> true,
				'type' 			=> Controls_Manager::TEXT,
				'placeholder'	=> esc_html__( 'Enter your Subtitle', DZ_TH_DOMAIN ),
				'default' 		=> esc_html__( 'Jobs by Categories', DZ_TH_DOMAIN ),
			]
		);
		
		
		
		$this->add_control(
			'job_category_slider_element_description',
			[
				'label' 		=> esc_html__( 'Enter Description.', DZ_TH_DOMAIN ),
				'show_label'	=> true,
				'label_block' 	=> true,
				'type' 		 	=> Controls_Manager::TEXTAREA,
				'placeholder'	=> esc_html__( 'Enter Description. Here', DZ_TH_DOMAIN ),
				'default'		=> esc_html__( 'Search all the open positions on the web. Get your own personalized salary estimate. Read reviews on over 600,000 companies worldwide.', DZ_TH_DOMAIN ),
				'separator'		=>  'default',
				'rows'			=>  5,
				'description'	=> esc_html__( 'Enter Description Here', DZ_TH_DOMAIN ),
			]
		);
		$this->add_control(
			'job_category_slider_element_image',
			[
				'label' 		=> esc_html__( 'Image', DZ_TH_DOMAIN ),
				'type' 			=> Controls_Manager::MEDIA,	
				'condition' => [
						'job_category_slider_element_style' => ['style_2'],
				],
			]
		);
		$this->add_control(
			'job_category_slider_element_posts_in_categories',
			[
				'label' 		=> esc_html__( 'Include These Categories', DZ_TH_DOMAIN ),
				'show_label'	=> true,
				'label_block' 	=> true,
				'multiple' 		=> true,
				'type' 		 	=> Controls_Manager::SELECT2,
				'options'		=> dz_get_categories(array( 'taxonomy' => 'job_listing_category'),true),				
				'description'	=> esc_html__( 'Select multiple/ single categories', DZ_TH_DOMAIN ),
			]
		);
		
		$this->add_control(
			'job_category_slider_element_style',
			[
				'label' 	 => esc_html__( 'Style', DZ_TH_DOMAIN ),
				'show_label' => true,
				'label_block'=> true,
				'type' 		 => Controls_Manager::SELECT,
				'options'	 => array(
                                'style_1'=>esc_html__('Style 1', DZ_TH_DOMAIN),
                                'style_2'=>esc_html__('Style 2', DZ_TH_DOMAIN),
                                'style_3'=>esc_html__('Style 3', DZ_TH_DOMAIN),
                            ),
				'default'	 =>  'style_1',
			]
		);

		$this->add_control(
			'job_category_slider_element_hide_empty',
			[
				'label' 		=> esc_html__( 'Hide no job cities', DZ_TH_DOMAIN ),
				'show_label'	=> true,
				'label_block' 	=> true,
				'type' 		 	=> Controls_Manager::SWITCHER,
				'return_value' 	=> 'yes',
				'description'	=> esc_html__( 'Enable to Hide no job cities.', DZ_TH_DOMAIN ),
			]
		);
		
		$this->add_control(
			'job_category_slider_element_link_title',
				[
					'label'  	   => esc_html__('Button Text'),
					'label_block'  => true,
					'type'         => \Elementor\Controls_Manager::TEXT,
					'placeholder'  => esc_html__( 'Enter your Button Text', DZ_TH_DOMAIN ),
					'default'      => esc_html__('All Categories', DZ_TH_DOMAIN),
					'condition' => [
						'job_category_slider_element_style' => ['style_3','style_1'],
					],
				]
		);
		
		$this->add_control(
			'job_category_slider_element_link',
				[
					'label'  	   => esc_html__('Button Url'),
					'label_block'  => true,
					'type'         => \Elementor\Controls_Manager::URL,
					'placeholder'  => esc_html__( 'Enter your Button Url', DZ_TH_DOMAIN ),
					'condition' => [
						'job_category_slider_element_style' => ['style_3','style_1'],
					],
				]
		
		);
		
		$this->end_controls_section();

		$this->start_controls_section(
			'advance',
			[
				'label' => esc_html__( 'Advance', DZ_TH_DOMAIN ),
			]
		);
		$this->add_control(
			'job_category_slider_element_no_of_posts',
			[
				'label' 		=> esc_html__( 'No. Of Posts Per Page', DZ_TH_DOMAIN ),
				'show_label'	=> true,
				'label_block' 	=> true,
				'type' 		 	=> Controls_Manager::NUMBER,
				'default'		=> 8,
				'title'			=>  esc_html__( 'No. Of Posts Per Page', DZ_TH_DOMAIN ),
				'description'	=> esc_html__( 'Enter no. of posts to show per page.', DZ_TH_DOMAIN ),
			]
		);
		$this->add_control(
			'job_category_slider_element_order',
			[
				'label' 	 => esc_html__( 'Order', DZ_TH_DOMAIN ),
				'show_label' => true,
				'label_block'=> true,
				'type' 		 => Controls_Manager::SELECT,
				'options'	 => dz_get_order_options_list(),				
				'default'	 =>  'ASC',
			]
		);		
		$this->end_controls_section();	
	
	}
	
	protected function render() 
	{

        $settings = $this->get_settings_for_display();
		
		DZTemplate::show_dz_template('dz-inc/elementor/elements/job_category_slider_element.php',$settings);
		
		echo "<script>
				jQuery(document).ready(function(){
					if(jQuery('.elementor-element-edit-mode').length > 0){ ";
						if($settings['job_category_slider_element_style'] == 'style_2'){
							echo 'handleCategory5Slider()';
						}else if($settings['job_category_slider_element_style'] == 'style_3'){
							echo 'handleJobCategoriesCarouselHpage8()';
						}else{
							echo 'handleJobCategoriesCarousel()';
						}
				echo " }					
				});
			 </script>";
		
	}
	
	protected function content_template() 
	{

    }
}
?>