<?php

namespace DZElementor\Widgets;

use Elementor\Widget_Base;

use Elementor\Controls_Manager;

class DZJobListing2 extends Widget_Base 
{
	public function get_name() {
		return 'dz-job-listing-2';
	}
	
	public function get_title() {
		return esc_html__('Job Listing 2',DZ_TH_DOMAIN);
	}
	
	public function get_icon() {
		return 'eicon-bullet-list';
		}
	
	public function get_categories() {
		return [ 'jobzilla' ];
	}
	
	protected function register_controls() {
		
		$this->start_controls_section(
			'general',
			[
				'label' => esc_html__( 'General', DZ_TH_DOMAIN ),
			]
		);
		
		$this->add_control(
			'job_listing_2_element_title',
			[
				'label' 		=> esc_html__( 'Title', DZ_TH_DOMAIN ),
				'label_block' 	=> true,
				'type' 			=> Controls_Manager::TEXT,
				'placeholder' 	=> esc_html__( 'Enter your title', DZ_TH_DOMAIN ),
				'default'		=>  esc_html__( 'Featured Jobs', DZ_TH_DOMAIN ),
			]
		);
		
		$this->add_control(
			'job_listing_2_element_subtitle',
			[
				'label' 		=> esc_html__( 'Subtitle', DZ_TH_DOMAIN ),
				'label_block' 	=> true,
				'type' 			=> Controls_Manager::TEXT,
				'placeholder' 	=> esc_html__( 'Enter your subtitle', DZ_TH_DOMAIN ),
				'default'		=>  esc_html__( 'Jobs Category', DZ_TH_DOMAIN ),
			]
		);
		
		
		$this->add_control(
			'job_listing_2_element_posts_in_categories',
			[
				'label' 		=> esc_html__( 'Include These Categories', DZ_TH_DOMAIN ),
				'show_label'	=> true,
				'label_block' 	=> true,
				'multiple' 		=> true,
				'type' 		 	=> Controls_Manager::SELECT2,
				'options'		=> dz_get_categories(array( 'taxonomy' => 'job_listing_category'),true),	
				'description'	=> esc_html__( 'Select multiple/ single categories', DZ_TH_DOMAIN ),
			]
		);

		$this->add_control(
			'job_listing_2_element_style',
			[
				'label' 	 => esc_html__( 'Style', DZ_TH_DOMAIN ),
				'show_label' => true,
				'label_block'=> true,
				'type' 		 => Controls_Manager::SELECT,
				'options'	 => array(
                                'style_1'=>esc_html__('Style 1', DZ_TH_DOMAIN),
                                'style_2'=>esc_html__('Style 2', DZ_TH_DOMAIN),
                            ),
				'default'	 =>  'style_1',
			]
		);

		$this->add_control(
			'job_listing_2_element_link_title',
				[
					'label'  	   => esc_html__('Button Text'),
					'label_block'  => true,
					'type'         => \Elementor\Controls_Manager::TEXT,
					'placeholder'  => esc_html__( 'Enter your Button Text', DZ_TH_DOMAIN ),
					'default'      => esc_html__('Show All Jobs', DZ_TH_DOMAIN),
				]
		);
		
		$this->add_control(
			'job_listing_2_element_link',
				[
					'label'  	   => esc_html__('Button Url'),
					'label_block'  => true,
					'type'         => \Elementor\Controls_Manager::TEXT,
					'placeholder'  => esc_html__( 'Enter your Button Url', DZ_TH_DOMAIN ),
				]
		
		);
		$this->add_control(
			'job_listing_2_element_image',
			[
				'label' 		=> esc_html__( 'Image', DZ_TH_DOMAIN ),
				'type' 			=> Controls_Manager::MEDIA,
				
			]
		);
		
		$this->end_controls_section();		
		
		/* Advance Section Start */
		$this->start_controls_section(
			'advance',
			[
				'label' => esc_html__( 'Advance', DZ_TH_DOMAIN ),
			]
		);				
		
		$this->add_control(
			'job_listing_2_element_no_of_posts',
			[
				'label' 		=> esc_html__( 'No. Of Posts Per Page', DZ_TH_DOMAIN ),
				'show_label'	=> true,
				'label_block' 	=> true,
				'type' 		 	=> Controls_Manager::NUMBER,
				'default'		=> 4,
				'title'			=>  esc_html__( 'No. Of Posts Per Page', DZ_TH_DOMAIN ),
				'description'	=> esc_html__( 'Enter no. of posts to show per page.', DZ_TH_DOMAIN ),
			]
		);
		
		
	
		
		$this->add_control(
			'job_listing_2_element_orderby',
			[
				'label' 		   => esc_html__( 'Order By', DZ_TH_DOMAIN ),
				'show_label'	   => true,
				'label_block' 	   => true,
				'type' 		 	   => Controls_Manager::SELECT,
				'options'		   => dz_get_orderby_options_list2(),
				'default'		   => 'date' ,
			]
		);
		
		$this->add_control(
			'job_listing_2_element_order',
			[
				'label' 	 => esc_html__( 'Order', DZ_TH_DOMAIN ),
				'show_label' => true,
				'label_block'=> true,
				'type' 		 => Controls_Manager::SELECT,
				'options'	 => dz_get_order_options_list(),
				'default'	 =>  'ASC',
			]
		);	
		
		$this->add_control(
			'job_listing_2_element_cols',
			[
				'label' 		=> esc_html__( 'Select Column', DZ_TH_DOMAIN ),
				'show_label'	=> true,
				'label_block' 	=> true,
				'type' 		 	=> Controls_Manager::SELECT,
				'options'		=> dz_get_column_options_list(),				
				'default'		=>  'col_3',
				'condition' => [
					'job_listing_2_element_style' => ['style_2'],
				],
			]
		);
		
		
		
		$this->end_controls_section();
		
	}
	
	protected function render() 
	{

        $settings = $this->get_settings_for_display();
      
		
		DZTemplate::show_dz_template('dz-inc/elementor/elements/job_listing_2_element.php',$settings);
	}
	
	protected function content_template() 
	{

    }
}