<?php

namespace DZElementor\Widgets;

use Elementor\Widget_Base;

use Elementor\Controls_Manager;

class DZJobMap extends Widget_Base 
{
	public function get_name() {
		return 'dz-job-map';
	}
	
	public function get_title() {
		return esc_html__('Job Map',DZ_TH_DOMAIN);
	}
	
	public function get_icon() {
		return 'eicon-google-maps';
	}
	
	public function get_categories() {
		return [ 'jobzilla' ];
	}
	
	protected function register_controls() {
		
	$this->start_controls_section(
			'general',
			[
				'label' => esc_html__( 'General', DZ_TH_DOMAIN ),
			]
		);
       
		
		$this->add_control(
		  'job_map_element_position',
				[
					'label' => esc_html__('Select Filter Position',DZ_TH_DOMAIN),
					'type' => Controls_Manager::SELECT ,
					'label_block' 	=> true,
					'options' => [
					   'dz-top-left' => esc_html__('Top Left', DZ_TH_DOMAIN),
					   'dz-top-right' => esc_html__('Top Right', DZ_TH_DOMAIN),
					   'dz-bottom-left' => esc_html__('Bottom Left', DZ_TH_DOMAIN),
					   'dz-bottom-right' => esc_html__('Bottom Right', DZ_TH_DOMAIN),
					   'dz-center' => esc_html__('Center', DZ_TH_DOMAIN),
					   'dz-top-center' => esc_html__('Center Top', DZ_TH_DOMAIN),
					   'dz-bottom-center' => esc_html__('Center Bottom', DZ_TH_DOMAIN),
					 
					],
					
					'description'	=> esc_html__( 'Choose your layout.', DZ_TH_DOMAIN ),
					'default' => 'dz-top-center',
				]
		); 
		
		$this->add_control(
		  'job_map_element_fit_to_height',
				[
					'label' => esc_html__('Fit To Screen',DZ_TH_DOMAIN),
					'type' => Controls_Manager::SELECT ,
					'label_block' 	=> true,
					'options' => [
					   'dz-fit-screen' => esc_html__('Fit To Height', DZ_TH_DOMAIN),
					   'custom' => esc_html__('Custom', DZ_TH_DOMAIN),  
					],
					'default' => 'dz-fit-screen',
				]
		); 
		
		$this->add_control(
			'job_map_element_height',
			[
				'label' 		=> esc_html__( 'Map Height (px)', DZ_TH_DOMAIN ),
				'label_block' 	=> true,
				'type' 			=> Controls_Manager::TEXT,
				'default' => 600,
				'condition' => [
					'job_map_element_fit_to_height' => ['custom'],
				],
				
			]
		);
		
		$this->add_control(
		  'job_map_element_map_filter_color',
				[
					'label' => esc_html__('Select Form Color',DZ_TH_DOMAIN),
					'type' => Controls_Manager::SELECT ,
					'label_block' 	=> true,
					'options' => [
					   'white' => esc_html__('White', DZ_TH_DOMAIN),
					   'bg-transparent' => esc_html__('Transparent ', DZ_TH_DOMAIN),
					],
					'default' => 'white',
					'description'	=> esc_html__( 'Choose Your color.', DZ_TH_DOMAIN ),
				]
		); 
		
		$this->add_control(
			'job_listing_map_element_search_btn',
			[
				'label' 		=> esc_html__( 'Search Button Text', DZ_TH_DOMAIN ),
				'label_block' 	=> true,
				'type' 			=> Controls_Manager::TEXT,
				'placeholder' 	=> esc_html__( 'Enter your Search Button Text', DZ_TH_DOMAIN ),
				'default'		=>  esc_html__( 'Find Jobs', DZ_TH_DOMAIN ),
			]
		);
		 
		$this->end_controls_section();  
	}
	protected function render() 
	{
		
        $settings = $this->get_settings_for_display();
		
		DZTemplate::show_dz_template('dz-inc/elementor/elements/job_map_element.php',$settings);
		
		echo "<script>
				jQuery(document).ready(function(){
					if(jQuery('.elementor-element-edit-mode').length > 0){
						jQuery('select').selectpicker();
					}					
				});
			 </script>
			";
	}
	
	
	protected function content_template() 
	{

    }
}