<?php 
namespace DZElementor\Widgets;

use Elementor\Widget_Base;

use Elementor\Controls_Manager;

class DZJobRegionSlider extends Widget_Base 
{
	public function get_name() {
		return 'dz-job-region-slider';
	}
	
	public function get_title() {
		return esc_html__('Job Region Slider',DZ_TH_DOMAIN);
	}
	
	public function get_icon() {
		return ' eicon-slider-full-screen';
	}
	
	public function get_categories() {
		return [ 'jobzilla' ];
	}
	
	protected function register_controls() {
		
		$this->start_controls_section(
			'general',
			[
				'label' => esc_html__( 'General', DZ_TH_DOMAIN ),
			]
		);
		
		$this->add_control(
			'job_region_slider_element_title',
			[
				'label' 		=> esc_html__( 'Title', DZ_TH_DOMAIN ),
				'label_block' 	=> true,
				'type' 			=> Controls_Manager::TEXT,
				'placeholder'	=> esc_html__( 'Enter your title', DZ_TH_DOMAIN ),
				'default' 		=> esc_html__( 'Find your favourite jobs and get.', DZ_TH_DOMAIN ),
			]
		);
		
		$this->add_control(
			'job_region_slider_element_subtitle',
			[
				'label' 		=> esc_html__( 'Subtitle', DZ_TH_DOMAIN ),
				'label_block' 	=> true,
				'type' 			=> Controls_Manager::TEXT,
				'placeholder'	=> esc_html__( 'Enter your Subtitle', DZ_TH_DOMAIN ),
				'default' 		=> esc_html__( 'Jobs by location', DZ_TH_DOMAIN ),
			]
		);
		
		$this->add_control(
			'job_region_slider_element_posts_in_categories',
			[
				'label' 		=> esc_html__( 'Include These Categories', DZ_TH_DOMAIN ),
				'show_label'	=> true,
				'label_block' 	=> true,
				'multiple' 		=> true,
				'type' 		 	=> Controls_Manager::SELECT2,
				'options'		=> dz_get_categories(array( 'taxonomy' => 'job_listing_region'),true),				
				'description'	=> esc_html__( 'Select multiple/ single categories', DZ_TH_DOMAIN ),
			]
		);
		$this->add_control(
			'job_region_slider_element_hide_empty',
			[
				'label' 		=> esc_html__( 'Hide no job cities', DZ_TH_DOMAIN ),
				'show_label'	=> true,
				'label_block' 	=> true,
				'type' 		 	=> Controls_Manager::SWITCHER,
				'return_value' 	=> 'yes',
				'description'	=> esc_html__( 'Enable to Hide no job cities.', DZ_TH_DOMAIN ),
			]
		);
		
		$this->add_control(
			'job_region_slider_element_link_title',
				[
					'label'  	   => esc_html__('Button Text'),
					'label_block'  => true,
					'type'         => \Elementor\Controls_Manager::TEXT,
					'placeholder'  => esc_html__( 'Enter your Button Text', DZ_TH_DOMAIN ),
					'default'      => esc_html__('View All Locations', DZ_TH_DOMAIN),
					
				]
		);
		
		$this->add_control(
			'job_region_slider_element_link',
				[
					'label'  	   => esc_html__('Button Url'),
					'label_block'  => true,
					'type'         => \Elementor\Controls_Manager::URL,
					'placeholder'  => esc_html__( 'Enter your Button Url', DZ_TH_DOMAIN ),
					
				]
		
		);
		
		$this->end_controls_section();

		$this->start_controls_section(
			'advance',
			[
				'label' => esc_html__( 'Advance', DZ_TH_DOMAIN ),
			]
		);
		$this->add_control(
			'job_region_slider_element_no_of_posts',
			[
				'label' 		=> esc_html__( 'No. Of Posts Per Page', DZ_TH_DOMAIN ),
				'show_label'	=> true,
				'label_block' 	=> true,
				'type' 		 	=> Controls_Manager::NUMBER,
				'default'		=> 8,
				'title'			=>  esc_html__( 'No. Of Posts Per Page', DZ_TH_DOMAIN ),
				'description'	=> esc_html__( 'Enter no. of posts to show per page.', DZ_TH_DOMAIN ),
			]
		);
		$this->add_control(
			'job_region_slider_element_order',
			[
				'label' 	 => esc_html__( 'Order', DZ_TH_DOMAIN ),
				'show_label' => true,
				'label_block'=> true,
				'type' 		 => Controls_Manager::SELECT,
				'options'	 => dz_get_order_options_list(),				
				'default'	 =>  'ASC',
			]
		);		
		$this->end_controls_section();	
	
	}
	
	protected function render() 
	{

        $settings = $this->get_settings_for_display();
		
		DZTemplate::show_dz_template('dz-inc/elementor/elements/job_region_slider_element.php',$settings);
		
		echo "<script>
				jQuery(document).ready(function(){
					if(jQuery('.elementor-element-edit-mode').length > 0){ 
						handleTwmFeaturedCityCarousal();
					}					
				});
			 </script>";
		
	}
	
	protected function content_template() 
	{

    }
}
?>