<?php 
namespace DZElementor\Widgets;

use Elementor\Widget_Base;

use Elementor\Controls_Manager;

class DZJobSearchForm extends Widget_Base 
{
	public function get_name() {
		return 'dz-job-search-form';
	}
	
	public function get_title() {
		return esc_html__('Job Search Form',DZ_TH_DOMAIN);
	}
	
	public function get_icon() {
		return 'eicon-search';
	}
	
	public function get_categories() {
		return [ 'jobzilla' ];
	}
	
	protected function register_controls() {

        $this->start_controls_section(
			'search',
			[
				'label' => esc_html__( 'Search Fields', DZ_TH_DOMAIN ),
			]
		);

        $this->add_control(
			'job_search_form_element_title',
			[
				'label' 		=> esc_html__( 'Search Job Title', DZ_TH_DOMAIN ),
				'show_label'	=> true,
				'label_block' 	=> true,
				'type' 		 	=> Controls_Manager::SWITCHER,
				'return_value' 	=> 'yes',
				'default' 		=>'yes',
				'description'	=> esc_html__( 'Enable to show Search Job Title.', DZ_TH_DOMAIN ),
			]
		);

		$this->add_control(
			'job_search_form_element_type',
			[
				'label' 		=> esc_html__( 'Search Job Category', DZ_TH_DOMAIN ),
				'show_label'	=> true,
				'label_block' 	=> true,
				'type' 		 	=> Controls_Manager::SWITCHER,
				'return_value' 	=> 'yes',
				'default' 		=>'yes',
				'description'	=> esc_html__( 'Enable to show Search Job Category.', DZ_TH_DOMAIN ),
			]
		);

		$this->add_control(
			'job_search_form_element_location',
			[
				'label' 		=> esc_html__( 'Search Job Location', DZ_TH_DOMAIN ),
				'show_label'	=> true,
				'label_block' 	=> true,
				'type' 		 	=> Controls_Manager::SWITCHER,
				'return_value' 	=> 'yes',
				'default' 		=>'yes',
				'description'	=> esc_html__( 'Enable to show Search Job Location.', DZ_TH_DOMAIN ),
			]
		);

		$this->add_control(
			'job_search_form_element_job_tags_title', [
				'label' 		=> esc_html__( 'Tags Title', DZ_TH_DOMAIN ),
				'type' 			=> \Elementor\Controls_Manager::TEXT,
				'default' 		=> esc_html__( 'Popular Searches:', DZ_TH_DOMAIN ),
				'label_block' 	=> true,
			]
		);

		$this->add_control(
			'job_search_form_element_job_tags',
			[
				'label' 		=> esc_html__( 'Job Tags', DZ_TH_DOMAIN ),
				'show_label'	=> true,
				'label_block' 	=> true,
				'type' 		 	=> Controls_Manager::SWITCHER,
				'return_value' 	=> 'yes',
				'default' 		=>'yes',
				'description'	=> esc_html__( 'Enable to show Job Tags.', DZ_TH_DOMAIN ),
			]
		);

		$this->end_controls_section();

		$this->start_controls_section(
			'slider',
			[
				'label' => esc_html__( 'Partner Slider', DZ_TH_DOMAIN ),
			]
		);

		$this->add_control(
			'job_search_form_element_partners_disable_link',
			[
				'label' 		=> esc_html__( 'Disable Hyperlink', DZ_TH_DOMAIN ),
				'show_label'	=> true,
				'label_block' 	=> true,
				'type' 		 	=> Controls_Manager::SWITCHER,
				'return_value' 	=> 'yes',
				'description'	=> esc_html__( 'Enable to Disable Hyperlink.', DZ_TH_DOMAIN ),
			]
		);
		
		$repeater = new \Elementor\Repeater();
		
		$repeater->add_control(
			'job_search_form_element_partners_item_link',
			[
				'label' 		=> esc_html__( 'Image Link', DZ_TH_DOMAIN ),
				'label_block' 	=> true,
				'type' 			=> Controls_Manager::TEXT,
				'placeholder'	=> esc_html__( 'Enter your Image Link', DZ_TH_DOMAIN ),
			]
		);
		
		$repeater->add_control(
			'job_search_form_element_partners_item_image',
			[
				'label' 		=> esc_html__( 'Upload Image', DZ_TH_DOMAIN ),
				'type' 			=> \Elementor\Controls_Manager::MEDIA,
			]
		);
		
		$this->add_control(
			'job_search_form_element_partners_item',
			[
				'label' 		=> esc_html__( 'Item List', DZ_TH_DOMAIN ),
				'type' 			=> \Elementor\Controls_Manager::REPEATER,
				'fields' 		=> $repeater->get_controls(),
				'default' 		=> [
					[
						'job_search_form_element_partners_item_link' 	=> 'https://www.google.com',
					],
					[
						'job_search_form_element_partners_item_link' 	=> 'https://www.google.com',	
					],
					[
						'job_search_form_element_partners_item_link' 	=> 'https://www.google.com',	
					],
					[
						'job_search_form_element_partners_item_link' 	=> 'https://www.google.com',	
					],
					[
						'job_search_form_element_partners_item_link' 	=> 'https://www.google.com',	
					],
					[
						'job_search_form_element_partners_item_link' 	=> 'https://www.google.com',	
					],					
				],
				'title_field' => '{{{ job_search_form_element_partners_item_link }}}'
			]
		);
        
        $this->end_controls_section();
	
	}
	
	protected function render() 
	{

        $settings = $this->get_settings_for_display();
		
		DZTemplate::show_dz_template('dz-inc/elementor/elements/job_search_form_element.php',$settings);
		echo "<script>
				jQuery(document).ready(function(){
					if(jQuery('.elementor-element-edit-mode').length > 0){
						jQuery('select').selectpicker();
					}					
				});
			 </script>
			";
	}
	
	protected function content_template() 
	{

    }
}
?>