<?php 
namespace DZElementor\Widgets;

use Elementor\Widget_Base;

use Elementor\Controls_Manager;

class DZPartners1 extends Widget_Base 
{
	public function get_name() {
		return 'dz-patners-1';
	}
	
	public function get_title() {
		return esc_html__('Partners 1',DZ_TH_DOMAIN);
	}
	
	public function get_icon() {
		return 'eicon-post-content';
	}
	
	public function get_categories() {
		return [ 'jobzilla' ];
	}
	
	protected function register_controls() {
		
		$this->start_controls_section(
			'general',
			[
				'label' => esc_html__( 'General', DZ_TH_DOMAIN ),
			]
		);	
		
		$this->add_control(
			'partners_1_element_title',
			[
				'label' 		=> esc_html__( 'Title', DZ_TH_DOMAIN ),
				'label_block' 	=> true,
				'type' 			=> Controls_Manager::TEXT,
				'placeholder'	=> esc_html__( 'Enter your title', DZ_TH_DOMAIN ),
			]
		);

		$this->add_control(
			'partners_1_element_subtitle',
			[
				'label' 		=> esc_html__( 'Subtitle', DZ_TH_DOMAIN ),
				'label_block' 	=> true,
				'type' 			=> Controls_Manager::TEXT,
				'placeholder'	=> esc_html__( 'Enter your title', DZ_TH_DOMAIN ),
			]
		);

		$this->add_control(
			'partners_1_element_disable_link',
			[
				'label' 		=> esc_html__( 'Disable Hyperlink', DZ_TH_DOMAIN ),
				'show_label'	=> true,
				'label_block' 	=> true,
				'type' 		 	=> Controls_Manager::SWITCHER,
				'return_value' 	=> 'yes',
				'description'	=> esc_html__( 'Enable to Disable Hyperlink.', DZ_TH_DOMAIN ),
			]
		);
		
		$this->add_control(
			'partners_1_element_style',
			[
				'label' 	 => esc_html__( 'Style', DZ_TH_DOMAIN ),
				'show_label' => true,
				'label_block'=> true,
				'type' 		 => Controls_Manager::SELECT,
				'options'	 => array(
                                'style_1'=>esc_html__('Style 1', DZ_TH_DOMAIN),
                                'style_2'=>esc_html__('Style 2', DZ_TH_DOMAIN),
                            ),
				'default'	 =>  'style_1',
			]
		);
		
		$this->end_controls_section();

		$this->start_controls_section(
			'slider',
			[
				'label' => esc_html__( 'Partner Slider', DZ_TH_DOMAIN ),
			]
		);
		
		$repeater = new \Elementor\Repeater();
		
		$repeater->add_control(
			'partners_1_element_item_link',
			[
				'label' 		=> esc_html__( 'Image Link', DZ_TH_DOMAIN ),
				'label_block' 	=> true,
				'type' 			=> Controls_Manager::TEXT,
				'placeholder'	=> esc_html__( 'Enter your Image Link', DZ_TH_DOMAIN ),
			]
		);
		
		$repeater->add_control(
			'partners_1_element_item_image',
			[
				'label' 		=> esc_html__( 'Upload Image', DZ_TH_DOMAIN ),
				'type' 			=> \Elementor\Controls_Manager::MEDIA,
			]
		);
		
		$this->add_control(
			'partners_1_element_item',
			[
				'label' 		=> esc_html__( 'Item List', DZ_TH_DOMAIN ),
				'type' 			=> \Elementor\Controls_Manager::REPEATER,
				'fields' 		=> $repeater->get_controls(),
				'default' 		=> [
					[
						'partners_1_element_item_link' 	=> 'https://www.google.com',
					],
					[
						'partners_1_element_item_link' 	=> 'https://www.google.com',	
					],
					[
						'partners_1_element_item_link' 	=> 'https://www.google.com',	
					],
					[
						'partners_1_element_item_link' 	=> 'https://www.google.com',	
					],
					[
						'partners_1_element_item_link' 	=> 'https://www.google.com',	
					],
					[
						'partners_1_element_item_link' 	=> 'https://www.google.com',	
					],					
				],
				'title_field' => '{{{ partners_1_element_item_link }}}'
			]
		);
        
        $this->end_controls_section();
	}
	
	protected function render() 
	{

        $settings = $this->get_settings_for_display();
		$style =  $settings['partners_1_element_style'];
		DZTemplate::show_dz_template('dz-inc/elementor/elements/partners_1_element.php',$settings);
		
		echo "<script>
				jQuery(document).ready(function(){
					if(jQuery('.elementor-element-edit-mode').length > 0){
			";
			
		if($style == 'style_1'){
			echo 'handleHomeClientCarousel2();';
		}else if($style == 'style_2'){				
			echo 'handleHomeClientCarousel4();';
		}
					
			echo "}					
			});
		 </script>
		";
	}
	
	protected function content_template() 
	{

    }
}
?>