<?php 
namespace DZElementor\Widgets;

use Elementor\Widget_Base;

use Elementor\Controls_Manager;

class DZPartners2 extends Widget_Base 
{
	public function get_name() {
		return 'dz-patners-2';
	}
	
	public function get_title() {
		return esc_html__('Partners 2',DZ_TH_DOMAIN);
	}
	
	public function get_icon() {
		return 'eicon-post-content';
	}
	
	public function get_categories() {
		return [ 'jobzilla' ];
	}
	
	protected function register_controls() {
		
		$this->start_controls_section(
			'general',
			[
				'label' => esc_html__( 'General', DZ_TH_DOMAIN ),
			]
		);	
		
		$this->add_control(
			'partners_2_element_title',
			[
				'label' 		=> esc_html__( 'Title', DZ_TH_DOMAIN ),
				'label_block' 	=> true,
				'type' 			=> Controls_Manager::TEXT,
				'placeholder'	=> esc_html__( 'Enter your title', DZ_TH_DOMAIN ),
				'default'		=> esc_html__( 'Get World 1500+ Talented People in one place',DZ_TH_DOMAIN),
			]
		);

		$this->add_control(
			'partners_2_element_subtitle',
			[
				'label' 		=> esc_html__( 'Subtitle', DZ_TH_DOMAIN ),
				'label_block' 	=> true,
				'type' 			=> Controls_Manager::TEXT,
				'placeholder'	=> esc_html__( 'Enter your title', DZ_TH_DOMAIN ),
				'default'		=> esc_html__( 'Get Jobs', DZ_TH_DOMAIN),
			]
		);
		
		$this->add_control(
			'partners_2_element_description',
			[
				'label' 		=> esc_html__( 'Enter Description.', DZ_TH_DOMAIN ),
				'show_label'	=> true,
				'label_block' 	=> true,
				'type' 		 	=> Controls_Manager::TEXTAREA,
				'placeholder'	=> esc_html__( 'Enter Description', DZ_TH_DOMAIN ),
				'default'		=> esc_html__( 'You need to create an account to find the best and preferred job. lorem
								Ipsum is simply dummy text of the printing and typesetting industry
								the standard dummy text ever took.', DZ_TH_DOMAIN ),
				'separator'		=>  'default',
				'rows'			=>  5,
				'description'	=> esc_html__( 'Enter Description Here', DZ_TH_DOMAIN ),
			]
		);
		$this->add_control(
			'partners_2_element_image',
			[
				'label' 		=> esc_html__( 'Image', DZ_TH_DOMAIN ),
				'type' 			=> Controls_Manager::MEDIA,
			]
		);
		$this->add_control(
			'partners_2_element_btn_text',
			[
				'label' 		=> esc_html__( 'Button Text', DZ_TH_DOMAIN ),
				'label_block' 	=> true,
				'type' 			=> Controls_Manager::TEXT,
				'placeholder'	=> esc_html__( 'Enter your title', DZ_TH_DOMAIN ),
				'default'		=> esc_html__( 'About More', DZ_TH_DOMAIN ),
			]
		);
		$this->add_control(
			'partners_2_element_btn_link',
			[
				'label' 		=> esc_html__( 'Button Link', DZ_TH_DOMAIN ),
				'label_block' 	=> true,
				'type' 			=> Controls_Manager::TEXT,
				'placeholder'	=> esc_html__( 'Enter your title', DZ_TH_DOMAIN ),
			]
		);
		$this->end_controls_section();

		$this->start_controls_section(
			'slider',
			[
				'label' => esc_html__( 'Partner Slider', DZ_TH_DOMAIN ),
			]
		);
		
		$this->add_control(
			'partners_2_element_item_slider',
			[
				'label' 		=> esc_html__( 'Slider(On/off)', DZ_TH_DOMAIN ),
				'show_label'	=> true,
				'type' 		 	=> Controls_Manager::SWITCHER,
				'default' 		=>'yes',
				'return_value' 	=> 'yes',
			]
		);	
		
		
		$this->add_control(
			'partners_2_element_item_title',
			[
				'label' 		=> esc_html__( 'Title', DZ_TH_DOMAIN ),
				'label_block' 	=> true,
				'type' 			=> Controls_Manager::TEXT,
				'placeholder'	=> esc_html__( 'Enter your title', DZ_TH_DOMAIN ),
				'default'		=> esc_html__( 'Trusted by more than +100 companies', DZ_TH_DOMAIN ),
			]
		);
		
		$repeater = new \Elementor\Repeater();
		
		$repeater->add_control(
			'partners_2_element_item_link',
			[
				'label' 		=> esc_html__( 'Image Link', DZ_TH_DOMAIN ),
				'label_block' 	=> true,
				'type' 			=> Controls_Manager::TEXT,
				'placeholder'	=> esc_html__( 'Enter your Image Link', DZ_TH_DOMAIN ),
			]
		);
		
		$repeater->add_control(
			'partners_2_element_item_image',
			[
				'label' 		=> esc_html__( 'Upload Image', DZ_TH_DOMAIN ),
				'type' 			=> \Elementor\Controls_Manager::MEDIA,
			]
		);
		
		$this->add_control(
			'partners_2_element_item',
			[
				'label' 		=> esc_html__( 'Item List', DZ_TH_DOMAIN ),
				'type' 			=> \Elementor\Controls_Manager::REPEATER,
				'fields' 		=> $repeater->get_controls(),
				'default' 		=> [
					[
						'partners_2_element_item_link' 	=> 'https://www.google.com',
					],
					[
						'partners_2_element_item_link' 	=> 'https://www.google.com',	
					],
					[
						'partners_2_element_item_link' 	=> 'https://www.google.com',	
					],
					[
						'partners_2_element_item_link' 	=> 'https://www.google.com',	
					],
					[
						'partners_2_element_item_link' 	=> 'https://www.google.com',	
					],
					[
						'partners_2_element_item_link' 	=> 'https://www.google.com',	
					],					
				],
				'title_field' => '{{{ partners_2_element_item_link }}}'
			]
		);
        
        $this->end_controls_section();
	}
	
	protected function render() 
	{

        $settings = $this->get_settings_for_display();
		DZTemplate::show_dz_template('dz-inc/elementor/elements/partners_2_element.php',$settings);
		
		echo "<script>
				jQuery(document).ready(function(){
					if(jQuery('.elementor-element-edit-mode').length > 0){
						handleHomeClientCarousel6();
					};	
				});
		 </script>
		";
	}
	
	protected function content_template() 
	{

    }
}
?>