<?php

namespace DZElementor\Widgets;

use Elementor\Widget_Base;

use Elementor\Controls_Manager;

class DZPostListing2 extends Widget_Base 
{
	public function get_name() {
		return 'dz-post-listing-2';
	}
	
	public function get_title() {
		return esc_html__('Post Listing 2',DZ_TH_DOMAIN);
	}
	
	public function get_icon() {
		return 'eicon-post-list';
		}
	
	public function get_categories() {
		return [ 'jobzilla' ];
	}
	
	protected function register_controls() {
		
		$this->start_controls_section(
			'general',
			[
				'label' => esc_html__( 'General', DZ_TH_DOMAIN ),
			]
		);
		
		$this->add_control(
			'post_listing_2_element_title',
			[
				'label' 		=> esc_html__( 'Title', DZ_TH_DOMAIN ),
				'label_block' 	=> true,
				'type' 			=> Controls_Manager::TEXT,
				'placeholder' 	=> esc_html__( 'Enter your title', DZ_TH_DOMAIN ),
				'default'		=>  esc_html__( 'INSIGHT AND TRENDS', DZ_TH_DOMAIN ),
			]
		);
		
		$this->add_control(
			'post_listing_2_element_subtitle',
			[
				'label' 		=> esc_html__( 'Subtitle', DZ_TH_DOMAIN ),
				'label_block' 	=> true,
				'type' 			=> Controls_Manager::TEXT,
				'placeholder' 	=> esc_html__( 'Enter your subtitle', DZ_TH_DOMAIN ),
				'default'		=>  esc_html__( 'Latest Articles Updated Daily', DZ_TH_DOMAIN ),
			]
		);
		
		$this->add_control(
			'post_listing_2_element_posts_in_categories',
			[
				'label' 		=> esc_html__( 'Include These Categories', DZ_TH_DOMAIN ),
				'show_label'	=> true,
				'label_block' 	=> true,
				'multiple' 		=> true,
				'type' 		 	=> Controls_Manager::SELECT2,
				'options'		=> dz_get_categories(array( 'taxonomy' => 'category'),true),	
				'description'	=> esc_html__( 'Select multiple/ single categories', DZ_TH_DOMAIN ),
			]
		);
		
		$this->add_control(
			'post_listing_2_element_only_featured_posts',
			[
				'label' 		=> esc_html__( 'Include Only Featured Posts', DZ_TH_DOMAIN ),
				'show_label'	=> true,
				'label_block' 	=> true,
				'type' 		 	=> Controls_Manager::SWITCHER,
				'return_value' 	=> 'yes',
				'description'	=> esc_html__( 'Choose to show only featured posts.', DZ_TH_DOMAIN ),
			]
		);
		
		
		$this->add_control(
			'post_listing_2_element_bg_img',
			[
				'label' 		=> esc_html__( 'Backgroung Image', DZ_TH_DOMAIN ),
				'type' 			=> Controls_Manager::MEDIA,
			]
		);
		
		
		$this->end_controls_section();		
		
		/* Advance Section Start */
		$this->start_controls_section(
			'advance',
			[
				'label' => esc_html__( 'Advance', DZ_TH_DOMAIN ),
			]
		);		
		
		$this->add_control(
			'post_listing_2_element_pagination_style',
			[
				'label' 	 => esc_html__( 'Pagination Style', DZ_TH_DOMAIN ),
				'show_label' => true,
				'label_block'=> true,
				'type' 		 => Controls_Manager::SELECT,
				'options'	 => dz_get_pagination_options_list(),				
				'default'	 =>  'no',
			]
		);		
		
		$this->add_control(
			'post_listing_2_element_no_of_posts',
			[
				'label' 		=> esc_html__( 'No. Of Posts Per Page', DZ_TH_DOMAIN ),
				'show_label'	=> true,
				'label_block' 	=> true,
				'type' 		 	=> Controls_Manager::NUMBER,
				'default'		=> 4,
				'title'			=>  esc_html__( 'No. Of Posts Per Page', DZ_TH_DOMAIN ),
				'description'	=> esc_html__( 'Enter no. of posts to show per page.', DZ_TH_DOMAIN ),
			]
		);
		
		$this->add_control(
			'post_listing_2_element_text_limit',
			[
				'label' 		=> esc_html__( 'Text Limit', DZ_TH_DOMAIN ),
				'show_label'	=> true,
				'label_block' 	=> true,
				'type' 		 	=> Controls_Manager::NUMBER,
				'default'		=> 20,
				'title'			=>  esc_html__( 'Text Limit', DZ_TH_DOMAIN ),
				'description'	=> esc_html__( 'Enter Text Limit', DZ_TH_DOMAIN ),
			]
		);
		
		
		$this->add_control(
			'post_listing_2_element_image_preference',
			[
				'label' 		=> esc_html__( 'Post Image Preference', DZ_TH_DOMAIN ),
				'show_label'	=> true,
				'label_block' 	=> true,
				'type' 		 	=> Controls_Manager::SELECT,
				'options'		=> dz_get_image_preference_options_list(),				
				'default'		=>  'image_post_only',
			]
		);
		
		
		$this->add_control(
			'post_listing_2_element_orderby',
			[
				'label' 		   => esc_html__( 'Order By', DZ_TH_DOMAIN ),
				'show_label'	   => true,
				'label_block' 	   => true,
				'type' 		 	   => Controls_Manager::SELECT,
				'options'		   => dz_get_orderby_options_list(),
				'default'		   => 'date' ,
			]
		);
		
		$this->add_control(
			'post_listing_2_element_order',
			[
				'label' 	 => esc_html__( 'Order', DZ_TH_DOMAIN ),
				'show_label' => true,
				'label_block'=> true,
				'type' 		 => Controls_Manager::SELECT,
				'options'	 => dz_get_order_options_list(),
				'default'	 =>  'ASC',
			]
		);		
		$this->end_controls_section();
		/* Advance Section END */	

		$this->start_controls_section(
			'extra',
			[
				'label' => esc_html__( 'Extra', DZ_TH_DOMAIN ),
			]
		);
		
		
		$this->add_control(
			'post_listing_2_element_cols',
			[
				'label' 		=> esc_html__( 'Select Column', DZ_TH_DOMAIN ),
				'show_label'	=> true,
				'label_block' 	=> true,
				'type' 		 	=> Controls_Manager::SELECT,
				'options'		=> dz_get_column_options_list(),				
				'default'		=>  'col_2',
			]
		);
		$this->end_controls_section(); 
		
		$this->start_controls_section(
			'sidebar',
			[
				'label' => esc_html__( 'Sidebar Section', DZ_TH_DOMAIN ),
			]
		);
		
		$this->add_control(
			'post_listing_2_element_selected_sidebar',
			[
				'label' 	 => esc_html__( 'Choose Sidebar', DZ_TH_DOMAIN ),
				'show_label' => true,
				'label_block'=> true,
				'type' 		 => Controls_Manager::SELECT,
				'options'	 => dz_get_selected_sidebar_options_list(),	
			]
		);
		
		$this->add_control(
			'post_listing_2_element_sidebar_layout',
			[
				'label' 	 => esc_html__( 'Sidebar Selection', DZ_TH_DOMAIN ),
				'show_label' => true,
				'label_block'=> true,
				'type' 		 => Controls_Manager::SELECT,
				'options'	 => dz_get_sidebar_layout_options_list(),				
				'default'	 =>  'left',
			]
		);

		$this->end_controls_section();	
	}
	
	protected function render() 
	{
        $settings = $this->get_settings_for_display();		
		DZTemplate::show_dz_template('dz-inc/elementor/elements/post_listing_2_element.php',$settings);
	}
	
	protected function content_template() 
	{

    }
}