<?php 
namespace DZElementor\Widgets;

use Elementor\Widget_Base;

use Elementor\Controls_Manager;

class DZPricingTable1 extends Widget_Base 
{
	public function get_name() {
		return 'dz-pricing-table-1';
	}
	
	public function get_title() {
		return esc_html__('Pricing Table 1',DZ_TH_DOMAIN);
	}
	
	public function get_icon() {
		return 'eicon-price-table';
	}
	
	public function get_categories() {
		return [ 'jobzilla' ];
	}
	
	protected function register_controls() {
		
		$this->start_controls_section(
			'general',
			[
				'label' => esc_html__( 'General', DZ_TH_DOMAIN ),
			]
		);
		
		$this->add_control(
			'pricing_table_1_element_sub_title',
			[
				'label' 		=> esc_html__( 'Subtitle', DZ_TH_DOMAIN ),
				'label_block' 	=> true,
				'type' 			=> Controls_Manager::TEXT,
				'placeholder'	=> esc_html__( 'Enter your subtitle', DZ_TH_DOMAIN ),
				'default' 		=> esc_html__( 'Choose Your Plan', DZ_TH_DOMAIN ),
			]
		);
		
		$this->add_control(
			'pricing_table_1_element_title',
			[
				'label' 		=> esc_html__( 'Title', DZ_TH_DOMAIN ),
				'label_block' 	=> true,
				'type' 			=> Controls_Manager::TEXT,
				'placeholder'	=> esc_html__( 'Enter your title', DZ_TH_DOMAIN ),
				'default' 		=> esc_html__( 'Save up to 10%', DZ_TH_DOMAIN ),
			]
		);
		
		$this->add_control(
			'pricing_table_1_element_btn_text',
			[
				'label' 		=> esc_html__( 'Button text', DZ_TH_DOMAIN ),
				'label_block' 	=> true,
				'type' 			=> Controls_Manager::TEXT,
				'placeholder'	=> esc_html__( 'Enter your text', DZ_TH_DOMAIN ),
				'default' 		=> esc_html__( ' Add Listing ', DZ_TH_DOMAIN ),
			]
		);
		$this->add_control(
			'pricing_table_1_element_text_color', [
				'label' 		=> esc_html__( 'Text Color', DZ_TH_DOMAIN ),
				'type' 			=> \Elementor\Controls_Manager::COLOR,
				'default' 		=> '#fff',
			]
		);		

		$this->end_controls_section();
		$this->start_controls_section(
			'advance',
			[
				'label' => esc_html__( 'Advance', DZ_TH_DOMAIN ),
			]
		);
		$this->add_control(
			'pricing_table_1_element_no_of_posts',
			[
				'label' 		=> esc_html__( 'No. Of Posts Per Page', DZ_TH_DOMAIN ),
				'show_label'	=> true,
				'label_block' 	=> true,
				'type' 		 	=> Controls_Manager::NUMBER,
				'title'			=>  esc_html__( 'No. Of Posts Per Page', DZ_TH_DOMAIN ),
				'description'	=> esc_html__( 'Enter no. of posts to show per page.', DZ_TH_DOMAIN ),
			]
		);
		$this->add_control(
			'pricing_table_1_element_orderby',
			[
				'label' 		   => esc_html__( 'Order By', DZ_TH_DOMAIN ),
				'show_label'	   => true,
				'label_block' 	   => true,
				'type' 		 	   => Controls_Manager::SELECT,
				'options'		   => dz_get_orderby_options_list2(),				
				'default'		   => 'date' ,
			]
		);
		
		$this->add_control(
			'pricing_table_1_element_order',
			[
				'label' 	 => esc_html__( 'Order', DZ_TH_DOMAIN ),
				'show_label' => true,
				'label_block'=> true,
				'type' 		 => Controls_Manager::SELECT,
				'options'	 => dz_get_order_options_list(),				
				'default'	 =>  'ASC',
			]
		);
		
		$this->end_controls_section();
		
		$this->start_controls_section(
			'extra',
			[
				'label' => esc_html__( 'Extra', DZ_TH_DOMAIN ),
			]
		);
		
		$this->add_control(
			'pricing_table_1_element_column',
			[
				'label' 		   => esc_html__( 'Section Column', DZ_TH_DOMAIN ),
				'show_label'	   => true,
				'label_block' 	   => true,
				'type' 		 	   => Controls_Manager::SELECT,
				'options'		   => dz_get_column_options_list(),				
				'default'		   => 'col_1' ,
			]
		);
		
		$this->end_controls_section();
	}
	
	protected function render() 
	{

        $settings = $this->get_settings_for_display();
		
		DZTemplate::show_dz_template('dz-inc/elementor/elements/pricing_table_1_element.php',$settings);
	}
	
	protected function content_template() 
	{

    }
}
?>