<?php 
namespace DZElementor\Widgets;

use Elementor\Widget_Base;

use Elementor\Controls_Manager;

class DZProcessFlow extends Widget_Base 
{
	public function get_name() {
		return 'dz-process-flow';
	}
	
	public function get_title() {
		return esc_html__('Process Flow',DZ_TH_DOMAIN);
	}
	
	public function get_icon() {
		return 'eicon-post-content';
	}
	
	public function get_categories() {
		return [ 'jobzilla' ];
	}
	
	protected function register_controls() {
		
		$this->start_controls_section(
			'general',
			[
				'label' => esc_html__( 'General', DZ_TH_DOMAIN ),
			]
		);
		
		$this->add_control(
			'process_flow_element_title',
			[
				'label' 		=> esc_html__( 'Title', DZ_TH_DOMAIN ),
				'label_block' 	=> true,
				'type' 			=> Controls_Manager::TEXT,
				'placeholder'	=> esc_html__( 'Enter your title', DZ_TH_DOMAIN ),
				'default' 		=> esc_html__( 'How It Works', DZ_TH_DOMAIN ),
			]
		);

		$this->add_control(
			'process_flow_element_subtitle',
			[
				'label' 		=> esc_html__( 'Subtitle', DZ_TH_DOMAIN ),
				'label_block' 	=> true,
				'type' 			=> Controls_Manager::TEXT,
				'placeholder'	=> esc_html__( 'Enter your title', DZ_TH_DOMAIN ),
				'default' 		=> esc_html__( 'Working Process', DZ_TH_DOMAIN ),
			]
		);

		$this->add_control(
			'process_flow_element_style',
			[
				'label' 	 => esc_html__( 'Style', DZ_TH_DOMAIN ),
				'show_label' => true,
				'label_block'=> true,
				'type' 		 => Controls_Manager::SELECT,
				'options'	 => array(
                                'style_1'=>esc_html__('Style 1', DZ_TH_DOMAIN),
                                'style_2'=>esc_html__('Style 2', DZ_TH_DOMAIN),
                                'style_3'=>esc_html__('Style 3', DZ_TH_DOMAIN),
                                'style_4'=>esc_html__('Style 4', DZ_TH_DOMAIN),
								'style_5'=>esc_html__('Style 5', DZ_TH_DOMAIN),
                            ),
				'default'	 =>  'style_1',
			]
		);		

		$this->add_control(
			'process_flow_element_description_list',
			[
				'label' 		=> esc_html__( 'Comma Seprated List', DZ_TH_DOMAIN ),
				'label_block' 	=> true,
				'type' 			=> Controls_Manager::TEXT,
				'placeholder' 	=> esc_html__( 'Enter your title', DZ_TH_DOMAIN ),
				'default'		=>  esc_html__( 'Trusted & Quality Job, International Job, No Extra Charge, Top Companies', DZ_TH_DOMAIN ),
				'condition' => [
					'process_flow_element_style' => ['style_2'],
				],
			]
		);

		$this->add_control(
			'process_flow_element_image',
			[
				'label' 		=> esc_html__( 'Image', DZ_TH_DOMAIN ),
				'type' 			=> \Elementor\Controls_Manager::MEDIA,
				'condition' => [
					'process_flow_element_style' => ['style_4','style_5'],
				],
			]
		);
		$this->end_controls_section();

		$this->start_controls_section(
			'counter',
			[
				'label' => esc_html__( 'Counter', DZ_TH_DOMAIN ),
			]
		);
		
		$repeater = new \Elementor\Repeater();
		
		$repeater->add_control(
			'process_flow_element_item_title',
			[
				'label' 		=> esc_html__( 'Title', DZ_TH_DOMAIN ),
				'label_block' 	=> true,
				'type' 			=> Controls_Manager::TEXT,
				'placeholder' 	=> esc_html__( 'Enter your title', DZ_TH_DOMAIN ),
				'default'		=>  esc_html__( 'Register', DZ_TH_DOMAIN ).'<br>'.esc_html__( 'Your Account', DZ_TH_DOMAIN ),
			]
		);
		
		$repeater->add_control(
			'process_flow_element_item_image',
			[
				'label' 		=> esc_html__( 'Image', DZ_TH_DOMAIN ),
				'type' 			=> \Elementor\Controls_Manager::MEDIA,
			]
		);
		
		$repeater->add_control(
			'process_flow_element_item_description',
			[
				'label' 		=> esc_html__( 'Description', DZ_TH_DOMAIN ),
				'label_block' 	=> true,
				'type' 			=> Controls_Manager::TEXT,
				'placeholder' 	=> esc_html__( 'Enter your title', DZ_TH_DOMAIN ),
				'default'		=>  esc_html__( 'You need to create an account to find the best and preferred job.', DZ_TH_DOMAIN ),
			]
		);
		
		$this->add_control(
			'process_flow_element_item',
			[
				'label' 		=> esc_html__( 'Item List', DZ_TH_DOMAIN ),
				'type' 			=> \Elementor\Controls_Manager::REPEATER,
				'fields' 		=> $repeater->get_controls(),
				'default' 		=> [
					[
						'process_flow_element_item_title' 	=> esc_html__( 'Register', DZ_TH_DOMAIN ).'<br>'.esc_html__( 'Your Account', DZ_TH_DOMAIN ),
						'process_flow_element_item_description' => esc_html__( 'You need to create an account to find the best and preferred job.', DZ_TH_DOMAIN ),	
					],
					[
						'process_flow_element_item_title' 	=> esc_html__( 'Apply', DZ_TH_DOMAIN ).'<br>'.esc_html__( 'For Dream Job', DZ_TH_DOMAIN ),
						'process_flow_element_item_description' => esc_html__( 'You need to create an account to find the best and preferred job.', DZ_TH_DOMAIN ),	
					],
					[
						'process_flow_element_item_title' 	=> esc_html__( 'Upload', DZ_TH_DOMAIN ).'<br>'.esc_html__( 'Your Resume', DZ_TH_DOMAIN ),
						'process_flow_element_item_description' => esc_html__( 'You need to create an account to find the best and preferred job.', DZ_TH_DOMAIN ),	
					],
					
				],
				'title_field' => '{{{ process_flow_element_item_title }}}'
			]
		);
        
        $this->end_controls_section();	
	}
	
	protected function render() 
	{

        $settings = $this->get_settings_for_display();
		
		DZTemplate::show_dz_template('dz-inc/elementor/elements/process_flow_element.php',$settings);
	}
	
	protected function content_template() 
	{

    }
}
?>